/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.indexing;

import java.io.File;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.indexing.TuningConfig;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class RealtimeTuningConfigTest {
    @Test
    public void testDefaultBasePersistDirectory() {
        RealtimeTuningConfig tuningConfig1 = RealtimeTuningConfig.makeDefaultTuningConfig(null);
        RealtimeTuningConfig tuningConfig2 = RealtimeTuningConfig.makeDefaultTuningConfig(null);
        Assert.assertNotEquals((Object)tuningConfig1.getBasePersistDirectory(), (Object)tuningConfig2.getBasePersistDirectory());
    }

    @Test
    public void testSpecificBasePersistDirectory() {
        RealtimeTuningConfig tuningConfig = RealtimeTuningConfig.makeDefaultTuningConfig((File)new File("/tmp/nonexistent"));
        Assert.assertEquals((Object)new File("/tmp/nonexistent"), (Object)tuningConfig.getBasePersistDirectory());
    }

    @Test
    public void testSerdeWithDefaults() throws Exception {
        String jsonStr = "{\"type\":\"realtime\"}";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        RealtimeTuningConfig config = (RealtimeTuningConfig)mapper.readValue(mapper.writeValueAsString(mapper.readValue(jsonStr, TuningConfig.class)), TuningConfig.class);
        Assert.assertNotNull((Object)config.getBasePersistDirectory());
        Assert.assertEquals((long)0L, (long)config.getHandoffConditionTimeout());
        Assert.assertEquals((long)0L, (long)config.getAlertTimeout());
        Assert.assertEquals((Object)new IndexSpec(), (Object)config.getIndexSpec());
        Assert.assertEquals((Object)new Period((Object)"PT10M"), (Object)config.getIntermediatePersistPeriod());
        Assert.assertEquals((Object)NoneShardSpec.instance(), (Object)config.getShardSpec());
        Assert.assertEquals((long)0L, (long)config.getMaxPendingPersists());
        Assert.assertEquals((long)75000L, (long)config.getMaxRowsInMemory());
        Assert.assertEquals((long)0L, (long)config.getMergeThreadPriority());
        Assert.assertEquals((long)0L, (long)config.getPersistThreadPriority());
        Assert.assertEquals((Object)new Period((Object)"PT10M"), (Object)config.getWindowPeriod());
        Assert.assertEquals((Object)false, (Object)config.isReportParseExceptions());
    }

    @Test
    public void testSerdeWithNonDefaults() throws Exception {
        String jsonStr = "{\n  \"type\": \"realtime\",\n  \"maxRowsInMemory\": 100,\n  \"intermediatePersistPeriod\": \"PT1H\",\n  \"windowPeriod\": \"PT1H\",\n  \"basePersistDirectory\": \"/tmp/xxx\",\n  \"maxPendingPersists\": 100,\n  \"persistThreadPriority\": 100,\n  \"mergeThreadPriority\": 100,\n  \"reportParseExceptions\": true,\n  \"handoffConditionTimeout\": 100,\n  \"alertTimeout\": 70\n}";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        RealtimeTuningConfig config = (RealtimeTuningConfig)mapper.readValue(mapper.writeValueAsString(mapper.readValue(jsonStr, TuningConfig.class)), TuningConfig.class);
        Assert.assertEquals((Object)"/tmp/xxx", (Object)config.getBasePersistDirectory().toString());
        Assert.assertEquals((long)100L, (long)config.getHandoffConditionTimeout());
        Assert.assertEquals((long)70L, (long)config.getAlertTimeout());
        Assert.assertEquals((Object)new IndexSpec(), (Object)config.getIndexSpec());
        Assert.assertEquals((Object)new Period((Object)"PT1H"), (Object)config.getIntermediatePersistPeriod());
        Assert.assertEquals((Object)NoneShardSpec.instance(), (Object)config.getShardSpec());
        Assert.assertEquals((long)100L, (long)config.getMaxPendingPersists());
        Assert.assertEquals((long)100L, (long)config.getMaxRowsInMemory());
        Assert.assertEquals((long)100L, (long)config.getMergeThreadPriority());
        Assert.assertEquals((long)100L, (long)config.getPersistThreadPriority());
        Assert.assertEquals((Object)new Period((Object)"PT1H"), (Object)config.getWindowPeriod());
        Assert.assertEquals((Object)true, (Object)config.isReportParseExceptions());
    }
}

