/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.incremental;

import java.util.ArrayList;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.Rowboat;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.BitmapValues;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.IncrementalIndexTest;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexAdapter;
import org.junit.Assert;
import org.junit.Test;

public class IncrementalIndexAdapterTest {
    private static final IndexSpec INDEX_SPEC = new IndexSpec((BitmapSerdeFactory)new ConciseBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZ4, CompressionFactory.LongEncodingStrategy.LONGS);

    @Test
    public void testGetBitmapIndex() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex incrementalIndex = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, incrementalIndex);
        IncrementalIndexAdapter adapter = new IncrementalIndexAdapter(incrementalIndex.getInterval(), incrementalIndex, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        String dimension = "dim1";
        for (int i = 0; i < adapter.getDimValueLookup(dimension).size(); ++i) {
            BitmapValues bitmapValues = adapter.getBitmapValues(dimension, i);
            Assert.assertEquals((long)1L, (long)bitmapValues.size());
        }
    }

    @Test
    public void testGetRowsIterable() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), toPersist1, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        Iterable boats = incrementalAdapter.getRows();
        ArrayList<Rowboat> boatList = new ArrayList<Rowboat>();
        for (Rowboat boat : boats) {
            boatList.add(boat);
        }
        Assert.assertEquals((long)2L, (long)boatList.size());
        Assert.assertEquals((long)0L, (long)((Rowboat)boatList.get(0)).getRowNum());
        Assert.assertEquals((long)1L, (long)((Rowboat)boatList.get(1)).getRowNum());
        boatList = new ArrayList();
        for (Rowboat boat : boats) {
            boatList.add(boat);
        }
        boatList = new ArrayList();
        for (Rowboat boat : boats) {
            boatList.add(boat);
        }
        boatList = new ArrayList();
        for (Rowboat boat : boats) {
            boatList.add(boat);
        }
        boatList = new ArrayList();
        for (Rowboat boat : boats) {
            boatList.add(boat);
        }
        Assert.assertEquals((long)2L, (long)boatList.size());
        Assert.assertEquals((long)0L, (long)((Rowboat)boatList.get(0)).getRowNum());
        Assert.assertEquals((long)1L, (long)((Rowboat)boatList.get(1)).getRowNum());
    }
}

