/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.collections.spatial.search.Bound;
import org.apache.hive.druid.io.druid.collections.spatial.search.RadiusBound;
import org.apache.hive.druid.io.druid.collections.spatial.search.RectangularBound;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.SpatialDimensionSchema;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.SpatialDimFilter;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexMergerV9;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Interval;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SpatialFilterBonusTest {
    public static final int NUM_POINTS = 5000;
    private static Interval DATA_INTERVAL = Intervals.of((String)"2013-01-01/2013-01-07");
    private static AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val")};
    private static List<String> DIMS = Lists.newArrayList((Object[])new String[]{"dim", "dim.geo"});
    private final Segment segment;

    public SpatialFilterBonusTest(Segment segment) {
        this.segment = segment;
    }

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        ArrayList<Object[]> argumentArrays = new ArrayList<Object[]>();
        for (SegmentWriteOutMediumFactory segmentWriteOutMediumFactory : SegmentWriteOutMediumFactory.builtInFactories()) {
            IndexMergerV9 indexMerger = TestHelper.getTestIndexMergerV9(segmentWriteOutMediumFactory);
            IndexIO indexIO = TestHelper.getTestIndexIO(segmentWriteOutMediumFactory);
            IndexSpec indexSpec = new IndexSpec();
            IncrementalIndex rtIndex = SpatialFilterBonusTest.makeIncrementalIndex();
            QueryableIndex mMappedTestIndex = SpatialFilterBonusTest.makeQueryableIndex(indexSpec, (IndexMerger)indexMerger, indexIO);
            QueryableIndex mergedRealtimeIndex = SpatialFilterBonusTest.makeMergedQueryableIndex(indexSpec, (IndexMerger)indexMerger, indexIO);
            argumentArrays.add(new Object[]{new IncrementalIndexSegment(rtIndex, null)});
            argumentArrays.add(new Object[]{new QueryableIndexSegment(null, mMappedTestIndex)});
            argumentArrays.add(new Object[]{new QueryableIndexSegment(null, mergedRealtimeIndex)});
        }
        return argumentArrays;
    }

    private static IncrementalIndex makeIncrementalIndex() throws IOException {
        IncrementalIndex theIndex = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(new DimensionsSpec(null, null, Arrays.asList(new SpatialDimensionSchema("dim.geo", (List)Lists.newArrayList())))).build()).setReportParseExceptions(false).setMaxRowCount(5000).buildOnheap();
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"0.0,0.0", (Object)"val", (Object)17L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-02").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-02").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"1.0,3.0", (Object)"val", (Object)29L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-03").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-03").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"4.0,2.0", (Object)"val", (Object)13L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-04").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-04").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"7.0,3.0", (Object)"val", (Object)91L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"8.0,6.0", (Object)"val", (Object)47L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"_mmx.unknown", (Object)"val", (Object)501L)));
        HashSet alreadyChosen = Sets.newHashSet();
        Random rand = new Random();
        for (int i = 6; i < 5000; ++i) {
            String coord = null;
            while (coord == null) {
                coord = StringUtils.format((String)"%s,%s", (Object[])new Object[]{Float.valueOf((float)((double)(rand.nextFloat() * 10.0f) + 10.0)), Float.valueOf((float)((double)(rand.nextFloat() * 10.0f) + 10.0))});
                if (alreadyChosen.add(coord)) continue;
                coord = null;
            }
            theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"boo", (Object)"dim.geo", coord, (Object)"val", (Object)i)));
        }
        return theIndex;
    }

    private static QueryableIndex makeQueryableIndex(IndexSpec indexSpec, IndexMerger indexMerger, IndexIO indexIO) throws IOException {
        IncrementalIndex theIndex = SpatialFilterBonusTest.makeIncrementalIndex();
        File tmpFile = File.createTempFile("billy", "yay");
        tmpFile.delete();
        tmpFile.mkdirs();
        tmpFile.deleteOnExit();
        indexMerger.persist(theIndex, tmpFile, indexSpec, null);
        return indexIO.loadIndex(tmpFile);
    }

    private static QueryableIndex makeMergedQueryableIndex(IndexSpec indexSpec, IndexMerger indexMerger, IndexIO indexIO) {
        try {
            IncrementalIndex first = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(new DimensionsSpec(null, null, Arrays.asList(new SpatialDimensionSchema("dim.geo", (List)Lists.newArrayList())))).build()).setReportParseExceptions(false).setMaxRowCount(5000).buildOnheap();
            IncrementalIndex second = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(new DimensionsSpec(null, null, Arrays.asList(new SpatialDimensionSchema("dim.geo", (List)Lists.newArrayList())))).build()).setReportParseExceptions(false).setMaxRowCount(5000).buildOnheap();
            IncrementalIndex third = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(new DimensionsSpec(null, null, Arrays.asList(new SpatialDimensionSchema("dim.geo", (List)Lists.newArrayList())))).build()).setReportParseExceptions(false).setMaxRowCount(5000).buildOnheap();
            first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"0.0,0.0", (Object)"val", (Object)17L)));
            first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-02").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-02").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"1.0,3.0", (Object)"val", (Object)29L)));
            first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-03").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-03").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"4.0,2.0", (Object)"val", (Object)13L)));
            first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"_mmx.unknown", (Object)"val", (Object)501L)));
            second.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-04").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-04").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"7.0,3.0", (Object)"val", (Object)91L)));
            second.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"8.0,6.0", (Object)"val", (Object)47L)));
            Random rand = new Random();
            for (int i = 6; i < 5000; ++i) {
                third.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"boo", (Object)"dim.geo", (Object)StringUtils.format((String)"%s,%s", (Object[])new Object[]{Float.valueOf((float)((double)(rand.nextFloat() * 10.0f) + 10.0)), Float.valueOf((float)((double)(rand.nextFloat() * 10.0f) + 10.0))}), (Object)"val", (Object)i)));
            }
            File tmpFile = File.createTempFile("yay", "who");
            tmpFile.delete();
            File firstFile = new File(tmpFile, "first");
            File secondFile = new File(tmpFile, "second");
            File thirdFile = new File(tmpFile, "third");
            File mergedFile = new File(tmpFile, "merged");
            firstFile.mkdirs();
            firstFile.deleteOnExit();
            secondFile.mkdirs();
            secondFile.deleteOnExit();
            thirdFile.mkdirs();
            thirdFile.deleteOnExit();
            mergedFile.mkdirs();
            mergedFile.deleteOnExit();
            indexMerger.persist(first, DATA_INTERVAL, firstFile, indexSpec, null);
            indexMerger.persist(second, DATA_INTERVAL, secondFile, indexSpec, null);
            indexMerger.persist(third, DATA_INTERVAL, thirdFile, indexSpec, null);
            QueryableIndex mergedRealtime = indexIO.loadIndex(indexMerger.mergeQueryableIndex(Arrays.asList(indexIO.loadIndex(firstFile), indexIO.loadIndex(secondFile), indexIO.loadIndex(thirdFile)), true, METRIC_AGGS, mergedFile, indexSpec, null));
            return mergedRealtime;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Test
    public void testSpatialQuery() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.ALL).intervals(Arrays.asList(Intervals.of((String)"2013-01-01/2013-01-07"))).filters((DimFilter)new SpatialDimFilter("dim.geo", (Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f))).aggregators(Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val"))).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2013-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)3L).put((Object)"val", (Object)59L).build())));
        try {
            TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner(this.segment), factory.getToolchest());
            HashMap context = new HashMap();
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query), context));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Test
    public void testSpatialQueryMorePoints() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.DAY).intervals(Arrays.asList(Intervals.of((String)"2013-01-01/2013-01-07"))).filters((DimFilter)new SpatialDimFilter("dim.geo", (Bound)new RectangularBound(new float[]{0.0f, 0.0f}, new float[]{9.0f, 9.0f}))).aggregators(Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val"))).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2013-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)17L).build())), new Result(DateTimes.of((String)"2013-01-02T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)29L).build())), new Result(DateTimes.of((String)"2013-01-03T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)13L).build())), new Result(DateTimes.of((String)"2013-01-04T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)91L).build())), new Result(DateTimes.of((String)"2013-01-05T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)47L).build())));
        try {
            TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner(this.segment), factory.getToolchest());
            HashMap context = new HashMap();
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query), context));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Test
    public void testSpatialQueryFilteredAggregator() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.DAY).intervals(Arrays.asList(Intervals.of((String)"2013-01-01/2013-01-07"))).aggregators(Arrays.asList(new CountAggregatorFactory("rows"), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("valFiltered", "val"), (DimFilter)new SpatialDimFilter("dim.geo", (Bound)new RectangularBound(new float[]{0.0f, 0.0f}, new float[]{9.0f, 9.0f}))), new LongSumAggregatorFactory("val", "val"))).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2013-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)4995L).put((Object)"val", (Object)12497502L).put((Object)"valFiltered", (Object)17L).build())), new Result(DateTimes.of((String)"2013-01-02T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)29L).put((Object)"valFiltered", (Object)29L).build())), new Result(DateTimes.of((String)"2013-01-03T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)13L).put((Object)"valFiltered", (Object)13L).build())), new Result(DateTimes.of((String)"2013-01-04T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)91L).put((Object)"valFiltered", (Object)91L).build())), new Result(DateTimes.of((String)"2013-01-05T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"val", (Object)548L).put((Object)"valFiltered", (Object)47L).build())));
        try {
            TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner(this.segment), factory.getToolchest());
            HashMap context = new HashMap();
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query), context));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

