/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import org.apache.hive.druid.io.druid.segment.data.VSizeColumnarInts;
import org.junit.Assert;
import org.junit.Test;

public class VSizeColumnarIntsTest {
    @Test
    public void testSanity() throws Exception {
        int[] array = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        VSizeColumnarInts ints = VSizeColumnarInts.fromArray((int[])array);
        Assert.assertEquals((long)1L, (long)ints.getNumBytes());
        Assert.assertEquals((long)array.length, (long)ints.size());
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((long)array[i], (long)ints.get(i));
        }
    }

    @Test
    public void testSerialization() throws Exception {
        int[] array = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        VSizeColumnarInts ints = VSizeColumnarInts.fromArray((int[])array);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ints.writeTo(Channels.newChannel(baos), null);
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)ints.getSerializedSize(), (long)bytes.length);
        VSizeColumnarInts deserialized = VSizeColumnarInts.readFromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes));
        Assert.assertEquals((long)1L, (long)deserialized.getNumBytes());
        Assert.assertEquals((long)array.length, (long)deserialized.size());
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((long)array[i], (long)deserialized.get(i));
        }
    }
}

