/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.io.CharSource;
import org.apache.hive.druid.com.google.common.io.LineProcessor;
import org.apache.hive.druid.com.google.common.io.Resources;
import org.apache.hive.druid.io.druid.data.input.impl.DelimitedParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.FloatDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.LongDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.hll.HyperLogLogHash;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.hive.druid.io.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetrics;
import org.apache.hive.druid.io.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.hive.druid.io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Interval;

public class TestIndex {
    public static final String[] COLUMNS = new String[]{"ts", "market", "quality", "qualityLong", "qualityFloat", "qualityDouble", "qualityNumericString", "placement", "placementish", "index", "partial_null_column", "null_column", "quality_uniques", "indexMin", "indexMaxPlusTen"};
    public static final String[] DIMENSIONS = new String[]{"market", "quality", "qualityLong", "qualityFloat", "qualityDouble", "qualityNumericString", "placement", "placementish", "partial_null_column", "null_column"};
    public static final List<DimensionSchema> DIMENSION_SCHEMAS = Arrays.asList(new StringDimensionSchema("market"), new StringDimensionSchema("quality"), new LongDimensionSchema("qualityLong"), new FloatDimensionSchema("qualityFloat"), new DoubleDimensionSchema("qualityDouble"), new StringDimensionSchema("qualityNumericString"), new StringDimensionSchema("placement"), new StringDimensionSchema("placementish"), new StringDimensionSchema("partial_null_column"), new StringDimensionSchema("null_column"));
    public static final DimensionsSpec DIMENSIONS_SPEC = new DimensionsSpec(DIMENSION_SCHEMAS, null, null);
    public static final String[] DOUBLE_METRICS = new String[]{"index", "indexMin", "indexMaxPlusTen"};
    public static final String[] FLOAT_METRICS = new String[]{"indexFloat", "indexMinFloat", "indexMaxFloat"};
    private static final Logger log = new Logger(TestIndex.class);
    private static final Interval DATA_INTERVAL = Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z");
    private static final VirtualColumns VIRTUAL_COLUMNS = VirtualColumns.create(Collections.singletonList(new ExpressionVirtualColumn("expr", "index + 10", ValueType.FLOAT, TestExprMacroTable.INSTANCE)));
    public static final AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new DoubleSumAggregatorFactory(DOUBLE_METRICS[0], "index"), new FloatSumAggregatorFactory(FLOAT_METRICS[0], "index"), new DoubleMinAggregatorFactory(DOUBLE_METRICS[1], "index"), new FloatMinAggregatorFactory(FLOAT_METRICS[1], "index"), new FloatMaxAggregatorFactory(FLOAT_METRICS[2], "index"), new DoubleMaxAggregatorFactory(DOUBLE_METRICS[2], VIRTUAL_COLUMNS.getVirtualColumns()[0].getOutputName()), new HyperUniquesAggregatorFactory("quality_uniques", "quality")};
    private static final IndexSpec indexSpec = new IndexSpec();
    private static final IndexMerger INDEX_MERGER = TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
    private static final IndexIO INDEX_IO = TestHelper.getTestIndexIO((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
    private static IncrementalIndex realtimeIndex;
    private static IncrementalIndex noRollupRealtimeIndex;
    private static QueryableIndex mmappedIndex;
    private static QueryableIndex noRollupMmappedIndex;
    private static QueryableIndex mergedRealtime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncrementalIndex getIncrementalTestIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (realtimeIndex != null) {
                return realtimeIndex;
            }
        }
        realtimeIndex = TestIndex.makeRealtimeIndex("druid.sample.numeric.tsv");
        return realtimeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncrementalIndex getNoRollupIncrementalTestIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (noRollupRealtimeIndex != null) {
                return noRollupRealtimeIndex;
            }
        }
        noRollupRealtimeIndex = TestIndex.makeRealtimeIndex("druid.sample.numeric.tsv", false);
        return noRollupRealtimeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryableIndex getMMappedTestIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (mmappedIndex != null) {
                return mmappedIndex;
            }
        }
        IncrementalIndex incrementalIndex = TestIndex.getIncrementalTestIndex();
        mmappedIndex = TestIndex.persistRealtimeAndLoadMMapped(incrementalIndex);
        return mmappedIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryableIndex getNoRollupMMappedTestIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (noRollupMmappedIndex != null) {
                return noRollupMmappedIndex;
            }
        }
        IncrementalIndex incrementalIndex = TestIndex.getNoRollupIncrementalTestIndex();
        noRollupMmappedIndex = TestIndex.persistRealtimeAndLoadMMapped(incrementalIndex);
        return noRollupMmappedIndex;
    }

    public static QueryableIndex mergedRealtimeIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (mergedRealtime != null) {
                return mergedRealtime;
            }
            try {
                IncrementalIndex top = TestIndex.makeRealtimeIndex("druid.sample.numeric.tsv.top");
                IncrementalIndex bottom = TestIndex.makeRealtimeIndex("druid.sample.numeric.tsv.bottom");
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File topFile = new File(tmpFile, "top");
                File bottomFile = new File(tmpFile, "bottom");
                File mergedFile = new File(tmpFile, "merged");
                topFile.mkdirs();
                topFile.deleteOnExit();
                bottomFile.mkdirs();
                bottomFile.deleteOnExit();
                mergedFile.mkdirs();
                mergedFile.deleteOnExit();
                INDEX_MERGER.persist(top, DATA_INTERVAL, topFile, indexSpec, null);
                INDEX_MERGER.persist(bottom, DATA_INTERVAL, bottomFile, indexSpec, null);
                mergedRealtime = INDEX_IO.loadIndex(INDEX_MERGER.mergeQueryableIndex(Arrays.asList(INDEX_IO.loadIndex(topFile), INDEX_IO.loadIndex(bottomFile)), true, METRIC_AGGS, mergedFile, indexSpec, null));
                return mergedRealtime;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static IncrementalIndex makeRealtimeIndex(String resourceFilename) {
        return TestIndex.makeRealtimeIndex(resourceFilename, true);
    }

    public static IncrementalIndex makeRealtimeIndex(String resourceFilename, boolean rollup) {
        URL resource = TestIndex.class.getClassLoader().getResource(resourceFilename);
        if (resource == null) {
            throw new IllegalArgumentException("cannot find resource " + resourceFilename);
        }
        log.info("Realtime loading index file[%s]", new Object[]{resource});
        CharSource stream = Resources.asByteSource((URL)resource).asCharSource(Charsets.UTF_8);
        return TestIndex.makeRealtimeIndex(stream, rollup);
    }

    public static IncrementalIndex makeRealtimeIndex(CharSource source) {
        return TestIndex.makeRealtimeIndex(source, true);
    }

    public static IncrementalIndex makeRealtimeIndex(CharSource source, boolean rollup) {
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2011-01-12T00:00:00.000Z").getMillis()).withTimestampSpec(new TimestampSpec("ds", "auto", null)).withDimensionsSpec(DIMENSIONS_SPEC).withVirtualColumns(VIRTUAL_COLUMNS).withMetrics(METRIC_AGGS).withRollup(rollup).build();
        IncrementalIndex retVal = new IncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(10000).buildOnheap();
        try {
            return TestIndex.loadIncrementalIndex(retVal, source);
        }
        catch (Exception e) {
            if (rollup) {
                realtimeIndex = null;
            } else {
                noRollupRealtimeIndex = null;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static IncrementalIndex loadIncrementalIndex(IncrementalIndex retVal, CharSource source) throws IOException {
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new DelimitedParseSpec(new TimestampSpec("ts", "iso", null), new DimensionsSpec(DIMENSION_SCHEMAS, null, null), "\t", "\u0001", Arrays.asList(COLUMNS), false, 0), "utf8");
        return TestIndex.loadIncrementalIndex(retVal, source, parser);
    }

    public static IncrementalIndex loadIncrementalIndex(final IncrementalIndex retVal, CharSource source, final StringInputRowParser parser) throws IOException {
        final AtomicLong startTime = new AtomicLong();
        int lineCount = (Integer)source.readLines((LineProcessor)new LineProcessor<Integer>(){
            boolean runOnce = false;
            int lineCount = 0;

            public boolean processLine(String line) throws IOException {
                if (!this.runOnce) {
                    startTime.set(System.currentTimeMillis());
                    this.runOnce = true;
                }
                retVal.add(parser.parse(line));
                ++this.lineCount;
                return true;
            }

            public Integer getResult() {
                return this.lineCount;
            }
        });
        log.info("Loaded %,d lines in %,d millis.", new Object[]{lineCount, System.currentTimeMillis() - startTime.get()});
        return retVal;
    }

    public static QueryableIndex persistRealtimeAndLoadMMapped(IncrementalIndex index) {
        try {
            File someTmpFile = File.createTempFile("billy", "yay");
            someTmpFile.delete();
            someTmpFile.mkdirs();
            someTmpFile.deleteOnExit();
            INDEX_MERGER.persist(index, someTmpFile, indexSpec, null);
            return INDEX_IO.loadIndex(someTmpFile);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        if (ComplexMetrics.getSerdeForType((String)"hyperUnique") == null) {
            ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde(HyperLogLogHash.getDefault()));
        }
        realtimeIndex = null;
        noRollupRealtimeIndex = null;
        mmappedIndex = null;
        noRollupMmappedIndex = null;
        mergedRealtime = null;
    }
}

