/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.util.Iterator;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.data.ArrayIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.junit.Assert;
import org.junit.Test;

public class DictionaryMergeIteratorTest {
    @Test
    public void basicTest() throws Exception {
        Object[] s1 = new String[]{"a", "c", "d", "e"};
        Object[] s2 = new String[]{"b", "c", "e"};
        Object[] s3 = new String[]{"a", "d", "f"};
        Object[] s4 = new String[]{"a", "b", "c"};
        Object[] s5 = new String[]{"a", "b", "c", "d", "e", "f"};
        ArrayIndexed i1 = new ArrayIndexed(s1, String.class);
        ArrayIndexed i2 = new ArrayIndexed(s2, String.class);
        ArrayIndexed i3 = new ArrayIndexed(s3, String.class);
        ArrayIndexed i4 = new ArrayIndexed(s4, String.class);
        ArrayIndexed i5 = new ArrayIndexed(s5, String.class);
        IndexMerger.DictionaryMergeIterator iterator = new IndexMerger.DictionaryMergeIterator(new Indexed[]{i1, i2, i3, i4, i5}, false);
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d", "e", "f"}, (Object[])Iterators.toArray((Iterator)iterator, String.class));
        Assert.assertArrayEquals((int[])new int[]{0, 2, 3, 4}, (int[])iterator.conversions[0].array());
        Assert.assertArrayEquals((int[])new int[]{1, 2, 4}, (int[])iterator.conversions[1].array());
        Assert.assertArrayEquals((int[])new int[]{0, 3, 5}, (int[])iterator.conversions[2].array());
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])iterator.conversions[3].array());
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5}, (int[])iterator.conversions[4].array());
        Assert.assertTrue((boolean)iterator.needConversion(0));
        Assert.assertTrue((boolean)iterator.needConversion(1));
        Assert.assertTrue((boolean)iterator.needConversion(2));
        Assert.assertFalse((boolean)iterator.needConversion(3));
        Assert.assertFalse((boolean)iterator.needConversion(4));
    }
}

