/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.LegacyDimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.hive.druid.io.druid.query.topn.NumericTopNMetricSpec;
import org.apache.hive.druid.io.druid.query.topn.TopNMetricSpec;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class TopNQueryTest {
    private static final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        String json = jsonMapper.writeValueAsString((Object)query);
        Query serdeQuery = (Query)jsonMapper.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testQuerySerdeWithLookupExtractionFn() throws IOException {
        TopNQuery expectedQuery = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), true, null, false, Boolean.valueOf(false)))).metric((TopNMetricSpec)new NumericTopNMetricSpec("index")).threshold(2).intervals(QueryRunnerTestHelper.fullOnInterval.getIntervals()).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).build();
        String str = jsonMapper.writeValueAsString((Object)expectedQuery);
        Assert.assertEquals((Object)expectedQuery, (Object)jsonMapper.readValue(str, TopNQuery.class));
    }

    @Test
    public void testQuerySerdeWithAlphaNumericTopNMetricSpec() throws IOException {
        TopNQuery expectedQuery = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new LegacyDimensionSpec((Object)"market")).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.ALPHANUMERIC)).threshold(2).intervals(QueryRunnerTestHelper.fullOnInterval.getIntervals()).aggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build();
        String jsonQuery = "{\n  \"queryType\": \"topN\",\n  \"dataSource\": \"testing\",\n  \"dimension\": \"market\",\n  \"threshold\": 2,\n  \"metric\": {\n    \"type\": \"dimension\",\n    \"ordering\": \"alphanumeric\"\n   },\n  \"granularity\": \"all\",\n  \"aggregations\": [\n    {\n      \"type\": \"count\",\n      \"name\": \"rows\"\n    }\n  ],\n  \"intervals\": [\n    \"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\"\n  ]\n}";
        TopNQuery actualQuery = (TopNQuery)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonQuery, TopNQuery.class)), TopNQuery.class);
        Assert.assertEquals((Object)expectedQuery, (Object)actualQuery);
    }
}

