/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.hive.druid.io.druid.query.topn.NumericTopNMetricSpec;
import org.apache.hive.druid.io.druid.query.topn.TopNBinaryFn;
import org.apache.hive.druid.io.druid.query.topn.TopNMetricSpec;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class TopNBinaryFnTest {
    final CountAggregatorFactory rowsCount = new CountAggregatorFactory("rows");
    final LongSumAggregatorFactory indexLongSum = new LongSumAggregatorFactory("index", "index");
    final ConstantPostAggregator constant = new ConstantPostAggregator("const", (Number)1L);
    final FieldAccessPostAggregator rowsPostAgg = new FieldAccessPostAggregator("rows", "rows");
    final FieldAccessPostAggregator indexPostAgg = new FieldAccessPostAggregator("index", "index");
    final ArithmeticPostAggregator addrowsindexconstant = new ArithmeticPostAggregator("addrowsindexconstant", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{this.constant, this.rowsPostAgg, this.indexPostAgg}));
    final List<AggregatorFactory> aggregatorFactories = Arrays.asList(this.rowsCount, this.indexLongSum);
    final List<PostAggregator> postAggregators = Arrays.asList(this.addrowsindexconstant);
    private final DateTime currTime = DateTimes.nowUtc();

    private void assertTopNMergeResult(Object o1, Object o2) {
        Iterator i1 = ((Iterable)o1).iterator();
        Iterator i2 = ((Iterable)o2).iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Assert.assertEquals(i1.next(), i2.next());
        }
        Assert.assertTrue((!i1.hasNext() && !i2.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testMerge() {
        Result result1 = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L, (Object)"testdim", (Object)"1"), (Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)4L, (Object)"testdim", (Object)"2"), (Object)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)2L, (Object)"testdim", (Object)"3"))));
        Result result2 = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)3L, (Object)"testdim", (Object)"1"), (Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)0L, (Object)"testdim", (Object)"2"), (Object)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)1L, (Object)"testdim", (Object)"3"))));
        Result expected = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"testdim", (Object)"1", (Object)"rows", (Object)3L, (Object)"index", (Object)5L), (Object)ImmutableMap.of((Object)"testdim", (Object)"2", (Object)"rows", (Object)4L, (Object)"index", (Object)4L))));
        Result actual = new TopNBinaryFn(Granularities.ALL, (DimensionSpec)new DefaultDimensionSpec("testdim", null), (TopNMetricSpec)new NumericTopNMetricSpec("index"), 2, this.aggregatorFactories, this.postAggregators).apply(result1, result2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertTopNMergeResult(expected.getValue(), actual.getValue());
    }

    @Test
    public void testMergeDay() {
        Result result1 = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L, (Object)"testdim", (Object)"1"), (Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)4L, (Object)"testdim", (Object)"2"), (Object)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)2L, (Object)"testdim", (Object)"3"))));
        Result result2 = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)3L, (Object)"testdim", (Object)"1"), (Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)0L, (Object)"testdim", (Object)"2"), (Object)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)1L, (Object)"testdim", (Object)"3"))));
        Result expected = new Result(Granularities.DAY.bucketStart(this.currTime), (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"testdim", (Object)"1", (Object)"rows", (Object)3L, (Object)"index", (Object)5L), (Object)ImmutableMap.of((Object)"testdim", (Object)"2", (Object)"rows", (Object)4L, (Object)"index", (Object)4L))));
        Result actual = new TopNBinaryFn(Granularities.DAY, (DimensionSpec)new DefaultDimensionSpec("testdim", null), (TopNMetricSpec)new NumericTopNMetricSpec("index"), 2, this.aggregatorFactories, this.postAggregators).apply(result1, result2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertTopNMergeResult(expected.getValue(), actual.getValue());
    }

    @Test
    public void testMergeOneResultNull() {
        Result result1 = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L, (Object)"testdim", (Object)"1"), (Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)4L, (Object)"testdim", (Object)"2"), (Object)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)2L, (Object)"testdim", (Object)"3"))));
        Result result2 = null;
        Result expected = result1;
        Result actual = new TopNBinaryFn(Granularities.ALL, (DimensionSpec)new DefaultDimensionSpec("testdim", null), (TopNMetricSpec)new NumericTopNMetricSpec("index"), 2, this.aggregatorFactories, this.postAggregators).apply(result1, result2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertTopNMergeResult(expected.getValue(), actual.getValue());
    }

    @Test
    public void testMergeByPostAgg() {
        Result result1 = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L, (Object)"testdim", (Object)"1", (Object)"addrowsindexconstant", (Object)3.0), (Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)4L, (Object)"testdim", (Object)"2", (Object)"addrowsindexconstant", (Object)7.0), (Object)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)2L, (Object)"testdim", (Object)"3", (Object)"addrowsindexconstant", (Object)3.0))));
        Result result2 = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)3L, (Object)"testdim", (Object)"1", (Object)"addrowsindexconstant", (Object)6.0), (Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)0L, (Object)"testdim", (Object)"2", (Object)"addrowsindexconstant", (Object)3.0), (Object)ImmutableMap.of((Object)"rows", (Object)4L, (Object)"index", (Object)5L, (Object)"testdim", (Object)"other", (Object)"addrowsindexconstant", (Object)10.0))));
        Result expected = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"testdim", (Object)"other", (Object)"rows", (Object)4L, (Object)"index", (Object)5L, (Object)"addrowsindexconstant", (Object)10.0), (Object)ImmutableMap.of((Object)"testdim", (Object)"1", (Object)"rows", (Object)3L, (Object)"index", (Object)5L, (Object)"addrowsindexconstant", (Object)9.0), (Object)ImmutableMap.of((Object)"testdim", (Object)"2", (Object)"rows", (Object)4L, (Object)"index", (Object)4L, (Object)"addrowsindexconstant", (Object)9.0))));
        Result actual = new TopNBinaryFn(Granularities.ALL, (DimensionSpec)new DefaultDimensionSpec("testdim", null), (TopNMetricSpec)new NumericTopNMetricSpec("addrowsindexconstant"), 3, this.aggregatorFactories, this.postAggregators).apply(result1, result2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertTopNMergeResult(expected.getValue(), actual.getValue());
    }

    @Test
    public void testMergeShiftedTimestamp() {
        Result result1 = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L, (Object)"testdim", (Object)"1"), (Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)4L, (Object)"testdim", (Object)"2"), (Object)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)2L, (Object)"testdim", (Object)"3"))));
        Result result2 = new Result(this.currTime.plusHours(2), (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)3L, (Object)"testdim", (Object)"1"), (Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)0L, (Object)"testdim", (Object)"2"), (Object)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)1L, (Object)"testdim", (Object)"3"))));
        Result expected = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"testdim", (Object)"1", (Object)"rows", (Object)3L, (Object)"index", (Object)5L), (Object)ImmutableMap.of((Object)"testdim", (Object)"2", (Object)"rows", (Object)4L, (Object)"index", (Object)4L))));
        Result actual = new TopNBinaryFn(Granularities.ALL, (DimensionSpec)new DefaultDimensionSpec("testdim", null), (TopNMetricSpec)new NumericTopNMetricSpec("index"), 2, this.aggregatorFactories, this.postAggregators).apply(result1, result2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertTopNMergeResult(expected.getValue(), actual.getValue());
    }

    @Test
    public void testMergeLexicographicWithInvalidDimName() {
        Result result1 = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L, (Object)"testdim", (Object)"1"))));
        Result result2 = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of((Object)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)3L, (Object)"testdim", (Object)"1"))));
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        resultMap.put("INVALID_DIM_NAME", null);
        resultMap.put("rows", 3L);
        resultMap.put("index", 5L);
        Result expected = new Result(this.currTime, (Object)new TopNResultValue((List)ImmutableList.of(resultMap)));
        Result actual = new TopNBinaryFn(Granularities.ALL, (DimensionSpec)new DefaultDimensionSpec("INVALID_DIM_NAME", null), (TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC), 2, this.aggregatorFactories, this.postAggregators).apply(result1, result2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertTopNMergeResult(expected.getValue(), actual.getValue());
    }
}

