/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.select;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.io.CharSource;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.UnionDataSource;
import org.apache.hive.druid.io.druid.query.UnionQueryRunner;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.select.PagingSpec;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.select.SelectQueryConfig;
import org.apache.hive.druid.io.druid.query.select.SelectQueryEngine;
import org.apache.hive.druid.io.druid.query.select.SelectQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.select.SelectQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.select.SelectQueryRunnerTest;
import org.apache.hive.druid.io.druid.query.select.SelectResultValue;
import org.apache.hive.druid.io.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.TestIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.SingleElementPartitionChunk;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultiSegmentSelectQueryTest {
    private static final Supplier<SelectQueryConfig> configSupplier = Suppliers.ofInstance((Object)new SelectQueryConfig(Boolean.valueOf(true)));
    private static final SelectQueryQueryToolChest toolChest = new SelectQueryQueryToolChest((ObjectMapper)new DefaultObjectMapper(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator(), configSupplier);
    private static final QueryRunnerFactory factory = new SelectQueryRunnerFactory(toolChest, new SelectQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    public static final String[] V_0112 = new String[]{"2011-01-12T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t10000.0\t100000\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t11000.0\t110000\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T02:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t12000.0\t120000\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T03:00:00.000Z\tspot\thealth\t1300\t13000.0\t13000.0\t130000\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T04:00:00.000Z\tspot\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T05:00:00.000Z\tspot\tnews\t1500\t15000.0\t15000.0\t150000\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T06:00:00.000Z\tspot\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T07:00:00.000Z\tspot\ttechnology\t1700\t17000.0\t17000.0\t170000\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T08:00:00.000Z\tspot\ttravel\t1800\t18000.0\t18000.0\t180000\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T09:00:00.000Z\ttotal_market\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t1000.000000", "2011-01-12T10:00:00.000Z\ttotal_market\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t1000.000000", "2011-01-12T11:00:00.000Z\tupfront\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t800.000000\tvalue", "2011-01-12T12:00:00.000Z\tupfront\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t800.000000\tvalue"};
    public static final String[] V_0113 = new String[]{"2011-01-13T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t10000.0\t100000\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t11000.0\t110000\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T02:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t12000.0\t120000\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T03:00:00.000Z\tspot\thealth\t1300\t13000.0\t13000.0\t130000\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T04:00:00.000Z\tspot\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T05:00:00.000Z\tspot\tnews\t1500\t15000.0\t15000.0\t150000\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T06:00:00.000Z\tspot\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T07:00:00.000Z\tspot\ttechnology\t1700\t17000.0\t17000.0\t170000\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T08:00:00.000Z\tspot\ttravel\t1800\t18000.0\t18000.0\t180000\tpreferred\tt\u0001preferred\t106.236928", "2011-01-13T09:00:00.000Z\ttotal_market\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t1040.945505", "2011-01-13T10:00:00.000Z\ttotal_market\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t1689.012875", "2011-01-13T11:00:00.000Z\tupfront\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t826.060182\tvalue", "2011-01-13T12:00:00.000Z\tupfront\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t1564.617729\tvalue"};
    public static final String[] V_OVERRIDE = new String[]{"2011-01-12T04:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t10000.0\t100000\tpreferred\ta\u0001preferred\t999.000000", "2011-01-12T05:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t11000.0\t110000\tpreferred\tb\u0001preferred\t999.000000", "2011-01-12T06:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t12000.0\t120000\tpreferred\te\u0001preferred\t999.000000", "2011-01-12T07:00:00.000Z\tspot\thealth\t1300\t13000.0\t13000.0\t130000\tpreferred\th\u0001preferred\t999.000000"};
    private static Segment segment0;
    private static Segment segment1;
    private static Segment segment_override;
    private static List<String> segmentIdentifiers;
    private static QueryRunner runner;
    private final boolean fromNext;

    @BeforeClass
    public static void setup() throws IOException {
        CharSource v_0112 = CharSource.wrap((CharSequence)StringUtils.join((Object[])V_0112, (String)"\n"));
        CharSource v_0113 = CharSource.wrap((CharSequence)StringUtils.join((Object[])V_0113, (String)"\n"));
        CharSource v_override = CharSource.wrap((CharSequence)StringUtils.join((Object[])V_OVERRIDE, (String)"\n"));
        IncrementalIndex index0 = TestIndex.loadIncrementalIndex(MultiSegmentSelectQueryTest.newIndex("2011-01-12T00:00:00.000Z"), v_0112);
        IncrementalIndex index1 = TestIndex.loadIncrementalIndex(MultiSegmentSelectQueryTest.newIndex("2011-01-13T00:00:00.000Z"), v_0113);
        IncrementalIndex index2 = TestIndex.loadIncrementalIndex(MultiSegmentSelectQueryTest.newIndex("2011-01-12T04:00:00.000Z"), v_override);
        segment0 = new IncrementalIndexSegment(index0, MultiSegmentSelectQueryTest.makeIdentifier(index0, "v1"));
        segment1 = new IncrementalIndexSegment(index1, MultiSegmentSelectQueryTest.makeIdentifier(index1, "v1"));
        segment_override = new IncrementalIndexSegment(index2, MultiSegmentSelectQueryTest.makeIdentifier(index2, "v2"));
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)StringComparators.LEXICOGRAPHIC);
        timeline.add(index0.getInterval(), (Object)"v1", (PartitionChunk)new SingleElementPartitionChunk((Object)segment0));
        timeline.add(index1.getInterval(), (Object)"v1", (PartitionChunk)new SingleElementPartitionChunk((Object)segment1));
        timeline.add(index2.getInterval(), (Object)"v2", (PartitionChunk)new SingleElementPartitionChunk((Object)segment_override));
        segmentIdentifiers = Lists.newArrayList();
        for (TimelineObjectHolder holder : timeline.lookup(Intervals.of((String)"2011-01-12/2011-01-14"))) {
            segmentIdentifiers.add(MultiSegmentSelectQueryTest.makeIdentifier(holder.getInterval(), (String)holder.getVersion()));
        }
        runner = QueryRunnerTestHelper.makeFilteringQueryRunner((VersionedIntervalTimeline<String, Segment>)timeline, factory);
    }

    private static String makeIdentifier(IncrementalIndex index, String version) {
        return MultiSegmentSelectQueryTest.makeIdentifier(index.getInterval(), version);
    }

    private static String makeIdentifier(Interval interval, String version) {
        return DataSegment.makeDataSegmentIdentifier((String)"testing", (DateTime)interval.getStart(), (DateTime)interval.getEnd(), (String)version, (ShardSpec)NoneShardSpec.instance());
    }

    private static IncrementalIndex newIndex(String minTimeStamp) {
        return MultiSegmentSelectQueryTest.newIndex(minTimeStamp, 10000);
    }

    private static IncrementalIndex newIndex(String minTimeStamp, int maxRowCount) {
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)minTimeStamp).getMillis()).withQueryGranularity(Granularities.HOUR).withMetrics(TestIndex.METRIC_AGGS).build();
        return new IncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(maxRowCount).buildOnheap();
    }

    @AfterClass
    public static void clear() {
        IOUtils.closeQuietly((Closeable)segment0);
        IOUtils.closeQuietly((Closeable)segment1);
        IOUtils.closeQuietly((Closeable)segment_override);
    }

    @Parameterized.Parameters(name="fromNext={0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.cartesian(Arrays.asList(false, true));
    }

    public MultiSegmentSelectQueryTest(boolean fromNext) {
        this.fromNext = fromNext;
    }

    private Druids.SelectQueryBuilder newBuilder() {
        return Druids.newSelectQueryBuilder().dataSource((DataSource)new TableDataSource("testing")).intervals(SelectQueryRunnerTest.I_0112_0114).granularity(QueryRunnerTestHelper.allGran).dimensionSpecs(DefaultDimensionSpec.toSpec(QueryRunnerTestHelper.dimensions)).pagingSpec(PagingSpec.newSpec((int)3));
    }

    @Test
    public void testAllGranularity() {
        this.runAllGranularityTest(this.newBuilder().build(), new int[][]{{2, -1, -1, -1, 3}, {3, 1, -1, -1, 3}, {-1, 3, 0, -1, 3}, {-1, -1, 3, -1, 3}, {-1, -1, 4, 1, 3}, {-1, -1, -1, 4, 3}, {-1, -1, -1, 7, 3}, {-1, -1, -1, 10, 3}, {-1, -1, -1, 12, 2}, {-1, -1, -1, 13, 0}});
        this.runAllGranularityTest(this.newBuilder().descending(true).build(), new int[][]{{0, 0, 0, -3, 3}, {0, 0, 0, -6, 3}, {0, 0, 0, -9, 3}, {0, 0, 0, -12, 3}, {0, 0, -2, -13, 3}, {0, 0, -5, 0, 3}, {0, -3, 0, 0, 3}, {-2, -4, 0, 0, 3}, {-4, 0, 0, 0, 2}, {-5, 0, 0, 0, 0}});
    }

    private void runAllGranularityTest(SelectQuery query, int[][] expectedOffsets) {
        for (int[] expected : expectedOffsets) {
            List results = Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)query), (Map)ImmutableMap.of()), (List)Lists.newArrayList());
            Assert.assertEquals((long)1L, (long)results.size());
            SelectResultValue value = (SelectResultValue)((Result)results.get(0)).getValue();
            Map pagingIdentifiers = value.getPagingIdentifiers();
            Map merged = PagingSpec.merge(Arrays.asList(pagingIdentifiers));
            for (int i = 0; i < 4; ++i) {
                if (!(query.isDescending() ^ expected[i] >= 0)) continue;
                Assert.assertEquals((long)expected[i], (long)((Integer)pagingIdentifiers.get(segmentIdentifiers.get(i))).intValue());
            }
            Assert.assertEquals((long)expected[4], (long)value.getEvents().size());
            query = query.withPagingSpec(this.toNextCursor(merged, query, 3));
        }
    }

    @Test
    public void testDayGranularity() {
        this.runDayGranularityTest(this.newBuilder().granularity(QueryRunnerTestHelper.dayGran).build(), new int[][]{{2, -1, -1, 2, 3, 0, 0, 3}, {3, 1, -1, 5, 1, 2, 0, 3}, {-1, 3, 0, 8, 0, 2, 1, 3}, {-1, -1, 3, 11, 0, 0, 3, 3}, {-1, -1, 4, 12, 0, 0, 1, 1}, {-1, -1, 5, 13, 0, 0, 0, 0}});
        this.runDayGranularityTest(this.newBuilder().granularity(QueryRunnerTestHelper.dayGran).descending(true).build(), new int[][]{{0, 0, -3, -3, 0, 0, 3, 3}, {0, -1, -5, -6, 0, 1, 2, 3}, {0, -4, 0, -9, 0, 3, 0, 3}, {-3, 0, 0, -12, 3, 0, 0, 3}, {-4, 0, 0, -13, 1, 0, 0, 1}, {-5, 0, 0, -14, 0, 0, 0, 0}});
    }

    private void runDayGranularityTest(SelectQuery query, int[][] expectedOffsets) {
        for (int[] expected : expectedOffsets) {
            List results = Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)query), (Map)ImmutableMap.of()), (List)Lists.newArrayList());
            Assert.assertEquals((long)2L, (long)results.size());
            SelectResultValue value0 = (SelectResultValue)((Result)results.get(0)).getValue();
            SelectResultValue value1 = (SelectResultValue)((Result)results.get(1)).getValue();
            Map pagingIdentifiers0 = value0.getPagingIdentifiers();
            Map pagingIdentifiers1 = value1.getPagingIdentifiers();
            Map merged = PagingSpec.merge(Arrays.asList(pagingIdentifiers0, pagingIdentifiers1));
            for (int i = 0; i < 4; ++i) {
                if (!(query.isDescending() ^ expected[i] >= 0)) continue;
                Assert.assertEquals((long)expected[i], (long)((Integer)merged.get(segmentIdentifiers.get(i))).intValue());
            }
            query = query.withPagingSpec(this.toNextCursor(merged, query, 3));
        }
    }

    @Test
    public void testPagingIdentifiersForUnionDatasource() {
        Druids.SelectQueryBuilder selectQueryBuilder = Druids.newSelectQueryBuilder().dataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("testing"), (Object)new TableDataSource("testing-2")))).intervals(SelectQueryRunnerTest.I_0112_0114).granularity(QueryRunnerTestHelper.allGran).dimensionSpecs(DefaultDimensionSpec.toSpec(QueryRunnerTestHelper.dimensions)).pagingSpec(PagingSpec.newSpec((int)3));
        SelectQuery query = selectQueryBuilder.build();
        UnionQueryRunner unionQueryRunner = new UnionQueryRunner(runner);
        List results = Sequences.toList((Sequence)unionQueryRunner.run(QueryPlus.wrap((Query)query), (Map)ImmutableMap.of()), (List)Lists.newArrayList());
        Map pagingIdentifiers = ((SelectResultValue)((Result)results.get(0)).getValue()).getPagingIdentifiers();
        query = query.withPagingSpec(this.toNextCursor(PagingSpec.merge(Arrays.asList(pagingIdentifiers)), query, 3));
        Sequences.toList((Sequence)unionQueryRunner.run(QueryPlus.wrap((Query)query), (Map)ImmutableMap.of()), (List)Lists.newArrayList());
    }

    private PagingSpec toNextCursor(Map<String, Integer> merged, SelectQuery query, int threshold) {
        if (!this.fromNext) {
            merged = PagingSpec.next(merged, (boolean)query.isDescending());
        }
        return new PagingSpec(merged, threshold, Boolean.valueOf(this.fromNext));
    }
}

