/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.scan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.ObjectArrays;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.hash.Hashing;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.io.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.query.scan.ScanQuery;
import org.apache.hive.druid.io.druid.query.scan.ScanQueryConfig;
import org.apache.hive.druid.io.druid.query.scan.ScanQueryEngine;
import org.apache.hive.druid.io.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.scan.ScanResultValue;
import org.apache.hive.druid.io.druid.query.spec.LegacySegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.segment.VirtualColumn;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.virtual.ExpressionVirtualColumn;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ScanQueryRunnerTest {
    private static final VirtualColumn EXPR_COLUMN = new ExpressionVirtualColumn("expr", "index * 2", ValueType.LONG, TestExprMacroTable.INSTANCE);
    public static final String[] V_0112 = new String[]{"2011-01-12T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t10000.0\t100000\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t11000.0\t110000\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t12000.0\t120000\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\t1300\t13000.0\t13000.0\t130000\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\t1500\t15000.0\t15000.0\t150000\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\t1700\t17000.0\t17000.0\t170000\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\t1800\t18000.0\t18000.0\t180000\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\ttotal_market\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t1000.000000", "2011-01-12T00:00:00.000Z\ttotal_market\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t1000.000000", "2011-01-12T00:00:00.000Z\tupfront\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t800.000000\tvalue", "2011-01-12T00:00:00.000Z\tupfront\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t800.000000\tvalue"};
    public static final String[] V_0113 = new String[]{"2011-01-13T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t10000.0\t100000\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t11000.0\t110000\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t12000.0\t120000\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\t1300\t13000.0\t13000.0\t130000\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\t1500\t15000.0\t15000.0\t150000\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\t1700\t17000.0\t17000.0\t170000\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\t1800\t18000.0\t18000.0\t180000\tpreferred\tt\u0001preferred\t106.236928", "2011-01-13T00:00:00.000Z\ttotal_market\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t1040.945505", "2011-01-13T00:00:00.000Z\ttotal_market\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t1689.012875", "2011-01-13T00:00:00.000Z\tupfront\tmezzanine\t1400\t14000.0\t14000.0\t140000\tpreferred\tm\u0001preferred\t826.060182\tvalue", "2011-01-13T00:00:00.000Z\tupfront\tpremium\t1600\t16000.0\t16000.0\t160000\tpreferred\tp\u0001preferred\t1564.617729\tvalue"};
    public static final QuerySegmentSpec I_0112_0114 = new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z"));
    public static final String[] V_0112_0114 = (String[])ObjectArrays.concat((Object[])V_0112, (Object[])V_0113, String.class);
    private static final ScanQueryQueryToolChest toolChest = new ScanQueryQueryToolChest(new ScanQueryConfig(), DefaultGenericQueryMetricsFactory.instance());
    private final QueryRunner runner;
    private final boolean legacy;

    @Parameterized.Parameters(name="{0}, legacy = {1}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.cartesian(new Iterable[]{QueryRunnerTestHelper.makeQueryRunners(new ScanQueryRunnerFactory(toolChest, new ScanQueryEngine())), ImmutableList.of((Object)false, (Object)true)});
    }

    public ScanQueryRunnerTest(QueryRunner runner, boolean legacy) {
        this.runner = runner;
        this.legacy = legacy;
    }

    private ScanQuery.ScanQueryBuilder newTestQuery() {
        return ScanQuery.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("testing")).columns(Arrays.asList(new String[0])).intervals(QueryRunnerTestHelper.fullOnInterval).limit(3L).legacy(Boolean.valueOf(this.legacy));
    }

    @Test
    public void testFullOnSelect() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "expr", "market", "quality", "qualityLong", "qualityFloat", "qualityDouble", "qualityNumericString", "placement", "placementish", "partial_null_column", "null_column", "index", "indexMin", "indexMaxPlusTen", "quality_uniques", "indexFloat", "indexMaxFloat", "indexMinFloat"});
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).virtualColumns(new VirtualColumn[]{EXPR_COLUMN}).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        List<ScanResultValue> expectedResults = this.toExpected(this.toFullEvents(new String[][]{V_0112_0114}), columns, 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, ScanQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(results, "null_column"));
    }

    @Test
    public void testFullOnSelectAsCompactedList() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "expr", "market", "quality", "qualityLong", "qualityFloat", "qualityDouble", "qualityNumericString", "placement", "placementish", "partial_null_column", "null_column", "index", "indexMin", "indexMaxPlusTen", "quality_uniques", "indexFloat", "indexMaxFloat", "indexMinFloat"});
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).virtualColumns(new VirtualColumn[]{EXPR_COLUMN}).resultFormat("compactedList").build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        List<ScanResultValue> expectedResults = this.toExpected(this.toFullEvents(new String[][]{V_0112_0114}), columns, 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, ScanQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(this.compactedListToRow(results), "null_column"));
    }

    @Test
    public void testSelectWithUnderscoreUnderscoreTime() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"__time", "market", "index"}).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        List<List<Map<String, Object>>> expectedEvents = this.toEvents(new String[]{this.getTimestampName() + ":TIME", "market:STRING", null, null, null, null, null, null, null, "index:DOUBLE"}, new String[][]{V_0112_0114});
        if (this.legacy) {
            for (List<Map<String, Object>> batch : expectedEvents) {
                for (Map<String, Object> event : batch) {
                    event.put("__time", ((DateTime)event.get("timestamp")).getMillis());
                }
            }
        }
        List<ScanResultValue> expectedResults = this.toExpected(expectedEvents, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "__time", "market", "index"}) : Lists.newArrayList((Object[])new String[]{"__time", "market", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testSelectWithDimsAndMets() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"market", "index"}).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        List<ScanResultValue> expectedResults = this.toExpected(this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : null, "market:STRING", null, null, null, null, null, null, null, "index:DOUBLE"}, new String[][]{V_0112_0114}), this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "market", "index"}) : Lists.newArrayList((Object[])new String[]{"market", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testSelectWithDimsAndMetsAsCompactedList() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"market", "index"}).resultFormat("compactedList").build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        List<ScanResultValue> expectedResults = this.toExpected(this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : null, "market:STRING", null, null, null, null, null, null, null, "index:DOUBLE"}, new String[][]{V_0112_0114}), this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "market", "index"}) : Lists.newArrayList((Object[])new String[]{"market", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, this.compactedListToRow(results));
    }

    @Test
    public void testFullOnSelectWithFilterAndLimit() {
        for (int limit : new int[]{3, 1, 5, 7, 0}) {
            ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).columns(new String[]{"quality", "index"}).limit((long)limit).build();
            HashMap context = new HashMap();
            List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
            List<List<Map<String, Object>>> events = this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : null, null, "quality:STRING", null, null, "index:DOUBLE"}, {"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"}, {"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"});
            List<ScanResultValue> expectedResults = this.toExpected(events, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "quality", "index"}) : Lists.newArrayList((Object[])new String[]{"quality", "index"}), 0, limit);
            ScanQueryRunnerTest.verify(expectedResults, results);
        }
    }

    @Test
    public void testSelectWithFilterLookupExtractionFn() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("total_market", "replaced");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, true, Boolean.valueOf(true));
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "replaced", (ExtractionFn)lookupExtractionFn)).columns(new String[]{"quality", "index"}).build();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        List resultsOptimize = Sequences.toList((Sequence)toolChest.postMergeQueryDecoration(toolChest.mergeResults(toolChest.preMergeQueryDecoration(this.runner))).run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        List<List<Map<String, Object>>> events = this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : null, null, "quality:STRING", null, null, "index:DOUBLE"}, {"2011-01-12T00:00:00.000Z\ttotal_market\tmezzanine\tpreferred\tm\u0001preferred\t1000.000000", "2011-01-12T00:00:00.000Z\ttotal_market\tpremium\tpreferred\tp\u0001preferred\t1000.000000"}, {"2011-01-13T00:00:00.000Z\ttotal_market\tmezzanine\tpreferred\tm\u0001preferred\t1040.945505", "2011-01-13T00:00:00.000Z\ttotal_market\tpremium\tpreferred\tp\u0001preferred\t1689.012875"});
        List<ScanResultValue> expectedResults = this.toExpected(events, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "quality", "index"}) : Lists.newArrayList((Object[])new String[]{"quality", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
        ScanQueryRunnerTest.verify(expectedResults, resultsOptimize);
    }

    @Test
    public void testFullSelectNoResults() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new AndDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("market", "foo", null)))).build();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        List<ScanResultValue> expectedResults = Collections.emptyList();
        ScanQueryRunnerTest.verify(expectedResults, ScanQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(results, "null_column"));
    }

    @Test
    public void testFullSelectNoDimensionAndMetric() {
        String[] stringArray;
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"foo", "foo2"}).build();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        if (this.legacy) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.getTimestampName() + ":TIME";
        } else {
            stringArray = new String[]{};
        }
        List<List<Map<String, Object>>> events = this.toEvents(stringArray, new String[][]{V_0112_0114});
        List<ScanResultValue> expectedResults = this.toExpected(events, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "foo", "foo2"}) : Lists.newArrayList((Object[])new String[]{"foo", "foo2"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    private List<List<Map<String, Object>>> toFullEvents(String[] ... valueSet) {
        return this.toEvents(new String[]{this.getTimestampName() + ":TIME", "market:STRING", "quality:STRING", "qualityLong:LONG", "qualityFloat:FLOAT", "qualityDouble:DOUBLE", "qualityNumericString:STRING", "placement:STRING", "placementish:STRINGS", "index:DOUBLE", "partial_null_column:STRING", "expr", "indexMin", "indexFloat", "indexMaxPlusTen", "indexMinFloat", "indexMaxFloat", "quality_uniques"}, valueSet);
    }

    private List<List<Map<String, Object>>> toEvents(final String[] dimSpecs, String[] ... valueSet) {
        ArrayList values = Lists.newArrayList();
        for (String[] vSet : valueSet) {
            values.addAll(Arrays.asList(vSet));
        }
        ArrayList events = Lists.newArrayList();
        events.add(Lists.newArrayList((Iterable)Iterables.transform((Iterable)values, (Function)new Function<String, Map<String, Object>>(){

            public Map<String, Object> apply(String input) {
                HashMap event = Maps.newHashMap();
                String[] values = input.split("\\t");
                for (int i = 0; i < dimSpecs.length; ++i) {
                    if (dimSpecs[i] == null || i >= dimSpecs.length) continue;
                    if (dimSpecs[i].equals(EXPR_COLUMN.getOutputName())) {
                        event.put(EXPR_COLUMN.getOutputName(), (Double)event.get("index") * 2.0);
                        continue;
                    }
                    if (dimSpecs[i].equals("indexMin")) {
                        event.put("indexMin", Double.valueOf((Double)event.get("index")));
                        continue;
                    }
                    if (dimSpecs[i].equals("indexFloat")) {
                        event.put("indexFloat", Float.valueOf((float)((Double)event.get("index")).doubleValue()));
                        continue;
                    }
                    if (dimSpecs[i].equals("indexMaxPlusTen")) {
                        event.put("indexMaxPlusTen", (Double)event.get("index") + 10.0);
                        continue;
                    }
                    if (dimSpecs[i].equals("indexMinFloat")) {
                        event.put("indexMinFloat", Float.valueOf((float)((Double)event.get("index")).doubleValue()));
                        continue;
                    }
                    if (dimSpecs[i].equals("indexMaxFloat")) {
                        event.put("indexMaxFloat", Float.valueOf((float)((Double)event.get("index")).doubleValue()));
                        continue;
                    }
                    if (dimSpecs[i].equals("quality_uniques")) {
                        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
                        collector.add(Hashing.murmur3_128().hashBytes(StringUtils.toUtf8((String)((String)event.get("quality")))).asBytes());
                        event.put("quality_uniques", collector);
                    }
                    if (i >= values.length) continue;
                    String[] specs = dimSpecs[i].split(":");
                    event.put(specs[0], specs.length == 1 || specs[1].equals("STRING") ? values[i] : (specs[1].equals("TIME") ? ScanQueryRunnerTest.this.toTimestamp(values[i]) : (specs[1].equals("FLOAT") ? Float.valueOf(values[i]) : (specs[1].equals("DOUBLE") ? Double.valueOf(values[i]) : (specs[1].equals("LONG") ? Long.valueOf(values[i]) : (specs[1].equals("NULL") ? null : (specs[1].equals("STRINGS") ? Arrays.asList(values[i].split("\u0001")) : values[i])))))));
                }
                return event;
            }
        })));
        return events;
    }

    private Object toTimestamp(String value) {
        if (this.legacy) {
            return DateTimes.of((String)value);
        }
        return DateTimes.of((String)value).getMillis();
    }

    private String getTimestampName() {
        return this.legacy ? "timestamp" : "__time";
    }

    private List<ScanResultValue> toExpected(List<List<Map<String, Object>>> targets, List<String> columns, int offset, int limit) {
        ArrayList expected = Lists.newArrayListWithExpectedSize((int)targets.size());
        for (List<Map<String, Object>> group : targets) {
            ArrayList events = Lists.newArrayListWithExpectedSize((int)limit);
            int end = Math.min(group.size(), offset + limit);
            if (end == 0) {
                end = group.size();
            }
            events.addAll(group.subList(offset, end));
            expected.add(new ScanResultValue("testSegment", columns, (Object)events));
        }
        return expected;
    }

    public static void verify(Iterable<ScanResultValue> expectedResults, Iterable<ScanResultValue> actualResults) {
        Iterator<ScanResultValue> expectedIter = expectedResults.iterator();
        Iterator<ScanResultValue> actualIter = actualResults.iterator();
        while (expectedIter.hasNext()) {
            ScanResultValue expected = expectedIter.next();
            ScanResultValue actual = actualIter.next();
            Assert.assertEquals((Object)expected.getSegmentId(), (Object)actual.getSegmentId());
            TreeSet exColumns = Sets.newTreeSet((Iterable)expected.getColumns());
            TreeSet acColumns = Sets.newTreeSet((Iterable)actual.getColumns());
            Assert.assertEquals((Object)exColumns, (Object)acColumns);
            Iterator expectedEvts = ((List)expected.getEvents()).iterator();
            Iterator actualEvts = ((List)actual.getEvents()).iterator();
            while (expectedEvts.hasNext()) {
                Map exHolder = (Map)expectedEvts.next();
                Map acHolder = (Map)actualEvts.next();
                for (Map.Entry ex : exHolder.entrySet()) {
                    Object exValue;
                    Object actVal = acHolder.get(ex.getKey());
                    if (actVal instanceof String[]) {
                        actVal = Arrays.asList((String[])actVal);
                    }
                    if ((exValue = ex.getValue()) instanceof Double || exValue instanceof Float) {
                        double expectedDoubleValue = ((Number)exValue).doubleValue();
                        Assert.assertEquals((String)("invalid value for " + (String)ex.getKey()), (double)expectedDoubleValue, (double)((Number)actVal).doubleValue(), (double)(expectedDoubleValue * 1.0E-6));
                        continue;
                    }
                    Assert.assertEquals((String)("invalid value for " + (String)ex.getKey()), ex.getValue(), actVal);
                }
                for (Map.Entry ac : acHolder.entrySet()) {
                    Object exVal = exHolder.get(ac.getKey());
                    Object actVal = ac.getValue();
                    if (actVal instanceof String[]) {
                        actVal = Arrays.asList((String[])actVal);
                    }
                    if (exVal instanceof Double || exVal instanceof Float) {
                        double exDoubleValue = ((Number)exVal).doubleValue();
                        Assert.assertEquals((String)("invalid value for " + (String)ac.getKey()), (double)exDoubleValue, (double)((Number)actVal).doubleValue(), (double)(exDoubleValue * 1.0E-6));
                        continue;
                    }
                    Assert.assertEquals((String)("invalid value for " + (String)ac.getKey()), exVal, actVal);
                }
            }
            if (!actualEvts.hasNext()) continue;
            throw new ISE("This event iterator should be exhausted!", new Object[0]);
        }
        if (actualIter.hasNext()) {
            throw new ISE("This iterator should be exhausted!", new Object[0]);
        }
    }

    private static Iterable<ScanResultValue> populateNullColumnAtLastForQueryableIndexCase(Iterable<ScanResultValue> results, String columnName) {
        ScanResultValue value;
        List columns;
        Iterator<ScanResultValue> iterator = results.iterator();
        while (iterator.hasNext() && !(columns = (value = iterator.next()).getColumns()).contains(columnName)) {
            columns.add(columnName);
        }
        return results;
    }

    private Iterable<ScanResultValue> compactedListToRow(Iterable<ScanResultValue> results) {
        return Lists.newArrayList((Iterable)Iterables.transform(results, (Function)new Function<ScanResultValue, ScanResultValue>(){

            public ScanResultValue apply(ScanResultValue input) {
                LinkedList mapEvents = Lists.newLinkedList();
                List events = (List)input.getEvents();
                for (Object event : events) {
                    Iterator compactedEventIter = ((List)event).iterator();
                    LinkedHashMap mapEvent = new LinkedHashMap();
                    for (String column : input.getColumns()) {
                        mapEvent.put(column, compactedEventIter.next());
                    }
                    mapEvents.add(mapEvent);
                }
                return new ScanResultValue(input.getSegmentId(), input.getColumns(), (Object)mapEvents);
            }
        }));
    }
}

