/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableRangeSet;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.IdentityExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.io.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.InDimFilter;
import org.apache.hive.druid.io.druid.query.filter.IntervalDimFilter;
import org.apache.hive.druid.io.druid.query.filter.JavaScriptDimFilter;
import org.apache.hive.druid.io.druid.query.filter.NotDimFilter;
import org.apache.hive.druid.io.druid.query.filter.OrDimFilter;
import org.apache.hive.druid.io.druid.query.filter.RegexDimFilter;
import org.apache.hive.druid.io.druid.query.filter.SearchQueryDimFilter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.search.ContainsSearchQuerySpec;
import org.apache.hive.druid.io.druid.query.search.SearchQuerySpec;
import org.junit.Assert;
import org.junit.Test;

public class GetDimensionRangeSetTest {
    private final DimFilter selector1 = new SelectorDimFilter("dim1", "a", null);
    private final DimFilter selector2 = new SelectorDimFilter("dim1", "z", null);
    private final DimFilter selector3 = new SelectorDimFilter("dim2", "c", null);
    private final DimFilter selector4 = new SelectorDimFilter("dimWorld", "find", (ExtractionFn)IdentityExtractionFn.getInstance());
    private final DimFilter selector5 = new SelectorDimFilter("dim1", null, null);
    private final DimFilter in1 = new InDimFilter("dim1", (Collection)ImmutableList.of((Object)"testing", (Object)"this", (Object)"filter", (Object)"tillend"), null);
    private final DimFilter in2 = new InDimFilter("dim2", (Collection)ImmutableList.of((Object)"again"), null);
    private final DimFilter in3 = new InDimFilter("dim1", Arrays.asList("null", null), null);
    private final DimFilter bound1 = new BoundDimFilter("dim1", "from", "to", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC);
    private final DimFilter bound2 = new BoundDimFilter("dim1", null, "tillend", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC);
    private final DimFilter bound3 = new BoundDimFilter("dim1", "notincluded", null, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC);
    private final DimFilter bound4 = new BoundDimFilter("dim2", "again", "exclusive", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC);
    private final DimFilter other1 = new RegexDimFilter("someDim", "pattern", null);
    private final DimFilter other2 = new JavaScriptDimFilter("someOtherDim", "function(x) { return x }", null, JavaScriptConfig.getEnabledInstance());
    private final DimFilter other3 = new SearchQueryDimFilter("dim", (SearchQuerySpec)new ContainsSearchQuerySpec("a", true), null);
    private final DimFilter interval1 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
    private final DimFilter interval2 = new IntervalDimFilter("dim1", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
    private static final RangeSet all = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.all()));
    private static final RangeSet empty = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of());

    @Test
    public void testSimpleFilter() {
        RangeSet<String> expected1 = GetDimensionRangeSetTest.rangeSet(GetDimensionRangeSetTest.point("a"));
        Assert.assertEquals(expected1, (Object)this.selector1.getDimensionRangeSet("dim1"));
        Assert.assertNull((Object)this.selector1.getDimensionRangeSet("dim2"));
        RangeSet<String> expected2 = GetDimensionRangeSetTest.rangeSet(GetDimensionRangeSetTest.point(""));
        Assert.assertEquals(expected2, (Object)this.selector5.getDimensionRangeSet("dim1"));
        RangeSet<String> expected3 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of(GetDimensionRangeSetTest.point("testing"), GetDimensionRangeSetTest.point("this"), GetDimensionRangeSetTest.point("filter"), GetDimensionRangeSetTest.point("tillend")));
        Assert.assertEquals(expected3, (Object)this.in1.getDimensionRangeSet("dim1"));
        RangeSet<String> expected4 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of(GetDimensionRangeSetTest.point("null"), GetDimensionRangeSetTest.point("")));
        Assert.assertEquals(expected4, (Object)this.in3.getDimensionRangeSet("dim1"));
        ImmutableRangeSet expected5 = ImmutableRangeSet.of((Range)Range.closed((Comparable)((Object)"from"), (Comparable)((Object)"to")));
        Assert.assertEquals((Object)expected5, (Object)this.bound1.getDimensionRangeSet("dim1"));
        ImmutableRangeSet expected6 = ImmutableRangeSet.of((Range)Range.atMost((Comparable)((Object)"tillend")));
        Assert.assertEquals((Object)expected6, (Object)this.bound2.getDimensionRangeSet("dim1"));
        ImmutableRangeSet expected7 = ImmutableRangeSet.of((Range)Range.greaterThan((Comparable)((Object)"notincluded")));
        Assert.assertEquals((Object)expected7, (Object)this.bound3.getDimensionRangeSet("dim1"));
        Assert.assertNull((Object)this.other1.getDimensionRangeSet("someDim"));
        Assert.assertNull((Object)this.other2.getDimensionRangeSet("someOtherDim"));
        Assert.assertNull((Object)this.other3.getDimensionRangeSet("dim"));
        Assert.assertNull((Object)this.interval1.getDimensionRangeSet("__time"));
        Assert.assertNull((Object)this.interval2.getDimensionRangeSet("dim1"));
    }

    @Test
    public void testAndFilter() {
        AndDimFilter and1 = new AndDimFilter((List)ImmutableList.of((Object)this.selector1, (Object)this.selector2, (Object)this.in1));
        Assert.assertEquals((Object)empty, (Object)and1.getDimensionRangeSet("dim1"));
        Assert.assertNull((Object)and1.getDimensionRangeSet("dim2"));
        AndDimFilter and2 = new AndDimFilter((List)ImmutableList.of((Object)this.selector3, (Object)this.bound1, (Object)this.other1));
        RangeSet<String> expected2 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.closed((Comparable)((Object)"from"), (Comparable)((Object)"to"))));
        Assert.assertEquals(expected2, (Object)and2.getDimensionRangeSet("dim1"));
        AndDimFilter and3 = new AndDimFilter((List)ImmutableList.of((Object)this.in2, (Object)this.bound1, (Object)this.bound2, (Object)this.bound3, (Object)this.bound4));
        RangeSet<String> expected3 = GetDimensionRangeSetTest.rangeSet((Range<String>)Range.openClosed((Comparable)((Object)"notincluded"), (Comparable)((Object)"tillend")));
        Assert.assertEquals(expected3, (Object)and3.getDimensionRangeSet("dim1"));
        Assert.assertEquals((Object)empty, (Object)and3.getDimensionRangeSet("dim2"));
        AndDimFilter and4 = new AndDimFilter((List)ImmutableList.of((Object)this.in3, (Object)this.bound3));
        RangeSet<String> expected4 = GetDimensionRangeSetTest.rangeSet(GetDimensionRangeSetTest.point("null"));
        Assert.assertEquals(expected4, (Object)and4.getDimensionRangeSet("dim1"));
        AndDimFilter and5 = new AndDimFilter((List)ImmutableList.of((Object)and3, (Object)this.in1));
        RangeSet<String> expected5 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of(GetDimensionRangeSetTest.point("testing"), GetDimensionRangeSetTest.point("this"), GetDimensionRangeSetTest.point("tillend")));
        Assert.assertEquals(expected5, (Object)and5.getDimensionRangeSet("dim1"));
    }

    @Test
    public void testOrFilter() {
        OrDimFilter or1 = new OrDimFilter((List)ImmutableList.of((Object)this.selector1, (Object)this.selector2, (Object)this.selector5));
        RangeSet<String> expected1 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of(GetDimensionRangeSetTest.point(""), GetDimensionRangeSetTest.point("a"), GetDimensionRangeSetTest.point("z")));
        Assert.assertEquals(expected1, (Object)or1.getDimensionRangeSet("dim1"));
        OrDimFilter or2 = new OrDimFilter((List)ImmutableList.of((Object)this.selector5, (Object)this.in1, (Object)this.in3));
        RangeSet<String> expected2 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of(GetDimensionRangeSetTest.point("testing"), GetDimensionRangeSetTest.point("this"), GetDimensionRangeSetTest.point("filter"), GetDimensionRangeSetTest.point("tillend"), GetDimensionRangeSetTest.point("null"), GetDimensionRangeSetTest.point("")));
        Assert.assertEquals(expected2, (Object)or2.getDimensionRangeSet("dim1"));
        OrDimFilter or3 = new OrDimFilter((List)ImmutableList.of((Object)this.bound1, (Object)this.bound2, (Object)this.bound3));
        Assert.assertEquals((Object)all, (Object)or3.getDimensionRangeSet("dim1"));
        OrDimFilter or4 = new OrDimFilter((List)ImmutableList.of((Object)this.selector1, (Object)this.selector2, (Object)this.selector3, (Object)this.selector4, (Object)this.selector5));
        Assert.assertNull((Object)or4.getDimensionRangeSet("dim1"));
        Assert.assertNull((Object)or4.getDimensionRangeSet("dim2"));
        OrDimFilter or5 = new OrDimFilter((List)ImmutableList.of((Object)or1, (Object)or2, (Object)this.bound1));
        RangeSet<String> expected5 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of(GetDimensionRangeSetTest.point(""), GetDimensionRangeSetTest.point("a"), GetDimensionRangeSetTest.point("filter"), (Object)Range.closed((Comparable)((Object)"from"), (Comparable)((Object)"to")), GetDimensionRangeSetTest.point("z")));
        Assert.assertEquals(expected5, (Object)or5.getDimensionRangeSet("dim1"));
    }

    @Test
    public void testNotFilter() {
        NotDimFilter not1 = new NotDimFilter(this.selector1);
        RangeSet<String> expected1 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.lessThan((Comparable)((Object)"a")), (Object)Range.greaterThan((Comparable)((Object)"a"))));
        Assert.assertEquals(expected1, (Object)not1.getDimensionRangeSet("dim1"));
        Assert.assertNull((Object)not1.getDimensionRangeSet("dim2"));
        NotDimFilter not2 = new NotDimFilter(this.in3);
        RangeSet<String> expected2 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.lessThan((Comparable)((Object)"")), (Object)Range.open((Comparable)((Object)""), (Comparable)((Object)"null")), (Object)Range.greaterThan((Comparable)((Object)"null"))));
        Assert.assertEquals(expected2, (Object)not2.getDimensionRangeSet("dim1"));
        NotDimFilter not3 = new NotDimFilter(this.bound1);
        RangeSet<String> expected3 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.lessThan((Comparable)((Object)"from")), (Object)Range.greaterThan((Comparable)((Object)"to"))));
        Assert.assertEquals(expected3, (Object)not3.getDimensionRangeSet("dim1"));
        NotDimFilter not4 = new NotDimFilter((DimFilter)not2);
        RangeSet<String> expected4 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of(GetDimensionRangeSetTest.point(""), GetDimensionRangeSetTest.point("null")));
        Assert.assertEquals(expected4, (Object)not4.getDimensionRangeSet("dim1"));
        OrDimFilter or1 = new OrDimFilter((List)ImmutableList.of((Object)this.selector1, (Object)this.selector2, (Object)this.bound1, (Object)this.bound3));
        NotDimFilter not5 = new NotDimFilter((DimFilter)or1);
        RangeSet<String> expected5 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.lessThan((Comparable)((Object)"a")), (Object)Range.open((Comparable)((Object)"a"), (Comparable)((Object)"from"))));
        Assert.assertEquals(expected5, (Object)not5.getDimensionRangeSet("dim1"));
        Assert.assertNull((Object)not5.getDimensionRangeSet("dim2"));
        OrDimFilter or2 = new OrDimFilter((List)ImmutableList.of((Object)this.selector3, (Object)this.in3, (Object)this.bound2, (Object)this.bound4, (Object)this.other3));
        NotDimFilter not6 = new NotDimFilter((DimFilter)or2);
        RangeSet<String> expected6a = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.greaterThan((Comparable)((Object)"tillend"))));
        RangeSet<String> expected6b = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.atMost((Comparable)((Object)"again")), (Object)Range.atLeast((Comparable)((Object)"exclusive"))));
        Assert.assertEquals(expected6a, (Object)not6.getDimensionRangeSet("dim1"));
        Assert.assertEquals(expected6b, (Object)not6.getDimensionRangeSet("dim2"));
        AndDimFilter and1 = new AndDimFilter((List)ImmutableList.of((Object)this.in1, (Object)this.bound1, (Object)this.bound2));
        NotDimFilter not7 = new NotDimFilter((DimFilter)and1);
        RangeSet<String> expected7 = GetDimensionRangeSetTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.lessThan((Comparable)((Object)"testing")), (Object)Range.open((Comparable)((Object)"testing"), (Comparable)((Object)"this")), (Object)Range.open((Comparable)((Object)"this"), (Comparable)((Object)"tillend")), (Object)Range.greaterThan((Comparable)((Object)"tillend"))));
        Assert.assertEquals(expected7, (Object)not7.getDimensionRangeSet("dim1"));
        Assert.assertNull((Object)not7.getDimensionRangeSet("dim2"));
        AndDimFilter and2 = new AndDimFilter((List)ImmutableList.of((Object)this.bound1, (Object)this.bound2, (Object)this.bound3, (Object)this.bound4));
        NotDimFilter not8 = new NotDimFilter((DimFilter)and2);
        Assert.assertNull((Object)not8.getDimensionRangeSet("dim1"));
        Assert.assertNull((Object)not8.getDimensionRangeSet("dim2"));
    }

    private static Range<String> point(String s) {
        return Range.singleton((Comparable)((Object)s));
    }

    private static RangeSet<String> rangeSet(Range<String> ranges) {
        return ImmutableRangeSet.of(ranges);
    }

    private static RangeSet<String> rangeSet(List<Range<String>> ranges) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (Range<String> range : ranges) {
            builder.add(range);
        }
        return builder.build();
    }
}

