/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.datasourcemetadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.io.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.GenericQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import org.apache.hive.druid.io.druid.query.datasourcemetadata.DataSourceMetadataQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import org.apache.hive.druid.io.druid.query.datasourcemetadata.DataSourceQueryQueryToolChest;
import org.apache.hive.druid.io.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.timeline.LogicalSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceMetadataQueryTest {
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        DataSourceMetadataQuery query = Druids.newDataSourceMetadataQueryBuilder().dataSource("testing").build();
        String json = jsonMapper.writeValueAsString((Object)query);
        Query serdeQuery = (Query)jsonMapper.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testContextSerde() throws Exception {
        DataSourceMetadataQuery query = Druids.newDataSourceMetadataQueryBuilder().dataSource("foo").intervals("2013/2014").context((Map)ImmutableMap.of((Object)"priority", (Object)1, (Object)"useCache", (Object)true, (Object)"populateCache", (Object)"true", (Object)"finalize", (Object)true)).build();
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Query serdeQuery = (Query)mapper.readValue(mapper.writeValueAsBytes(mapper.readValue(mapper.writeValueAsString((Object)query), Query.class)), Query.class);
        Assert.assertEquals((Object)1, (Object)serdeQuery.getContextValue("priority"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextValue("useCache"));
        Assert.assertEquals((Object)"true", (Object)serdeQuery.getContextValue("populateCache"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextValue("finalize"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextBoolean("useCache", false));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextBoolean("populateCache", false));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextBoolean("finalize", false));
    }

    @Test
    public void testMaxIngestedEventTime() throws Exception {
        IncrementalIndex rtIndex = new IncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setMaxRowCount(1000).buildOnheap();
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(new DataSourceMetadataQueryRunnerFactory(new DataSourceQueryQueryToolChest(DefaultGenericQueryMetricsFactory.instance()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), (Segment)new IncrementalIndexSegment(rtIndex, "test"), null);
        DateTime timestamp = DateTimes.nowUtc();
        rtIndex.add((InputRow)new MapBasedInputRow(timestamp.getMillis(), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"x")));
        DataSourceMetadataQuery dataSourceMetadataQuery = Druids.newDataSourceMetadataQueryBuilder().dataSource("testing").build();
        ConcurrentHashMap<String, ArrayList> context = new ConcurrentHashMap<String, ArrayList>();
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        List results = Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)dataSourceMetadataQuery), context), (List)Lists.newArrayList());
        DataSourceMetadataResultValue val = (DataSourceMetadataResultValue)((Result)results.iterator().next()).getValue();
        DateTime maxIngestedEventTime = val.getMaxIngestedEventTime();
        Assert.assertEquals((Object)timestamp, (Object)maxIngestedEventTime);
    }

    @Test
    public void testFilterSegments() {
        GenericQueryMetricsFactory queryMetricsFactory = DefaultGenericQueryMetricsFactory.instance();
        DataSourceQueryQueryToolChest toolChest = new DataSourceQueryQueryToolChest(queryMetricsFactory);
        List segments = toolChest.filterSegments(null, Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2012-01-01/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2012-01-01T01/PT1H");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-01/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-01T01/PT1H");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-01T02/PT1H");
            }
        }));
        Assert.assertEquals((long)segments.size(), (long)2L);
        List<LogicalSegment> expected = Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-01/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-01T02/PT1H");
            }
        });
        for (int i = 0; i < segments.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i).getInterval(), (Object)((LogicalSegment)segments.get(i)).getInterval());
        }
    }

    @Test
    public void testResultSerialization() {
        DataSourceMetadataResultValue resultValue = new DataSourceMetadataResultValue(DateTimes.of((String)"2000-01-01T00Z"));
        Map resultValueMap = (Map)new DefaultObjectMapper().convertValue((Object)resultValue, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"maxIngestedEventTime", (Object)"2000-01-01T00:00:00.000Z"), (Object)resultValueMap);
    }

    @Test
    public void testResultDeserialization() {
        ImmutableMap resultValueMap = ImmutableMap.of((Object)"maxIngestedEventTime", (Object)"2000-01-01T00:00:00.000Z");
        DataSourceMetadataResultValue resultValue = (DataSourceMetadataResultValue)new DefaultObjectMapper().convertValue((Object)resultValueMap, DataSourceMetadataResultValue.class);
        Assert.assertEquals((Object)DateTimes.of((String)"2000"), (Object)resultValue.getMaxIngestedEventTime());
    }
}

