/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.TestFloatColumnSelector;
import org.apache.hive.druid.io.druid.query.aggregation.TestLongColumnSelector;
import org.apache.hive.druid.io.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.hive.druid.io.druid.query.aggregation.first.FloatFirstAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.first.FloatFirstAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.first.FloatFirstBufferAggregator;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FloatFirstAggregationTest {
    private FloatFirstAggregatorFactory floatFirstAggregatorFactory;
    private FloatFirstAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector timeSelector;
    private TestFloatColumnSelector valueSelector;
    private TestObjectColumnSelector objectSelector;
    private float[] floats = new float[]{1.1f, 2.7f, 3.5f, 1.3f};
    private long[] times = new long[]{12L, 10L, 5344L, 7899999L};
    private SerializablePair[] pairs = new SerializablePair[]{new SerializablePair((Object)1467225096L, (Object)Float.valueOf(134.3f)), new SerializablePair((Object)23163L, (Object)Float.valueOf(1232.212f)), new SerializablePair((Object)742L, (Object)Float.valueOf(18.0f)), new SerializablePair((Object)111111L, (Object)Float.valueOf(233.5232f))};

    @Before
    public void setup() {
        this.floatFirstAggregatorFactory = new FloatFirstAggregatorFactory("billy", "nilly");
        this.combiningAggFactory = (FloatFirstAggregatorFactory)this.floatFirstAggregatorFactory.getCombiningFactory();
        this.timeSelector = new TestLongColumnSelector(this.times);
        this.valueSelector = new TestFloatColumnSelector(this.floats);
        this.objectSelector = new TestObjectColumnSelector<SerializablePair>(this.pairs);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("__time")).andReturn((Object)this.timeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testDoubleFirstAggregator() {
        FloatFirstAggregator agg = (FloatFirstAggregator)this.floatFirstAggregatorFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.times[1], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.floats[1], (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.floats[1]), (long)agg.getLong());
        Assert.assertEquals((double)this.floats[1], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testDoubleFirstBufferAggregator() {
        FloatFirstBufferAggregator agg = (FloatFirstBufferAggregator)this.floatFirstAggregatorFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.floatFirstAggregatorFactory.getMaxIntermediateSize()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.times[1], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.floats[1], (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.floats[1]), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.floats[1], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)3.621);
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, (Object)785.4);
        Assert.assertEquals((Object)pair1, (Object)this.floatFirstAggregatorFactory.combine((Object)pair1, (Object)pair2));
    }

    @Test
    public void testDoubleFirstCombiningAggregator() {
        FloatFirstAggregator agg = (FloatFirstAggregator)this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((Float)expected.rhs).longValue(), (long)agg.getLong());
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testDoubleFirstCombiningBufferAggregator() {
        FloatFirstBufferAggregator agg = (FloatFirstBufferAggregator)this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.floatFirstAggregatorFactory.getMaxIntermediateSize()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((Float)expected.rhs).longValue(), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String doubleSpecJson = "{\"type\":\"floatFirst\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        Assert.assertEquals((Object)this.floatFirstAggregatorFactory, (Object)mapper.readValue(doubleSpecJson, AggregatorFactory.class));
    }

    private void aggregate(FloatFirstAggregator agg) {
        agg.aggregate();
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(FloatFirstBufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

