/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMinAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMinBufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DoubleMinAggregationTest {
    private DoubleMinAggregatorFactory doubleMinAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestDoubleColumnSelectorImpl selector;
    private double[] values = new double[]{3.5, 2.7, 1.1, 1.3};

    public DoubleMinAggregationTest() throws Exception {
        String aggSpecJson = "{\"type\": \"doubleMin\", \"name\": \"billy\", \"fieldName\": \"nilly\"}";
        this.doubleMinAggFactory = (DoubleMinAggregatorFactory)TestHelper.makeJsonMapper().readValue(aggSpecJson, DoubleMinAggregatorFactory.class);
    }

    @Before
    public void setup() {
        this.selector = new TestDoubleColumnSelectorImpl(this.values);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.selector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testDoubleMinAggregator() {
        DoubleMinAggregator agg = (DoubleMinAggregator)this.doubleMinAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        Assert.assertEquals((double)this.values[2], (double)((Double)agg.get()), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.values[2]), (long)agg.getLong());
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testDoubleMinBufferAggregator() {
        DoubleMinBufferAggregator agg = (DoubleMinBufferAggregator)this.doubleMinAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[8]);
        agg.init(buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        Assert.assertEquals((double)this.values[2], (double)((Double)agg.get(buffer, 0)), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.values[2]), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        Assert.assertEquals((double)1.2, (double)((Double)this.doubleMinAggFactory.combine((Object)1.2, (Object)3.4)), (double)1.0E-4);
    }

    @Test
    public void testEqualsAndHashCode() throws Exception {
        DoubleMinAggregatorFactory one = new DoubleMinAggregatorFactory("name1", "fieldName1");
        DoubleMinAggregatorFactory oneMore = new DoubleMinAggregatorFactory("name1", "fieldName1");
        DoubleMinAggregatorFactory two = new DoubleMinAggregatorFactory("name2", "fieldName2");
        Assert.assertEquals((long)one.hashCode(), (long)oneMore.hashCode());
        Assert.assertTrue((boolean)one.equals((Object)oneMore));
        Assert.assertFalse((boolean)one.equals((Object)two));
    }

    private void aggregate(TestDoubleColumnSelectorImpl selector, DoubleMinAggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void aggregate(TestDoubleColumnSelectorImpl selector, DoubleMinBufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        selector.increment();
    }
}

