/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorUtil;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.junit.Assert;
import org.junit.Test;

public class AggregatorUtilTest {
    @Test
    public void testPruneDependentPostAgg() {
        ArithmeticPostAggregator agg1 = new ArithmeticPostAggregator("abc", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("1", (Number)1L), new ConstantPostAggregator("2", (Number)2L)}));
        ArithmeticPostAggregator dependency1 = new ArithmeticPostAggregator("dep1", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("1", (Number)1L), new ConstantPostAggregator("4", (Number)4L)}));
        FieldAccessPostAggregator agg2 = new FieldAccessPostAggregator("def", "def");
        FieldAccessPostAggregator dependency2 = new FieldAccessPostAggregator("dep2", "dep2");
        ArithmeticPostAggregator aggregator = new ArithmeticPostAggregator("finalAgg", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{new FieldAccessPostAggregator("dep1", "dep1"), new FieldAccessPostAggregator("dep2", "dep2")}));
        List prunedAgg = AggregatorUtil.pruneDependentPostAgg((List)Lists.newArrayList((Object[])new PostAggregator[]{agg1, dependency1, agg2, dependency2, aggregator}), (String)aggregator.getName());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new PostAggregator[]{dependency1, dependency2, aggregator}), (Object)prunedAgg);
    }

    @Test
    public void testOutOfOrderPruneDependentPostAgg() {
        ArithmeticPostAggregator agg1 = new ArithmeticPostAggregator("abc", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("1", (Number)1L), new ConstantPostAggregator("2", (Number)2L)}));
        ArithmeticPostAggregator dependency1 = new ArithmeticPostAggregator("dep1", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("1", (Number)1L), new ConstantPostAggregator("4", (Number)4L)}));
        FieldAccessPostAggregator agg2 = new FieldAccessPostAggregator("def", "def");
        FieldAccessPostAggregator dependency2 = new FieldAccessPostAggregator("dep2", "dep2");
        ArithmeticPostAggregator aggregator = new ArithmeticPostAggregator("finalAgg", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{new FieldAccessPostAggregator("dep1", "dep1"), new FieldAccessPostAggregator("dep2", "dep2")}));
        List prunedAgg = AggregatorUtil.pruneDependentPostAgg((List)Lists.newArrayList((Object[])new PostAggregator[]{agg1, dependency1, aggregator, agg2, dependency2}), (String)aggregator.getName());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new PostAggregator[]{dependency1, aggregator}), (Object)prunedAgg);
    }

    @Test
    public void testCondenseAggregators() {
        ArrayList aggregatorFactories = Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})));
        List<PostAggregator> postAggregatorList = Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant, QueryRunnerTestHelper.dependentPostAgg);
        Pair aggregatorsPair = AggregatorUtil.condensedAggregators((List)aggregatorFactories, postAggregatorList, (String)QueryRunnerTestHelper.dependentPostAggMetric);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum}), (Object)aggregatorsPair.lhs);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new ArithmeticPostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant, QueryRunnerTestHelper.dependentPostAgg}), (Object)aggregatorsPair.rhs);
    }

    @Test
    public void testNullPostAggregatorNames() {
        DoubleSumAggregatorFactory agg1 = new DoubleSumAggregatorFactory("agg1", "value");
        DoubleSumAggregatorFactory agg2 = new DoubleSumAggregatorFactory("agg2", "count");
        ArithmeticPostAggregator postAgg1 = new ArithmeticPostAggregator(null, "*", (List)Lists.newArrayList((Object[])new PostAggregator[]{new FieldAccessPostAggregator(null, "agg1"), new FieldAccessPostAggregator(null, "agg2")}));
        ArithmeticPostAggregator postAgg2 = new ArithmeticPostAggregator("postAgg", "/", (List)Lists.newArrayList((Object[])new PostAggregator[]{new FieldAccessPostAggregator(null, "agg1"), new FieldAccessPostAggregator(null, "agg2")}));
        Assert.assertEquals((Object)new Pair((Object)Lists.newArrayList((Object[])new AggregatorFactory[]{agg1, agg2}), (Object)Lists.newArrayList((Object[])new PostAggregator[]{postAgg2})), (Object)AggregatorUtil.condensedAggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{agg1, agg2}), (List)Lists.newArrayList((Object[])new PostAggregator[]{postAgg1, postAgg2}), (String)"postAgg"));
    }

    @Test
    public void testCasing() {
        DoubleSumAggregatorFactory agg1 = new DoubleSumAggregatorFactory("Agg1", "value");
        DoubleSumAggregatorFactory agg2 = new DoubleSumAggregatorFactory("Agg2", "count");
        ArithmeticPostAggregator postAgg1 = new ArithmeticPostAggregator(null, "*", (List)Lists.newArrayList((Object[])new PostAggregator[]{new FieldAccessPostAggregator(null, "Agg1"), new FieldAccessPostAggregator(null, "Agg2")}));
        ArithmeticPostAggregator postAgg2 = new ArithmeticPostAggregator("postAgg", "/", (List)Lists.newArrayList((Object[])new PostAggregator[]{new FieldAccessPostAggregator(null, "Agg1"), new FieldAccessPostAggregator(null, "Agg2")}));
        Assert.assertEquals((Object)new Pair((Object)Lists.newArrayList((Object[])new AggregatorFactory[]{agg1, agg2}), (Object)Lists.newArrayList((Object[])new PostAggregator[]{postAgg2})), (Object)AggregatorUtil.condensedAggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{agg1, agg2}), (List)Lists.newArrayList((Object[])new PostAggregator[]{postAgg1, postAgg2}), (String)"postAgg"));
    }
}

