/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Accumulators;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.TimewarpOperator;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class TimewarpOperatorTest {
    public static final ImmutableMap<String, Object> CONTEXT = ImmutableMap.of();
    TimewarpOperator<Result<TimeseriesResultValue>> testOperator = new TimewarpOperator(new Interval((ReadableInstant)DateTimes.of((String)"2014-01-01"), (ReadableInstant)DateTimes.of((String)"2014-01-15")), new Period((Object)"P1W"), DateTimes.of((String)"2014-01-06"));

    @Test
    public void testComputeOffset() throws Exception {
        DateTime t = DateTimes.of((String)"2014-01-23");
        DateTime tOffset = DateTimes.of((String)"2014-01-09");
        Assert.assertEquals((Object)tOffset, (Object)t.plus(this.testOperator.computeOffset(t.getMillis(), DateTimeZone.UTC)));
        t = DateTimes.of((String)"2014-08-02");
        tOffset = DateTimes.of((String)"2014-01-11");
        Assert.assertEquals((Object)tOffset, (Object)t.plus(this.testOperator.computeOffset(t.getMillis(), DateTimeZone.UTC)));
        t = DateTimes.of((String)"2014-08-02T-07");
        tOffset = DateTimes.of((String)"2014-01-11T-08");
        Assert.assertEquals((Object)tOffset, (Object)t.plus(this.testOperator.computeOffset(t.getMillis(), DateTimeZone.forID((String)"America/Los_Angeles"))));
    }

    @Test
    public void testPostProcess() throws Exception {
        QueryRunner queryRunner = this.testOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(DateTimes.of((String)"2014-01-09"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), (Object)new Result(DateTimes.of((String)"2014-01-11"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), (Object)new Result(((Interval)queryPlus.getQuery().getIntervals().get(0)).getEnd(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))));
            }
        }, DateTimes.of((String)"2014-08-02").getMillis());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2014-07-31/2014-08-05").aggregators(Arrays.asList(new CountAggregatorFactory("count"))).build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2014-07-31"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), new Result(DateTimes.of((String)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), new Result(DateTimes.of((String)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))}), (Object)Sequences.toList((Sequence)queryRunner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList()));
        TimewarpOperator timeBoundaryOperator = new TimewarpOperator(new Interval((ReadableInstant)DateTimes.of((String)"2014-01-01"), (ReadableInstant)DateTimes.of((String)"2014-01-15")), new Period((Object)"P1W"), DateTimes.of((String)"2014-01-06"));
        QueryRunner timeBoundaryRunner = timeBoundaryOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeBoundaryResultValue>>(){

            public Sequence<Result<TimeBoundaryResultValue>> run(QueryPlus<Result<TimeBoundaryResultValue>> queryPlus, Map<String, Object> responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(DateTimes.of((String)"2014-01-12"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)DateTimes.of((String)"2014-01-12"))))));
            }
        }, DateTimes.of((String)"2014-08-02").getMillis());
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("dummy").build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2014-08-02"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)DateTimes.of((String)"2014-08-02"))))}), (Object)Sequences.toList((Sequence)timeBoundaryRunner.run(QueryPlus.wrap((Query)timeBoundaryQuery), CONTEXT), (List)Lists.newArrayList()));
    }

    @Test
    public void testPostProcessWithTimezonesAndDstShift() throws Exception {
        QueryRunner queryRunner = this.testOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(DateTimes.of((String)"2014-01-09T-08"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), (Object)new Result(DateTimes.of((String)"2014-01-11T-08"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), (Object)new Result(((Interval)queryPlus.getQuery().getIntervals().get(0)).getEnd(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))));
            }
        }, DateTimes.of((String)"2014-08-02T-07").getMillis());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2014-07-31T-07/2014-08-05T-07").granularity((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimeZone.forID((String)"America/Los_Angeles"))).aggregators(Arrays.asList(new CountAggregatorFactory("count"))).build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2014-07-31T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), new Result(DateTimes.of((String)"2014-08-02T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), new Result(DateTimes.of((String)"2014-08-02T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))}), (Object)queryRunner.run(QueryPlus.wrap((Query)query), CONTEXT).accumulate(new ArrayList(), Accumulators.list()));
    }

    @Test
    public void testPostProcessWithTimezonesAndNoDstShift() throws Exception {
        QueryRunner queryRunner = this.testOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(DateTimes.of((String)"2014-01-09T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), (Object)new Result(DateTimes.of((String)"2014-01-11T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), (Object)new Result(((Interval)queryPlus.getQuery().getIntervals().get(0)).getEnd(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))));
            }
        }, DateTimes.of((String)"2014-08-02T-07").getMillis());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2014-07-31T-07/2014-08-05T-07").granularity((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimeZone.forID((String)"America/Phoenix"))).aggregators(Arrays.asList(new CountAggregatorFactory("count"))).build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2014-07-31T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), new Result(DateTimes.of((String)"2014-08-02T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), new Result(DateTimes.of((String)"2014-08-02T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))}), (Object)queryRunner.run(QueryPlus.wrap((Query)query), CONTEXT).accumulate(new ArrayList(), Accumulators.list()));
    }

    @Test
    public void testEmptyFutureInterval() throws Exception {
        QueryRunner queryRunner = this.testOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> responseContext) {
                Query query = queryPlus.getQuery();
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(((Interval)query.getIntervals().get(0)).getStart(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), (Object)new Result(((Interval)query.getIntervals().get(0)).getEnd(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3)))));
            }
        }, DateTimes.of((String)"2014-08-02").getMillis());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2014-08-06/2014-08-08").aggregators(Arrays.asList(new CountAggregatorFactory("count"))).build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), new Result(DateTimes.of((String)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3)))}), (Object)Sequences.toList((Sequence)queryRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList()));
    }
}

