/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageConnectorConfig;
import org.junit.Assert;
import org.junit.Test;

public class MetadataStorageConnectorConfigTest {
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    private MetadataStorageConnectorConfig createMetadataStorageConfig(boolean createTables, String host, int port, String connectURI, String user, String pwdString) throws IOException {
        return (MetadataStorageConnectorConfig)jsonMapper.readValue("{\"createTables\": \"" + createTables + "\",\"host\": \"" + host + "\",\"port\": \"" + port + "\",\"connectURI\": \"" + connectURI + "\",\"user\": \"" + user + "\",\"password\": " + pwdString + "}", MetadataStorageConnectorConfig.class);
    }

    @Test
    public void testEquals() throws IOException {
        MetadataStorageConnectorConfig metadataStorageConnectorConfig = this.createMetadataStorageConfig(true, "testHost", 4000, "url", "user", "\"nothing\"");
        MetadataStorageConnectorConfig metadataStorageConnectorConfig2 = this.createMetadataStorageConfig(true, "testHost", 4000, "url", "user", "\"nothing\"");
        Assert.assertTrue((boolean)metadataStorageConnectorConfig.equals((Object)metadataStorageConnectorConfig2));
    }

    @Test
    public void testMetadataStorageConnectionConfigSimplePassword() throws Exception {
        this.testMetadataStorageConnectionConfig(true, "host", 1234, "connectURI", "user", "\"nothing\"", "nothing");
    }

    @Test
    public void testMetadataStorageConnectionConfigWithDefaultProviderPassword() throws Exception {
        this.testMetadataStorageConnectionConfig(true, "host", 1234, "connectURI", "user", "{\"type\":\"default\",\"password\":\"nothing\"}", "nothing");
    }

    private void testMetadataStorageConnectionConfig(boolean createTables, String host, int port, String connectURI, String user, String pwdString, String pwd) throws Exception {
        MetadataStorageConnectorConfig config = (MetadataStorageConnectorConfig)jsonMapper.readValue("{\"createTables\": \"" + createTables + "\",\"host\": \"" + host + "\",\"port\": \"" + port + "\",\"connectURI\": \"" + connectURI + "\",\"user\": \"" + user + "\",\"password\": " + pwdString + "}", MetadataStorageConnectorConfig.class);
        Assert.assertEquals((Object)host, (Object)config.getHost());
        Assert.assertEquals((long)port, (long)config.getPort());
        Assert.assertEquals((Object)connectURI, (Object)config.getConnectURI());
        Assert.assertEquals((Object)user, (Object)config.getUser());
        Assert.assertEquals((Object)pwd, (Object)config.getPassword());
    }
}

