/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.io.druid.indexing.overlord.DataSourceMetadata;
import org.apache.hive.druid.io.druid.indexing.overlord.ObjectMetadata;
import org.apache.hive.druid.io.druid.indexing.overlord.SegmentPublishResult;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.metadata.TestDerbyConnector;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.LinearShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class IndexerSQLMetadataStorageCoordinatorTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();
    private final DataSegment defaultSegment = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment defaultSegment2 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 100L);
    private final DataSegment defaultSegment3 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-03T00Z/2015-01-04T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 100L);
    private final DataSegment defaultSegment4 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment0of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment1of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(1, 0), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment2of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(2, 0), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment2of1 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(2, 1), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment3of1 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(3, 1), Integer.valueOf(9), 100L);
    private final Set<DataSegment> SEGMENTS = ImmutableSet.of((Object)this.defaultSegment, (Object)this.defaultSegment2);
    private final AtomicLong metadataUpdateCounter = new AtomicLong();
    private IndexerSQLMetadataStorageCoordinator coordinator;
    private TestDerbyConnector derbyConnector;

    @Before
    public void setUp() {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        this.mapper.registerSubtypes(new Class[]{LinearShardSpec.class, NumberedShardSpec.class});
        this.derbyConnector.createDataSourceTable();
        this.derbyConnector.createTaskTables();
        this.derbyConnector.createSegmentTable();
        this.derbyConnector.createPendingSegmentsTable();
        this.metadataUpdateCounter.set(0L);
        this.coordinator = new IndexerSQLMetadataStorageCoordinator(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector){

            protected IndexerSQLMetadataStorageCoordinator.DataSourceMetadataUpdateResult updateDataSourceMetadataWithHandle(Handle handle, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) throws IOException {
                IndexerSQLMetadataStorageCoordinatorTest.this.metadataUpdateCounter.getAndIncrement();
                return super.updateDataSourceMetadataWithHandle(handle, dataSource, startMetadata, endMetadata);
            }
        };
    }

    private void unUseSegment() {
        for (final DataSegment segment : this.SEGMENTS) {
            Assert.assertEquals((long)1L, (long)((Integer)this.derbyConnector.getDBI().withHandle((HandleCallback)new HandleCallback<Integer>(){

                public Integer withHandle(Handle handle) throws Exception {
                    return ((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET used = false WHERE id = :id", (Object[])new Object[]{((MetadataStorageTablesConfig)IndexerSQLMetadataStorageCoordinatorTest.this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable()})).bind("id", segment.getIdentifier())).execute();
                }
            })).intValue());
        }
    }

    private List<String> getUsedIdentifiers() {
        final String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle((HandleCallback)new HandleCallback<List<String>>(){

            public List<String> withHandle(Handle handle) throws Exception {
                return handle.createQuery("SELECT id FROM " + table + " WHERE used = true ORDER BY id").map((ResultSetMapper)StringMapper.FIRST).list();
            }
        });
    }

    @Test
    public void testSimpleAnnounce() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        for (DataSegment segment : this.SEGMENTS) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment).getBytes("UTF-8"), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment.getIdentifier()));
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)this.defaultSegment.getIdentifier(), (Object)this.defaultSegment2.getIdentifier()), this.getUsedIdentifiers());
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testOvershadowingAnnounce() throws IOException {
        ImmutableSet segments = ImmutableSet.of((Object)this.defaultSegment, (Object)this.defaultSegment2, (Object)this.defaultSegment4);
        this.coordinator.announceHistoricalSegments((Set)segments);
        for (DataSegment segment : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment).getBytes("UTF-8"), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment.getIdentifier()));
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)this.defaultSegment4.getIdentifier()), this.getUsedIdentifiers());
    }

    @Test
    public void testTransactionalAnnounceSuccess() throws IOException {
        SegmentPublishResult result1 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)new SegmentPublishResult((Set)ImmutableSet.of((Object)this.defaultSegment), true), (Object)result1);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment).getBytes("UTF-8"), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment.getIdentifier()));
        SegmentPublishResult result2 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)new SegmentPublishResult((Set)ImmutableSet.of((Object)this.defaultSegment2), true), (Object)result2);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment2).getBytes("UTF-8"), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment2.getIdentifier()));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), (Object)this.coordinator.getDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceRetryAndSuccess() throws IOException {
        final AtomicLong attemptCounter = new AtomicLong();
        IndexerSQLMetadataStorageCoordinator failOnceCoordinator = new IndexerSQLMetadataStorageCoordinator(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector){

            protected IndexerSQLMetadataStorageCoordinator.DataSourceMetadataUpdateResult updateDataSourceMetadataWithHandle(Handle handle, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) throws IOException {
                IndexerSQLMetadataStorageCoordinatorTest.this.metadataUpdateCounter.getAndIncrement();
                if (attemptCounter.getAndIncrement() == 0L) {
                    return IndexerSQLMetadataStorageCoordinator.DataSourceMetadataUpdateResult.TRY_AGAIN;
                }
                return super.updateDataSourceMetadataWithHandle(handle, dataSource, startMetadata, endMetadata);
            }
        };
        SegmentPublishResult result1 = failOnceCoordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)new SegmentPublishResult((Set)ImmutableSet.of((Object)this.defaultSegment), true), (Object)result1);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment).getBytes("UTF-8"), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment.getIdentifier()));
        attemptCounter.set(0L);
        SegmentPublishResult result2 = failOnceCoordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)new SegmentPublishResult((Set)ImmutableSet.of((Object)this.defaultSegment2), true), (Object)result2);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment2).getBytes("UTF-8"), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment2.getIdentifier()));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), (Object)failOnceCoordinator.getDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)4L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceFailDbNullWantNotNull() throws IOException {
        SegmentPublishResult result1 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)new SegmentPublishResult((Set)ImmutableSet.of(), false), (Object)result1);
        Assert.assertEquals((long)1L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceFailDbNotNullWantNull() throws IOException {
        SegmentPublishResult result1 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)new SegmentPublishResult((Set)ImmutableSet.of((Object)this.defaultSegment), true), (Object)result1);
        SegmentPublishResult result2 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)new SegmentPublishResult((Set)ImmutableSet.of(), false), (Object)result2);
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceFailDbNotNullWantDifferent() throws IOException {
        SegmentPublishResult result1 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)new SegmentPublishResult((Set)ImmutableSet.of((Object)this.defaultSegment), true), (Object)result1);
        SegmentPublishResult result2 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"qux")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)new SegmentPublishResult((Set)ImmutableSet.of(), false), (Object)result2);
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testSimpleUsedList() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval())));
    }

    @Test
    public void testMultiIntervalUsedList() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment3));
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment.getInterval()))));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.defaultSegment3), (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment3.getInterval()))));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.defaultSegment, (Object)this.defaultSegment2, (Object)this.defaultSegment3), (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment.getInterval(), (Object)this.defaultSegment3.getInterval()))));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.defaultSegment3), (Object)this.coordinator.getUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)Intervals.of((String)"2015-01-03T00Z/2015-01-03T05Z"), (Object)Intervals.of((String)"2015-01-03T09Z/2015-01-04T00Z"))));
    }

    @Test
    public void testSimpleUnUsedList() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.unUseSegment();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval())));
    }

    @Test
    public void testUsedOverlapLow() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        ImmutableSet actualSegments = ImmutableSet.copyOf((Collection)this.coordinator.getUsedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2014-12-31T23:59:59.999Z/2015-01-01T00:00:00.001Z")));
        Assert.assertEquals(this.SEGMENTS, (Object)actualSegments);
    }

    @Test
    public void testUsedOverlapHigh() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUsedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2015-1-1T23:59:59.999Z/2015-02-01T00Z"))));
    }

    @Test
    public void testUsedOutOfBoundsLow() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertTrue((boolean)this.coordinator.getUsedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L), (ReadableInstant)this.defaultSegment.getInterval().getStart())).isEmpty());
    }

    @Test
    public void testUsedOutOfBoundsHigh() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertTrue((boolean)this.coordinator.getUsedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getEnd(), (ReadableInstant)this.defaultSegment.getInterval().getEnd().plusDays(10))).isEmpty());
    }

    @Test
    public void testUsedWithinBoundsEnd() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().minusMillis(1)))));
    }

    @Test
    public void testUsedOverlapEnd() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plusMillis(1)))));
    }

    @Test
    public void testUnUsedOverlapLow() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.unUseSegment();
        Assert.assertTrue((boolean)this.coordinator.getUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L), (ReadableInstant)this.defaultSegment.getInterval().getStart().plus(1L))).isEmpty());
    }

    @Test
    public void testUnUsedUnderlapLow() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.unUseSegment();
        Assert.assertTrue((boolean)this.coordinator.getUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().plus(1L), (ReadableInstant)this.defaultSegment.getInterval().getEnd())).isEmpty());
    }

    @Test
    public void testUnUsedUnderlapHigh() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.unUseSegment();
        Assert.assertTrue((boolean)this.coordinator.getUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart(), (ReadableInstant)this.defaultSegment.getInterval().getEnd().minus(1L))).isEmpty());
    }

    @Test
    public void testUnUsedOverlapHigh() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.unUseSegment();
        Assert.assertTrue((boolean)this.coordinator.getUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getEnd().minus(1L))).isEmpty());
    }

    @Test
    public void testUnUsedBigOverlap() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.unUseSegment();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2000/2999"))));
    }

    @Test
    public void testUnUsedLowRange() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.unUseSegment();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L)))));
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getStart().minusYears(1)))));
    }

    @Test
    public void testUnUsedHighRange() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.unUseSegment();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plus(1L)))));
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.getUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plusYears(1)))));
    }

    @Test
    public void testDeleteDataSourceMetadata() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.getDataSourceMetadata("fooDataSource"));
        Assert.assertFalse((String)"deleteInvalidDataSourceMetadata", (boolean)this.coordinator.deleteDataSourceMetadata("nonExistentDS"));
        Assert.assertTrue((String)"deleteValidDataSourceMetadata", (boolean)this.coordinator.deleteDataSourceMetadata("fooDataSource"));
        Assert.assertNull((String)"getDataSourceMetadataNullAfterDelete", (Object)this.coordinator.getDataSourceMetadata("fooDataSource"));
    }

    @Test
    public void testSingleAdditionalNumberedShardWithNoCorePartitions() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment0of0));
    }

    @Test
    public void testMultipleAdditionalNumberedShardsWithNoCorePartitions() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.numberedSegment1of0, (Object)this.numberedSegment2of0));
    }

    @Test
    public void testSingleAdditionalNumberedShardWithOneCorePartition() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment2of1));
    }

    @Test
    public void testMultipleAdditionalNumberedShardsWithOneCorePartition() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment2of1, (Object)this.numberedSegment3of1));
    }

    private void additionalNumberedShardTest(Set<DataSegment> segments) throws IOException {
        this.coordinator.announceHistoricalSegments(segments);
        for (DataSegment segment : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment).getBytes("UTF-8"), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment.getIdentifier()));
        }
        Assert.assertEquals(segments.stream().map(DataSegment::getIdentifier).collect(Collectors.toList()), this.getUsedIdentifiers());
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testAllocatePendingSegment() throws IOException {
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdentifier identifier = this.coordinator.allocatePendingSegment("ds", "seq", null, interval, "version", false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version", (Object)identifier.toString());
        SegmentIdentifier identifier1 = this.coordinator.allocatePendingSegment("ds", "seq", identifier.toString(), interval, identifier.getVersion(), false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_1", (Object)identifier1.toString());
        SegmentIdentifier identifier2 = this.coordinator.allocatePendingSegment("ds", "seq", identifier1.toString(), interval, identifier1.getVersion(), false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_2", (Object)identifier2.toString());
        SegmentIdentifier identifier3 = this.coordinator.allocatePendingSegment("ds", "seq", identifier1.toString(), interval, identifier1.getVersion(), false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_2", (Object)identifier3.toString());
        Assert.assertEquals((Object)identifier2, (Object)identifier3);
        SegmentIdentifier identifier4 = this.coordinator.allocatePendingSegment("ds", "seq1", null, interval, "version", false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_3", (Object)identifier4.toString());
    }

    @Test
    public void testDeletePendingSegment() throws IOException, InterruptedException {
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        String prevSegmentId = null;
        DateTime begin = DateTimes.nowUtc();
        for (int i = 0; i < 10; ++i) {
            SegmentIdentifier identifier = this.coordinator.allocatePendingSegment("ds", "seq", prevSegmentId, interval, "version", false);
            prevSegmentId = identifier.toString();
        }
        Thread.sleep(100L);
        DateTime secondBegin = DateTimes.nowUtc();
        for (int i = 0; i < 5; ++i) {
            SegmentIdentifier identifier = this.coordinator.allocatePendingSegment("ds", "seq", prevSegmentId, interval, "version", false);
            prevSegmentId = identifier.toString();
        }
        int numDeleted = this.coordinator.deletePendingSegments("ds", new Interval((ReadableInstant)begin, (ReadableInstant)secondBegin));
        Assert.assertEquals((long)10L, (long)numDeleted);
    }
}

