/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.math.expr;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.junit.Assert;
import org.junit.Test;

public class FunctionTest {
    private final Expr.ObjectBinding bindings = Parser.withMap((Map)ImmutableMap.of((Object)"x", (Object)"foo", (Object)"y", (Object)2, (Object)"z", (Object)3.1));

    @Test
    public void testCaseSimple() {
        this.assertExpr("case_simple(x,'baz','is baz','foo','is foo','is other')", "is foo");
        this.assertExpr("case_simple(x,'baz','is baz','bar','is bar','is other')", "is other");
        this.assertExpr("case_simple(y,2,'is 2',3,'is 3','is other')", "is 2");
        this.assertExpr("case_simple(z,2,'is 2',3,'is 3','is other')", "is other");
    }

    @Test
    public void testCaseSearched() {
        this.assertExpr("case_searched(x=='baz','is baz',x=='foo','is foo','is other')", "is foo");
        this.assertExpr("case_searched(x=='baz','is baz',x=='bar','is bar','is other')", "is other");
        this.assertExpr("case_searched(y==2,'is 2',y==3,'is 3','is other')", "is 2");
        this.assertExpr("case_searched(z==2,'is 2',z==3,'is 3','is other')", "is other");
    }

    @Test
    public void testConcat() {
        this.assertExpr("concat(x,' ',y)", "foo 2");
        this.assertExpr("concat(x,' ',nonexistent,' ',y)", "foo  2");
        this.assertExpr("concat(z)", "3.1");
        this.assertExpr("concat()", null);
    }

    @Test
    public void testReplace() {
        this.assertExpr("replace(x,'oo','ab')", "fab");
        this.assertExpr("replace(x,x,'ab')", "ab");
        this.assertExpr("replace(x,'oo',y)", "f2");
    }

    @Test
    public void testSubstring() {
        this.assertExpr("substring(x,0,2)", "fo");
        this.assertExpr("substring(x,1,2)", "oo");
        this.assertExpr("substring(x,y,1)", "o");
        this.assertExpr("substring(x,0,-1)", "foo");
        this.assertExpr("substring(x,0,100)", "foo");
    }

    @Test
    public void testStrlen() {
        this.assertExpr("strlen(x)", 3L);
        this.assertExpr("strlen(nonexistent)", 0L);
    }

    @Test
    public void testStrpos() {
        this.assertExpr("strpos(x, 'o')", 1L);
        this.assertExpr("strpos(x, '')", 0L);
        this.assertExpr("strpos(x, 'x')", -1L);
    }

    @Test
    public void testLower() {
        this.assertExpr("lower('FOO')", "foo");
    }

    @Test
    public void testUpper() {
        this.assertExpr("upper(x)", "FOO");
    }

    private void assertExpr(String expression, Object expectedResult) {
        Expr expr = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil());
        Assert.assertEquals((String)expression, (Object)expectedResult, (Object)expr.eval(this.bindings).value());
    }
}

