/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.metrics;

import java.io.IOException;
import java.util.List;
import org.apache.hive.druid.io.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.io.druid.java.util.emitter.core.Event;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.io.druid.java.util.metrics.JvmMonitor;
import org.junit.Assert;
import org.junit.Test;

public class JvmMonitorTest {
    @Test(timeout=60000L)
    public void testGcCounts() throws InterruptedException {
        GcTrackingEmitter emitter = new GcTrackingEmitter();
        ServiceEmitter serviceEmitter = new ServiceEmitter("test", "localhost", (Emitter)emitter);
        serviceEmitter.start();
        JvmMonitor jvmMonitor = new JvmMonitor();
        while (true) {
            byte[] b = new byte[0x3200000];
            emitter.reset();
            jvmMonitor.doMonitor(serviceEmitter);
            if (emitter.gcSeen()) {
                return;
            }
            Thread.sleep(10L);
        }
    }

    private static class GcTrackingEmitter
    implements Emitter {
        private Number oldGcCount;
        private Number oldGcCpu;
        private Number youngGcCount;
        private Number youngGcCpu;

        private GcTrackingEmitter() {
        }

        public void start() {
        }

        void reset() {
            this.oldGcCount = null;
            this.oldGcCpu = null;
            this.youngGcCount = null;
            this.youngGcCpu = null;
        }

        public void emit(Event e) {
            ServiceMetricEvent event = (ServiceMetricEvent)e;
            String gcGen = null;
            if (event.toMap().get("gcGen") != null) {
                gcGen = ((List)event.toMap().get("gcGen")).get(0).toString();
            }
            switch (event.getMetric() + "/" + gcGen) {
                case "jvm/gc/count/old": {
                    this.oldGcCount = event.getValue();
                    break;
                }
                case "jvm/gc/cpu/old": {
                    this.oldGcCpu = event.getValue();
                    break;
                }
                case "jvm/gc/count/young": {
                    this.youngGcCount = event.getValue();
                    break;
                }
                case "jvm/gc/cpu/young": {
                    this.youngGcCpu = event.getValue();
                }
            }
        }

        boolean gcSeen() {
            return this.oldGcSeen() || this.youngGcSeen();
        }

        private boolean oldGcSeen() {
            boolean oldGcCpuSeen;
            boolean oldGcCountSeen = this.oldGcCount != null && this.oldGcCount.longValue() > 0L;
            boolean bl = oldGcCpuSeen = this.oldGcCpu != null && this.oldGcCpu.longValue() > 0L;
            if (oldGcCountSeen || oldGcCpuSeen) {
                System.out.println("old count: " + this.oldGcCount + ", cpu: " + this.oldGcCpu);
            }
            Assert.assertFalse((String)"expected to see old gc count and cpu both zero or non-existent or both positive", (boolean)(oldGcCountSeen ^ oldGcCpuSeen));
            return oldGcCountSeen;
        }

        private boolean youngGcSeen() {
            boolean youngGcCpuSeen;
            boolean youngGcCountSeen = this.youngGcCount != null && this.youngGcCount.longValue() > 0L;
            boolean bl = youngGcCpuSeen = this.youngGcCpu != null && this.youngGcCpu.longValue() > 0L;
            if (youngGcCountSeen || youngGcCpuSeen) {
                System.out.println("young count: " + this.youngGcCount + ", cpu: " + this.youngGcCpu);
            }
            Assert.assertFalse((String)"expected to see young gc count and cpu both zero/non-existent or both positive", (boolean)(youngGcCountSeen ^ youngGcCpuSeen));
            return youngGcCountSeen;
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

