/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.hll;

import com.google.caliper.Param;
import com.google.caliper.Runner;
import com.google.caliper.SimpleBenchmark;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.com.google.common.hash.Hashing;
import org.apache.hive.druid.io.druid.hll.ByteBuffers;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;

public class HyperLogLogCollectorBenchmark
extends SimpleBenchmark {
    private final HashFunction fn = Hashing.murmur3_128();
    private final List<HyperLogLogCollector> collectors = Lists.newLinkedList();
    @Param(value={"true"})
    boolean targetIsDirect;
    @Param(value={"default", "random", "0"})
    String alignment;
    boolean alignSource;
    boolean alignTarget;
    int CACHE_LINE = 64;
    ByteBuffer chunk;
    final int count = 100000;
    int[] positions = new int[100000];
    int[] sizes = new int[100000];

    protected void setUp() throws Exception {
        boolean random = false;
        Random rand = new Random(0L);
        int defaultOffset = 0;
        switch (this.alignment) {
            case "default": {
                this.alignSource = false;
                this.alignTarget = false;
                break;
            }
            case "random": {
                random = true;
                break;
            }
            default: {
                defaultOffset = Integer.parseInt(this.alignment);
            }
        }
        int val = 0;
        this.chunk = ByteBuffers.allocateAlignedByteBuffer((HyperLogLogCollector.getLatestNumBytesForDenseStorage() + this.CACHE_LINE + this.CACHE_LINE) * 100000, this.CACHE_LINE);
        int pos = 0;
        for (int i = 0; i < 100000; ++i) {
            int offset;
            HyperLogLogCollector c = HyperLogLogCollector.makeLatestCollector();
            for (int k = 0; k < 40; ++k) {
                c.add(this.fn.hashInt(++val).asBytes());
            }
            ByteBuffer sparseHeapCopy = c.toByteBuffer();
            int size = sparseHeapCopy.remaining();
            int n = offset = random ? (int)(rand.nextDouble() * 64.0) : defaultOffset;
            if (this.alignSource && pos % this.CACHE_LINE != offset) {
                pos += pos % this.CACHE_LINE < offset ? offset - pos % this.CACHE_LINE : this.CACHE_LINE + offset - pos % this.CACHE_LINE;
            }
            this.positions[i] = pos;
            this.sizes[i] = size;
            this.chunk.limit(pos + size);
            this.chunk.position(pos);
            ByteBuffer buf = this.chunk.duplicate();
            buf.mark();
            pos += size;
            buf.put(sparseHeapCopy);
            buf.reset();
            this.collectors.add(HyperLogLogCollector.makeCollector((ByteBuffer)buf));
        }
    }

    private ByteBuffer allocateEmptyHLLBuffer(boolean direct, boolean aligned, int offset) {
        ByteBuffer buf;
        int size = HyperLogLogCollector.getLatestNumBytesForDenseStorage();
        byte[] EMPTY_BYTES = HyperLogLogCollector.makeEmptyVersionedByteArray();
        if (direct) {
            if (aligned) {
                buf = ByteBuffers.allocateAlignedByteBuffer(size + offset, this.CACHE_LINE);
                buf.position(offset);
                buf.mark();
                buf.limit(size + offset);
            } else {
                buf = ByteBuffer.allocateDirect(size);
                buf.mark();
                buf.limit(size);
            }
            buf.put(EMPTY_BYTES);
            buf.reset();
        } else {
            buf = ByteBuffer.allocate(size);
            buf.limit(size);
            buf.put(EMPTY_BYTES);
            buf.rewind();
        }
        return buf;
    }

    public double timeFold(int reps) throws Exception {
        ByteBuffer buf = this.allocateEmptyHLLBuffer(this.targetIsDirect, this.alignTarget, 0);
        for (int k = 0; k < reps; ++k) {
            for (int i = 0; i < 100000; ++i) {
                int pos = this.positions[i];
                int size = this.sizes[i];
                HyperLogLogCollector.makeCollector((ByteBuffer)((ByteBuffer)buf.duplicate().position(0).limit(HyperLogLogCollector.getLatestNumBytesForDenseStorage()))).fold(HyperLogLogCollector.makeCollector((ByteBuffer)((ByteBuffer)this.chunk.duplicate().limit(pos + size).position(pos))));
            }
        }
        return HyperLogLogCollector.makeCollector((ByteBuffer)buf.duplicate()).estimateCardinality();
    }

    public static void main(String[] args) throws Exception {
        Runner.main(HyperLogLogCollectorBenchmark.class, (String[])args);
    }
}

