/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator.discovery;

import java.util.List;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.io.druid.curator.CuratorTestBase;
import org.apache.hive.druid.io.druid.curator.discovery.CuratorServiceUtils;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServiceAnnouncerTest
extends CuratorTestBase {
    @Before
    public void setUp() throws Exception {
        this.setupServerAndCurator();
    }

    @Test
    public void testServiceAnnouncement() throws Exception {
        this.curator.start();
        this.curator.blockUntilConnected();
        ImmutableList serviceNames = ImmutableList.of((Object)"druid/overlord", (Object)"druid/coordinator", (Object)"druid/firehose/tranquility_test-50-0000-0000");
        final ServiceDiscovery serviceDiscovery = this.createAndAnnounceServices((List<String>)serviceNames);
        Assert.assertTrue((boolean)Iterators.all(serviceNames.iterator(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                try {
                    return serviceDiscovery.queryForInstances(input.replaceAll("/", ":")).size() == 1;
                }
                catch (Exception e) {
                    throw new ISE("Something went wrong while finding instance with name [%s] in Service Discovery", new Object[]{input});
                }
            }
        }));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testServiceAnnouncementFail() throws Exception {
        this.curator.start();
        this.curator.blockUntilConnected();
        this.createAndAnnounceServices((List<String>)ImmutableList.of((Object)"placeholder/\u0001"));
    }

    private ServiceDiscovery createAndAnnounceServices(List<String> serviceNames) throws Exception {
        int port = 1000;
        ServiceDiscovery serviceDiscovery = ServiceDiscoveryBuilder.builder(Void.class).basePath("/test").client(this.curator).build();
        for (String serviceName : serviceNames) {
            String serviceNameToUse = CuratorServiceUtils.makeCanonicalServiceName((String)serviceName);
            ServiceInstance instance = ServiceInstance.builder().name(serviceNameToUse).address("localhost").port(port++).build();
            serviceDiscovery.registerService(instance);
        }
        return serviceDiscovery;
    }

    @After
    public void tearDown() {
        this.tearDownServerAndCurator();
    }
}

