/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections.spatial;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.com.google.common.base.Stopwatch;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.primitives.Bytes;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.hive.druid.io.druid.collections.spatial.ImmutableRTree;
import org.apache.hive.druid.io.druid.collections.spatial.RTree;
import org.apache.hive.druid.io.druid.collections.spatial.search.Bound;
import org.apache.hive.druid.io.druid.collections.spatial.search.PolygonBound;
import org.apache.hive.druid.io.druid.collections.spatial.search.RadiusBound;
import org.apache.hive.druid.io.druid.collections.spatial.search.RectangularBound;
import org.apache.hive.druid.io.druid.collections.spatial.split.LinearGutmanSplitStrategy;
import org.apache.hive.druid.io.druid.collections.spatial.split.SplitStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.ImmutableRTreeObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;
import org.junit.Assert;
import org.junit.Test;

public class ImmutableRTreeTest {
    @Test
    public void testToAndFromByteBuffer() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{1.0f, 1.0f}, 2);
        tree.insert(new float[]{2.0f, 2.0f}, 3);
        tree.insert(new float[]{3.0f, 3.0f}, 4);
        tree.insert(new float[]{4.0f, 4.0f}, 5);
        ImmutableRTree firstTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        ByteBuffer buffer = ByteBuffer.wrap(firstTree.toBytes());
        ImmutableRTree secondTree = new ImmutableRTree(buffer, (BitmapFactory)bf);
        Iterable points = secondTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 10.0f));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testToAndFromByteBufferRoaring() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{1.0f, 1.0f}, 2);
        tree.insert(new float[]{2.0f, 2.0f}, 3);
        tree.insert(new float[]{3.0f, 3.0f}, 4);
        tree.insert(new float[]{4.0f, 4.0f}, 5);
        ImmutableRTree firstTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        ByteBuffer buffer = ByteBuffer.wrap(firstTree.toBytes());
        ImmutableRTree secondTree = new ImmutableRTree(buffer, (BitmapFactory)bf);
        Iterable points = secondTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 10.0f));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchNoSplit() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{10.0f, 10.0f}, 10);
        tree.insert(new float[]{1.0f, 3.0f}, 2);
        tree.insert(new float[]{27.0f, 34.0f}, 20);
        tree.insert(new float[]{106.0f, 19.0f}, 30);
        tree.insert(new float[]{4.0f, 2.0f}, 3);
        tree.insert(new float[]{5.0f, 0.0f}, 4);
        tree.insert(new float[]{4.0f, 72.0f}, 40);
        tree.insert(new float[]{-4.0f, -3.0f}, 5);
        tree.insert(new float[]{119.0f, -78.0f}, 50);
        junit.framework.Assert.assertEquals((int)tree.getRoot().getChildren().size(), (int)10);
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchNoSplitRoaring() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{10.0f, 10.0f}, 10);
        tree.insert(new float[]{1.0f, 3.0f}, 2);
        tree.insert(new float[]{27.0f, 34.0f}, 20);
        tree.insert(new float[]{106.0f, 19.0f}, 30);
        tree.insert(new float[]{4.0f, 2.0f}, 3);
        tree.insert(new float[]{5.0f, 0.0f}, 4);
        tree.insert(new float[]{4.0f, 72.0f}, 40);
        tree.insert(new float[]{-4.0f, -3.0f}, 5);
        tree.insert(new float[]{119.0f, -78.0f}, 50);
        junit.framework.Assert.assertEquals((int)tree.getRoot().getChildren().size(), (int)10);
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplit() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{1.0f, 3.0f}, 2);
        tree.insert(new float[]{4.0f, 2.0f}, 3);
        tree.insert(new float[]{5.0f, 0.0f}, 4);
        tree.insert(new float[]{-4.0f, -3.0f}, 5);
        Random rand = new Random();
        for (int i = 0; i < 95; ++i) {
            tree.insert(new float[]{(float)(rand.nextDouble() * 10.0 + 10.0), (float)(rand.nextDouble() * 10.0 + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplitRoaring() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{1.0f, 3.0f}, 2);
        tree.insert(new float[]{4.0f, 2.0f}, 3);
        tree.insert(new float[]{5.0f, 0.0f}, 4);
        tree.insert(new float[]{-4.0f, -3.0f}, 5);
        Random rand = new Random();
        for (int i = 0; i < 95; ++i) {
            tree.insert(new float[]{(float)(rand.nextDouble() * 10.0 + 10.0), (float)(rand.nextDouble() * 10.0 + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplit2() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 0);
        tree.insert(new float[]{1.0f, 3.0f}, 1);
        tree.insert(new float[]{4.0f, 2.0f}, 2);
        tree.insert(new float[]{7.0f, 3.0f}, 3);
        tree.insert(new float[]{8.0f, 6.0f}, 4);
        Random rand = new Random();
        for (int i = 5; i < 5000; ++i) {
            tree.insert(new float[]{(float)(rand.nextDouble() * 10.0 + 10.0), (float)(rand.nextDouble() * 10.0 + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RectangularBound(new float[]{0.0f, 0.0f}, new float[]{9.0f, 9.0f}));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{0, 1, 2, 3, 4});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplit2Roaring() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 0);
        tree.insert(new float[]{1.0f, 3.0f}, 1);
        tree.insert(new float[]{4.0f, 2.0f}, 2);
        tree.insert(new float[]{7.0f, 3.0f}, 3);
        tree.insert(new float[]{8.0f, 6.0f}, 4);
        Random rand = new Random();
        for (int i = 5; i < 5000; ++i) {
            tree.insert(new float[]{(float)(rand.nextDouble() * 10.0 + 10.0), (float)(rand.nextDouble() * 10.0 + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RectangularBound(new float[]{0.0f, 0.0f}, new float[]{9.0f, 9.0f}));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{0, 1, 2, 3, 4});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplit3() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 0);
        tree.insert(new float[]{1.0f, 3.0f}, 1);
        tree.insert(new float[]{4.0f, 2.0f}, 2);
        tree.insert(new float[]{7.0f, 3.0f}, 3);
        tree.insert(new float[]{8.0f, 6.0f}, 4);
        Random rand = new Random();
        for (int i = 5; i < 5000; ++i) {
            tree.insert(new float[]{(float)((double)(rand.nextFloat() * 10.0f) + 10.0), (float)((double)(rand.nextFloat() * 10.0f) + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 3 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{0, 1, 2});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplit3Roaring() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 0);
        tree.insert(new float[]{1.0f, 3.0f}, 1);
        tree.insert(new float[]{4.0f, 2.0f}, 2);
        tree.insert(new float[]{7.0f, 3.0f}, 3);
        tree.insert(new float[]{8.0f, 6.0f}, 4);
        Random rand = new Random();
        for (int i = 5; i < 5000; ++i) {
            tree.insert(new float[]{(float)((double)(rand.nextFloat() * 10.0f) + 10.0), (float)((double)(rand.nextFloat() * 10.0f) + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 3 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{0, 1, 2});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplit4() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        Random rand = new Random();
        int outPolygon = 0;
        int inPolygon = 0;
        while (inPolygon < 500) {
            double abscissa = rand.nextDouble() * 5.0;
            double ordinate = rand.nextDouble() * 4.0;
            if (abscissa < 1.0 || abscissa > 4.0 || ordinate < 1.0 || ordinate > 3.0 || abscissa < 2.0 && ordinate > 2.0) {
                tree.insert(new float[]{(float)abscissa, (float)ordinate}, outPolygon + 500);
                ++outPolygon;
                continue;
            }
            if (!(abscissa > 1.0 && abscissa < 4.0 && ordinate > 1.0 && ordinate < 2.0) && (!(abscissa > 2.0) || !(abscissa < 4.0) || !(ordinate >= 2.0) || !(ordinate < 3.0))) continue;
            tree.insert(new float[]{(float)abscissa, (float)ordinate}, inPolygon);
            ++inPolygon;
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)PolygonBound.from((float[])new float[]{1.0f, 1.0f, 2.0f, 2.0f, 4.0f, 4.0f}, (float[])new float[]{1.0f, 2.0f, 2.0f, 3.0f, 3.0f, 1.0f}));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() == 500 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet();
        for (int i = 0; i < 500; ++i) {
            expected.add(i);
        }
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplit4Roaring() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        Random rand = new Random();
        int outPolygon = 0;
        int inPolygon = 0;
        while (inPolygon < 500) {
            double abscissa = rand.nextDouble() * 5.0;
            double ordinate = rand.nextDouble() * 4.0;
            if (abscissa < 1.0 || abscissa > 4.0 || ordinate < 1.0 || ordinate > 3.0 || abscissa < 2.0 && ordinate > 2.0) {
                tree.insert(new float[]{(float)abscissa, (float)ordinate}, outPolygon + 500);
                ++outPolygon;
                continue;
            }
            if (!(abscissa > 1.0 && abscissa < 4.0 && ordinate > 1.0 && ordinate < 2.0) && (!(abscissa > 2.0) || !(abscissa < 4.0) || !(ordinate >= 2.0) || !(ordinate < 3.0))) continue;
            tree.insert(new float[]{(float)abscissa, (float)ordinate}, inPolygon);
            ++inPolygon;
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)PolygonBound.from((float[])new float[]{1.0f, 1.0f, 2.0f, 2.0f, 4.0f, 4.0f}, (float[])new float[]{1.0f, 2.0f, 2.0f, 3.0f, 3.0f, 1.0f}));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() == 500 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet();
        for (int i = 0; i < 500; ++i) {
            expected.add(i);
        }
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testEmptyConciseSet() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, bf.makeEmptyMutableBitmap());
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertEquals((int)finalSet.size(), (int)0);
    }

    @Test
    public void testEmptyRoaringBitmap() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, bf.makeEmptyMutableBitmap());
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertEquals((int)finalSet.size(), (int)0);
        junit.framework.Assert.assertTrue((boolean)finalSet.isEmpty());
    }

    @Test
    public void testSearchWithSplitLimitedBound() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{1.0f, 3.0f}, 2);
        tree.insert(new float[]{4.0f, 2.0f}, 3);
        tree.insert(new float[]{5.0f, 0.0f}, 4);
        tree.insert(new float[]{-4.0f, -3.0f}, 5);
        Random rand = new Random();
        for (int i = 0; i < 4995; ++i) {
            tree.insert(new float[]{(float)(rand.nextDouble() * 10.0 + 10.0), (float)(rand.nextDouble() * 10.0 + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f, 2));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplitLimitedBoundRoaring() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{1.0f, 3.0f}, 2);
        tree.insert(new float[]{4.0f, 2.0f}, 3);
        tree.insert(new float[]{5.0f, 0.0f}, 4);
        tree.insert(new float[]{-4.0f, -3.0f}, 5);
        Random rand = new Random();
        for (int i = 0; i < 4995; ++i) {
            tree.insert(new float[]{(float)(rand.nextDouble() * 10.0 + 10.0), (float)(rand.nextDouble() * 10.0 + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f, 2));
        ImmutableBitmap finalSet = bf.union(points);
        junit.framework.Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            junit.framework.Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    public void showBenchmarks() {
        boolean start = true;
        int factor = 10;
        int end = 10000000;
        int radius = 10;
        for (int numPoints = 1; numPoints <= 10000000; numPoints *= 10) {
            try {
                ConciseBitmapFactory bf = new ConciseBitmapFactory();
                RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
                Stopwatch stopwatch = Stopwatch.createStarted();
                Random rand = new Random();
                for (int i = 0; i < numPoints; ++i) {
                    tree.insert(new float[]{(float)(rand.nextDouble() * 100.0), (float)(rand.nextDouble() * 100.0)}, i);
                }
                long stop = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                System.out.printf(Locale.ENGLISH, "[%,d]: insert = %,d ms%n", numPoints, stop);
                stopwatch.reset().start();
                ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
                stop = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                System.out.printf(Locale.ENGLISH, "[%,d]: size = %,d bytes%n", numPoints, searchTree.toBytes().length);
                System.out.printf(Locale.ENGLISH, "[%,d]: buildImmutable = %,d ms%n", numPoints, stop);
                stopwatch.reset().start();
                Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{50.0f, 50.0f}, 10.0f));
                Iterables.size((Iterable)points);
                stop = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                System.out.printf(Locale.ENGLISH, "[%,d]: search = %,dms%n", numPoints, stop);
                stopwatch.reset().start();
                ImmutableBitmap finalSet = bf.union(points);
                stop = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                System.out.printf(Locale.ENGLISH, "[%,d]: union of %,d points in %,d ms%n", numPoints, finalSet.size(), stop);
                continue;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public void showBenchmarksBoundWithLimits() {
        int start = 10000000;
        int factor = 10;
        int end = 10000000;
        for (int numPoints = 10000000; numPoints <= 10000000; numPoints *= 10) {
            try {
                ConciseBitmapFactory bf = new ConciseBitmapFactory();
                RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
                Stopwatch stopwatch = Stopwatch.createStarted();
                Random rand = new Random();
                for (int i = 0; i < numPoints; ++i) {
                    tree.insert(new float[]{(float)(rand.nextDouble() * 100.0), (float)(rand.nextDouble() * 100.0)}, i);
                }
                long stop = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                System.out.printf(Locale.ENGLISH, "[%,d]: insert = %,d ms%n", numPoints, stop);
                stopwatch.reset().start();
                ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
                stop = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                System.out.printf(Locale.ENGLISH, "[%,d]: size = %,d bytes%n", numPoints, searchTree.toBytes().length);
                System.out.printf(Locale.ENGLISH, "[%,d]: buildImmutable = %,d ms%n", numPoints, stop);
                stopwatch.reset().start();
                Iterable points = searchTree.search((Bound)new RectangularBound(new float[]{40.0f, 40.0f}, new float[]{60.0f, 60.0f}, 100));
                Iterables.size((Iterable)points);
                stop = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                System.out.printf(Locale.ENGLISH, "[%,d]: search = %,dms%n", numPoints, stop);
                stopwatch.reset().start();
                ImmutableBitmap finalSet = bf.union(points);
                stop = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                System.out.printf(Locale.ENGLISH, "[%,d]: union of %,d points in %,d ms%n", numPoints, finalSet.size(), stop);
                continue;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    @Test
    public void testToBytes() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        ImmutableRTreeObjectStrategy rTreeObjectStrategy = new ImmutableRTreeObjectStrategy((BitmapFactory)bf);
        RTree rTree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        rTree.insert(new float[]{0.0f, 0.0f}, 1);
        ImmutableRTree immutableRTree = ImmutableRTree.newImmutableFromMutable((RTree)rTree);
        byte[] bytes1 = immutableRTree.toBytes();
        GenericIndexed genericIndexed = GenericIndexed.fromIterable(Arrays.asList(immutableRTree, immutableRTree), (ObjectStrategy)rTreeObjectStrategy);
        ImmutableRTree deserializedTree = (ImmutableRTree)genericIndexed.get(0);
        byte[] bytes2 = deserializedTree.toBytes();
        Assert.assertEquals((Object)Bytes.asList((byte[])bytes1), (Object)Bytes.asList((byte[])bytes2));
    }
}

