/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.collections.BlockingPool;
import org.apache.hive.druid.io.druid.collections.DefaultBlockingPool;
import org.apache.hive.druid.io.druid.collections.ReferenceCountingResourceHolder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BlockingPoolTest {
    private static final ExecutorService SERVICE = Executors.newFixedThreadPool(2);
    private static final DefaultBlockingPool<Integer> POOL = new DefaultBlockingPool(Suppliers.ofInstance((Object)1), 10);
    private static final BlockingPool<Integer> EMPTY_POOL = new DefaultBlockingPool(Suppliers.ofInstance((Object)1), 0);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @AfterClass
    public static void teardown() {
        SERVICE.shutdown();
    }

    @Test
    public void testTakeFromEmptyPool() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Pool was initialized with limit = 0, there are no objects to take.");
        EMPTY_POOL.take(0L);
    }

    @Test
    public void testDrainFromEmptyPool() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Pool was initialized with limit = 0, there are no objects to take.");
        EMPTY_POOL.takeBatch(1, 0L);
    }

    @Test(timeout=1000L)
    public void testTake() {
        ReferenceCountingResourceHolder holder = POOL.take(100L);
        Assert.assertNotNull((Object)holder);
        Assert.assertEquals((long)9L, (long)POOL.getPoolSize());
        holder.close();
        Assert.assertEquals((long)10L, (long)POOL.getPoolSize());
    }

    @Test(timeout=1000L)
    public void testTakeTimeout() {
        ReferenceCountingResourceHolder batchHolder = POOL.takeBatch(10, 100L);
        ReferenceCountingResourceHolder holder = POOL.take(100L);
        Assert.assertNull((Object)holder);
        batchHolder.close();
    }

    @Test(timeout=1000L)
    public void testTakeBatch() {
        ReferenceCountingResourceHolder holder = POOL.takeBatch(6, 100L);
        Assert.assertNotNull((Object)holder);
        Assert.assertEquals((long)6L, (long)((List)holder.get()).size());
        Assert.assertEquals((long)4L, (long)POOL.getPoolSize());
        holder.close();
        Assert.assertEquals((long)10L, (long)POOL.getPoolSize());
    }

    @Test(timeout=1000L)
    public void testWaitAndTakeBatch() throws InterruptedException, ExecutionException {
        ReferenceCountingResourceHolder<List<Integer>> batchHolder = POOL.takeBatch(10, 10L);
        Assert.assertNotNull((Object)batchHolder);
        Assert.assertEquals((long)10L, (long)((List)batchHolder.get()).size());
        Assert.assertEquals((long)0L, (long)POOL.getPoolSize());
        Future<ReferenceCountingResourceHolder<List<Integer>>> future = SERVICE.submit(new Callable<ReferenceCountingResourceHolder<List<Integer>>>(){

            @Override
            public ReferenceCountingResourceHolder<List<Integer>> call() throws Exception {
                return POOL.takeBatch(8, 100L);
            }
        });
        Thread.sleep(20L);
        batchHolder.close();
        batchHolder = future.get();
        Assert.assertNotNull(batchHolder);
        Assert.assertEquals((long)8L, (long)((List)batchHolder.get()).size());
        Assert.assertEquals((long)2L, (long)POOL.getPoolSize());
        batchHolder.close();
        Assert.assertEquals((long)10L, (long)POOL.getPoolSize());
    }

    @Test(timeout=1000L)
    public void testTakeBatchTooManyObjects() {
        ReferenceCountingResourceHolder holder = POOL.takeBatch(100, 100L);
        Assert.assertNull((Object)holder);
    }

    @Test(timeout=1000L)
    public void testConcurrentTake() throws ExecutionException, InterruptedException {
        final int limit1 = POOL.maxSize() / 2;
        final int limit2 = POOL.maxSize() - limit1 + 1;
        Future<List<ReferenceCountingResourceHolder<Integer>>> f1 = SERVICE.submit(new Callable<List<ReferenceCountingResourceHolder<Integer>>>(){

            @Override
            public List<ReferenceCountingResourceHolder<Integer>> call() throws Exception {
                ArrayList result = Lists.newArrayList();
                for (int i = 0; i < limit1; ++i) {
                    result.add(POOL.take(10L));
                }
                return result;
            }
        });
        Future<List<ReferenceCountingResourceHolder<Integer>>> f2 = SERVICE.submit(new Callable<List<ReferenceCountingResourceHolder<Integer>>>(){

            @Override
            public List<ReferenceCountingResourceHolder<Integer>> call() throws Exception {
                ArrayList result = Lists.newArrayList();
                for (int i = 0; i < limit2; ++i) {
                    result.add(POOL.take(10L));
                }
                return result;
            }
        });
        final List<ReferenceCountingResourceHolder<Integer>> r1 = f1.get();
        final List<ReferenceCountingResourceHolder<Integer>> r2 = f2.get();
        Assert.assertEquals((long)0L, (long)POOL.getPoolSize());
        Assert.assertTrue((r1.contains(null) || r2.contains(null) ? 1 : 0) != 0);
        int nonNullCount = 0;
        for (ReferenceCountingResourceHolder<Integer> holder : r1) {
            if (holder == null) continue;
            ++nonNullCount;
        }
        for (ReferenceCountingResourceHolder<Integer> holder : r2) {
            if (holder == null) continue;
            ++nonNullCount;
        }
        Assert.assertEquals((long)POOL.maxSize(), (long)nonNullCount);
        Future<?> future1 = SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                for (ReferenceCountingResourceHolder holder : r1) {
                    if (holder == null) continue;
                    holder.close();
                }
            }
        });
        Future<?> future2 = SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                for (ReferenceCountingResourceHolder holder : r2) {
                    if (holder == null) continue;
                    holder.close();
                }
            }
        });
        future1.get();
        future2.get();
        Assert.assertEquals((long)POOL.maxSize(), (long)POOL.getPoolSize());
    }

    @Test(timeout=1000L)
    public void testConcurrentTakeBatch() throws ExecutionException, InterruptedException {
        final int batch1 = POOL.maxSize() / 2;
        Callable<ReferenceCountingResourceHolder<List<Integer>>> c1 = new Callable<ReferenceCountingResourceHolder<List<Integer>>>(){

            @Override
            public ReferenceCountingResourceHolder<List<Integer>> call() throws Exception {
                return POOL.takeBatch(batch1, 10L);
            }
        };
        final int batch2 = POOL.maxSize() - batch1 + 1;
        Callable<ReferenceCountingResourceHolder<List<Integer>>> c2 = new Callable<ReferenceCountingResourceHolder<List<Integer>>>(){

            @Override
            public ReferenceCountingResourceHolder<List<Integer>> call() throws Exception {
                return POOL.takeBatch(batch2, 10L);
            }
        };
        Future<ReferenceCountingResourceHolder<List<Integer>>> f1 = SERVICE.submit(c1);
        Future<ReferenceCountingResourceHolder<List<Integer>>> f2 = SERVICE.submit(c2);
        ReferenceCountingResourceHolder<List<Integer>> r1 = f1.get();
        ReferenceCountingResourceHolder<List<Integer>> r2 = f2.get();
        if (r1 != null) {
            Assert.assertNull(r2);
            Assert.assertEquals((long)(POOL.maxSize() - batch1), (long)POOL.getPoolSize());
            Assert.assertEquals((long)batch1, (long)((List)r1.get()).size());
            r1.close();
        } else {
            Assert.assertNotNull(r2);
            Assert.assertEquals((long)(POOL.maxSize() - batch2), (long)POOL.getPoolSize());
            Assert.assertEquals((long)batch2, (long)((List)r2.get()).size());
            r2.close();
        }
        Assert.assertEquals((long)POOL.maxSize(), (long)POOL.getPoolSize());
    }

    @Test(timeout=1000L)
    public void testConcurrentBatchClose() throws ExecutionException, InterruptedException {
        final int batch1 = POOL.maxSize() / 2;
        Callable<ReferenceCountingResourceHolder<List<Integer>>> c1 = new Callable<ReferenceCountingResourceHolder<List<Integer>>>(){

            @Override
            public ReferenceCountingResourceHolder<List<Integer>> call() throws Exception {
                return POOL.takeBatch(batch1, 10L);
            }
        };
        final int batch2 = POOL.maxSize() - batch1;
        Callable<ReferenceCountingResourceHolder<List<Integer>>> c2 = new Callable<ReferenceCountingResourceHolder<List<Integer>>>(){

            @Override
            public ReferenceCountingResourceHolder<List<Integer>> call() throws Exception {
                return POOL.takeBatch(batch2, 10L);
            }
        };
        Future<ReferenceCountingResourceHolder<List<Integer>>> f1 = SERVICE.submit(c1);
        Future<ReferenceCountingResourceHolder<List<Integer>>> f2 = SERVICE.submit(c2);
        final ReferenceCountingResourceHolder<List<Integer>> r1 = f1.get();
        final ReferenceCountingResourceHolder<List<Integer>> r2 = f2.get();
        Assert.assertNotNull(r1);
        Assert.assertNotNull(r2);
        Assert.assertEquals((long)batch1, (long)((List)r1.get()).size());
        Assert.assertEquals((long)batch2, (long)((List)r2.get()).size());
        Assert.assertEquals((long)0L, (long)POOL.getPoolSize());
        Future<?> future1 = SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                r1.close();
            }
        });
        Future<?> future2 = SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                r2.close();
            }
        });
        future1.get();
        future2.get();
        Assert.assertEquals((long)POOL.maxSize(), (long)POOL.getPoolSize());
    }

    @Test(timeout=1000L)
    public void testConcurrentTakeBatchClose() throws ExecutionException, InterruptedException {
        final ReferenceCountingResourceHolder r1 = POOL.takeBatch(1, 10L);
        Callable<ReferenceCountingResourceHolder<List<Integer>>> c2 = new Callable<ReferenceCountingResourceHolder<List<Integer>>>(){

            @Override
            public ReferenceCountingResourceHolder<List<Integer>> call() throws Exception {
                return POOL.takeBatch(10, 100L);
            }
        };
        Future<ReferenceCountingResourceHolder<List<Integer>>> f2 = SERVICE.submit(c2);
        Future<?> f1 = SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                r1.close();
            }
        });
        ReferenceCountingResourceHolder<List<Integer>> r2 = f2.get();
        f1.get();
        Assert.assertNotNull(r2);
        Assert.assertEquals((long)10L, (long)((List)r2.get()).size());
        Assert.assertEquals((long)0L, (long)POOL.getPoolSize());
        r2.close();
        Assert.assertEquals((long)POOL.maxSize(), (long)POOL.getPoolSize());
    }
}

