/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.parsers;

import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.metamx.common.parsers.ParserUtils;
import org.apache.hive.druid.com.metamx.common.parsers.TimestampParser;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class TimestampParserTest {
    @Test
    public void testStripQuotes() throws Exception {
        Assert.assertEquals((Object)"hello world", (Object)ParserUtils.stripQuotes((String)"\"hello world\""));
        Assert.assertEquals((Object)"hello world", (Object)ParserUtils.stripQuotes((String)"    \"    hello world   \"    "));
    }

    @Test
    public void testAuto() throws Exception {
        Function parser = TimestampParser.createObjectTimestampParser((String)"auto");
        Assert.assertEquals((Object)new DateTime((Object)"2009-02-13T23:31:30Z"), (Object)parser.apply((Object)"1234567890000"));
        Assert.assertEquals((Object)new DateTime((Object)"2009-02-13T23:31:30Z"), (Object)parser.apply((Object)"2009-02-13T23:31:30Z"));
        Assert.assertEquals((Object)new DateTime((Object)"2009-02-13T23:31:30Z"), (Object)parser.apply((Object)1234567890000L));
    }

    @Test
    public void testRuby() throws Exception {
        Function parser = TimestampParser.createObjectTimestampParser((String)"ruby");
        Assert.assertEquals((Object)new DateTime((Object)"2013-01-16T15:41:47+01:00"), (Object)parser.apply((Object)"1358347307.435447"));
        Assert.assertEquals((Object)new DateTime((Object)"2013-01-16T15:41:47+01:00"), (Object)parser.apply((Object)1.358347307435447E9));
    }

    @Test
    public void testNano() throws Exception {
        String timeNsStr = "1427504794977098494";
        DateTime expectedDt = new DateTime((Object)"2015-3-28T01:06:34.977Z");
        Function parser = TimestampParser.createObjectTimestampParser((String)"nano");
        Assert.assertEquals((String)"Incorrect truncation of nanoseconds -> milliseconds", (Object)expectedDt, (Object)parser.apply((Object)timeNsStr));
        expectedDt = new DateTime((Object)"1970-1-1T00:00:00.000Z");
        Assert.assertEquals((Object)expectedDt, (Object)parser.apply((Object)"999999"));
        Assert.assertEquals((Object)expectedDt, (Object)parser.apply((Object)"0"));
        Assert.assertEquals((Object)expectedDt, (Object)parser.apply((Object)"0000"));
        Assert.assertEquals((Object)expectedDt, (Object)parser.apply((Object)999999L));
    }
}

