/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class CombinatoricsUtilsTest {
    private static final List<Map<Integer, Long>> binomialCache = new ArrayList<Map<Integer, Long>>();

    @Test
    public void test0Choose0() {
        Assert.assertEquals((double)CombinatoricsUtils.binomialCoefficientDouble((int)0, (int)0), (double)1.0, (double)0.0);
        Assert.assertEquals((double)CombinatoricsUtils.binomialCoefficientLog((int)0, (int)0), (double)0.0, (double)0.0);
        Assert.assertEquals((long)CombinatoricsUtils.binomialCoefficient((int)0, (int)0), (long)1L);
    }

    @Test
    public void testBinomialCoefficient() {
        int i;
        long[] bcoef5 = new long[]{1L, 5L, 10L, 10L, 5L, 1L};
        long[] bcoef6 = new long[]{1L, 6L, 15L, 20L, 15L, 6L, 1L};
        for (i = 0; i < 6; ++i) {
            Assert.assertEquals((String)("5 choose " + i), (long)bcoef5[i], (long)CombinatoricsUtils.binomialCoefficient((int)5, (int)i));
        }
        for (i = 0; i < 7; ++i) {
            Assert.assertEquals((String)("6 choose " + i), (long)bcoef6[i], (long)CombinatoricsUtils.binomialCoefficient((int)6, (int)i));
        }
        for (int n = 1; n < 10; ++n) {
            for (int k = 0; k <= n; ++k) {
                Assert.assertEquals((String)(n + " choose " + k), (long)this.binomialCoefficient(n, k), (long)CombinatoricsUtils.binomialCoefficient((int)n, (int)k));
                Assert.assertEquals((String)(n + " choose " + k), (double)this.binomialCoefficient(n, k), (double)CombinatoricsUtils.binomialCoefficientDouble((int)n, (int)k), (double)Double.MIN_VALUE);
                Assert.assertEquals((String)(n + " choose " + k), (double)FastMath.log((double)this.binomialCoefficient(n, k)), (double)CombinatoricsUtils.binomialCoefficientLog((int)n, (int)k), (double)1.0E-11);
            }
        }
        int[] n = new int[]{34, 66, 100, 1500, 1500};
        int[] k = new int[]{17, 33, 10, 1496, 4};
        for (int i2 = 0; i2 < n.length; ++i2) {
            long expected = this.binomialCoefficient(n[i2], k[i2]);
            Assert.assertEquals((String)(n[i2] + " choose " + k[i2]), (long)expected, (long)CombinatoricsUtils.binomialCoefficient((int)n[i2], (int)k[i2]));
            Assert.assertEquals((String)(n[i2] + " choose " + k[i2]), (double)expected, (double)CombinatoricsUtils.binomialCoefficientDouble((int)n[i2], (int)k[i2]), (double)0.0);
            Assert.assertEquals((String)("log(" + n[i2] + " choose " + k[i2] + ")"), (double)FastMath.log((double)expected), (double)CombinatoricsUtils.binomialCoefficientLog((int)n[i2], (int)k[i2]), (double)0.0);
        }
    }

    @Test
    public void testBinomialCoefficientFail() {
        try {
            CombinatoricsUtils.binomialCoefficient((int)4, (int)5);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            CombinatoricsUtils.binomialCoefficientDouble((int)4, (int)5);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            CombinatoricsUtils.binomialCoefficientLog((int)4, (int)5);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            CombinatoricsUtils.binomialCoefficient((int)-1, (int)-2);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            CombinatoricsUtils.binomialCoefficientDouble((int)-1, (int)-2);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            CombinatoricsUtils.binomialCoefficientLog((int)-1, (int)-2);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            CombinatoricsUtils.binomialCoefficient((int)67, (int)30);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            CombinatoricsUtils.binomialCoefficient((int)67, (int)34);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        double x = CombinatoricsUtils.binomialCoefficientDouble((int)1030, (int)515);
        Assert.assertTrue((String)"expecting infinite binomial coefficient", (boolean)Double.isInfinite(x));
    }

    @Test
    public void testBinomialCoefficientLarge() throws Exception {
        for (int n = 0; n <= 200; ++n) {
            for (int k = 0; k <= n; ++k) {
                long ourResult = -1L;
                long exactResult2 = -1L;
                boolean shouldThrow = false;
                boolean didThrow = false;
                try {
                    ourResult = CombinatoricsUtils.binomialCoefficient((int)n, (int)k);
                }
                catch (MathArithmeticException ex) {
                    didThrow = true;
                }
                try {
                    exactResult2 = this.binomialCoefficient(n, k);
                }
                catch (MathArithmeticException ex) {
                    shouldThrow = true;
                }
                Assert.assertEquals((String)(n + " choose " + k), (long)exactResult2, (long)ourResult);
                Assert.assertEquals((String)(n + " choose " + k), (Object)shouldThrow, (Object)didThrow);
                Assert.assertTrue((String)(n + " choose " + k), (n > 66 || !didThrow ? 1 : 0) != 0);
                if (shouldThrow || exactResult2 <= 1L) continue;
                Assert.assertEquals((String)(n + " choose " + k), (double)1.0, (double)(CombinatoricsUtils.binomialCoefficientDouble((int)n, (int)k) / (double)exactResult2), (double)1.0E-10);
                Assert.assertEquals((String)(n + " choose " + k), (double)1.0, (double)(CombinatoricsUtils.binomialCoefficientLog((int)n, (int)k) / FastMath.log((double)exactResult2)), (double)1.0E-10);
            }
        }
        long ourResult = CombinatoricsUtils.binomialCoefficient((int)300, (int)3);
        long exactResult = this.binomialCoefficient(300, 3);
        Assert.assertEquals((long)exactResult, (long)ourResult);
        ourResult = CombinatoricsUtils.binomialCoefficient((int)700, (int)697);
        exactResult = this.binomialCoefficient(700, 697);
        Assert.assertEquals((long)exactResult, (long)ourResult);
        try {
            CombinatoricsUtils.binomialCoefficient((int)700, (int)300);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException exactResult2) {
            // empty catch block
        }
        int n = 10000;
        ourResult = CombinatoricsUtils.binomialCoefficient((int)n, (int)3);
        exactResult = this.binomialCoefficient(n, 3);
        Assert.assertEquals((long)exactResult, (long)ourResult);
        Assert.assertEquals((double)1.0, (double)(CombinatoricsUtils.binomialCoefficientDouble((int)n, (int)3) / (double)exactResult), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)(CombinatoricsUtils.binomialCoefficientLog((int)n, (int)3) / FastMath.log((double)exactResult)), (double)1.0E-10);
    }

    @Test
    public void testFactorial() {
        for (int i = 1; i < 21; ++i) {
            Assert.assertEquals((String)(i + "! "), (long)this.factorial(i), (long)CombinatoricsUtils.factorial((int)i));
            Assert.assertEquals((String)(i + "! "), (double)this.factorial(i), (double)CombinatoricsUtils.factorialDouble((int)i), (double)Double.MIN_VALUE);
            Assert.assertEquals((String)(i + "! "), (double)FastMath.log((double)this.factorial(i)), (double)CombinatoricsUtils.factorialLog((int)i), (double)1.0E-11);
        }
        Assert.assertEquals((String)"0", (long)1L, (long)CombinatoricsUtils.factorial((int)0));
        Assert.assertEquals((String)"0", (double)1.0, (double)CombinatoricsUtils.factorialDouble((int)0), (double)1.0E-14);
        Assert.assertEquals((String)"0", (double)0.0, (double)CombinatoricsUtils.factorialLog((int)0), (double)1.0E-14);
    }

    @Test
    public void testFactorialFail() {
        try {
            CombinatoricsUtils.factorial((int)-1);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            CombinatoricsUtils.factorialDouble((int)-1);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            CombinatoricsUtils.factorialLog((int)-1);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            CombinatoricsUtils.factorial((int)21);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        Assert.assertTrue((String)"expecting infinite factorial value", (boolean)Double.isInfinite(CombinatoricsUtils.factorialDouble((int)171)));
    }

    @Test
    public void testStirlingS2() {
        Assert.assertEquals((long)1L, (long)CombinatoricsUtils.stirlingS2((int)0, (int)0));
        for (int n = 1; n < 30; ++n) {
            Assert.assertEquals((long)0L, (long)CombinatoricsUtils.stirlingS2((int)n, (int)0));
            Assert.assertEquals((long)1L, (long)CombinatoricsUtils.stirlingS2((int)n, (int)1));
            if (n > 2) {
                Assert.assertEquals((long)((1L << n - 1) - 1L), (long)CombinatoricsUtils.stirlingS2((int)n, (int)2));
                Assert.assertEquals((long)CombinatoricsUtils.binomialCoefficient((int)n, (int)2), (long)CombinatoricsUtils.stirlingS2((int)n, (int)(n - 1)));
            }
            Assert.assertEquals((long)1L, (long)CombinatoricsUtils.stirlingS2((int)n, (int)n));
        }
        Assert.assertEquals((long)0x1FFFFFFFL, (long)CombinatoricsUtils.stirlingS2((int)30, (int)2));
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFFL, (long)CombinatoricsUtils.stirlingS2((int)60, (int)2));
        Assert.assertEquals((long)25L, (long)CombinatoricsUtils.stirlingS2((int)5, (int)3));
        Assert.assertEquals((long)90L, (long)CombinatoricsUtils.stirlingS2((int)6, (int)3));
        Assert.assertEquals((long)65L, (long)CombinatoricsUtils.stirlingS2((int)6, (int)4));
        Assert.assertEquals((long)301L, (long)CombinatoricsUtils.stirlingS2((int)7, (int)3));
        Assert.assertEquals((long)350L, (long)CombinatoricsUtils.stirlingS2((int)7, (int)4));
        Assert.assertEquals((long)140L, (long)CombinatoricsUtils.stirlingS2((int)7, (int)5));
        Assert.assertEquals((long)966L, (long)CombinatoricsUtils.stirlingS2((int)8, (int)3));
        Assert.assertEquals((long)1701L, (long)CombinatoricsUtils.stirlingS2((int)8, (int)4));
        Assert.assertEquals((long)1050L, (long)CombinatoricsUtils.stirlingS2((int)8, (int)5));
        Assert.assertEquals((long)266L, (long)CombinatoricsUtils.stirlingS2((int)8, (int)6));
        Assert.assertEquals((long)3025L, (long)CombinatoricsUtils.stirlingS2((int)9, (int)3));
        Assert.assertEquals((long)7770L, (long)CombinatoricsUtils.stirlingS2((int)9, (int)4));
        Assert.assertEquals((long)6951L, (long)CombinatoricsUtils.stirlingS2((int)9, (int)5));
        Assert.assertEquals((long)2646L, (long)CombinatoricsUtils.stirlingS2((int)9, (int)6));
        Assert.assertEquals((long)462L, (long)CombinatoricsUtils.stirlingS2((int)9, (int)7));
        Assert.assertEquals((long)9330L, (long)CombinatoricsUtils.stirlingS2((int)10, (int)3));
        Assert.assertEquals((long)34105L, (long)CombinatoricsUtils.stirlingS2((int)10, (int)4));
        Assert.assertEquals((long)42525L, (long)CombinatoricsUtils.stirlingS2((int)10, (int)5));
        Assert.assertEquals((long)22827L, (long)CombinatoricsUtils.stirlingS2((int)10, (int)6));
        Assert.assertEquals((long)5880L, (long)CombinatoricsUtils.stirlingS2((int)10, (int)7));
        Assert.assertEquals((long)750L, (long)CombinatoricsUtils.stirlingS2((int)10, (int)8));
    }

    @Test(expected=NotPositiveException.class)
    public void testStirlingS2NegativeN() {
        CombinatoricsUtils.stirlingS2((int)3, (int)-1);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testStirlingS2LargeK() {
        CombinatoricsUtils.stirlingS2((int)3, (int)4);
    }

    @Test(expected=MathArithmeticException.class)
    public void testStirlingS2Overflow() {
        CombinatoricsUtils.stirlingS2((int)26, (int)9);
    }

    @Test(expected=NotPositiveException.class)
    public void testCheckBinomial1() {
        CombinatoricsUtils.checkBinomial((int)-1, (int)-2);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testCheckBinomial2() {
        CombinatoricsUtils.checkBinomial((int)4, (int)5);
    }

    @Test
    public void testCheckBinomial3() {
        CombinatoricsUtils.checkBinomial((int)5, (int)4);
    }

    private long binomialCoefficient(int n, int k) throws MathArithmeticException {
        Long cachedResult;
        if (binomialCache.size() > n && (cachedResult = binomialCache.get(n).get(k)) != null) {
            return cachedResult;
        }
        long result = -1L;
        if (n == k || k == 0) {
            result = 1L;
        } else if (k == 1 || k == n - 1) {
            result = n;
        } else {
            if (k < n - 100) {
                this.binomialCoefficient(n - 100, k);
            }
            if (k > 100) {
                this.binomialCoefficient(n - 100, k - 100);
            }
            result = ArithmeticUtils.addAndCheck((long)this.binomialCoefficient(n - 1, k - 1), (long)this.binomialCoefficient(n - 1, k));
        }
        if (result == -1L) {
            throw new MathArithmeticException();
        }
        for (int i = binomialCache.size(); i < n + 1; ++i) {
            binomialCache.add(new HashMap());
        }
        binomialCache.get(n).put(k, result);
        return result;
    }

    private long factorial(int n) {
        long result = 1L;
        for (int i = 2; i <= n; ++i) {
            result *= (long)i;
        }
        return result;
    }
}

