/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.Assert;
import org.junit.Test;

public class IOUtilsTest {
    @Test
    public void skipUsingSkip() throws Exception {
        this.skip(toWrap -> toWrap);
    }

    @Test
    public void skipUsingRead() throws Exception {
        this.skip(toWrap -> new FilterInputStream(toWrap){

            @Override
            public long skip(long s) {
                return 0L;
            }
        });
    }

    @Test
    public void skipUsingSkipAndRead() throws Exception {
        this.skip(toWrap -> new FilterInputStream(toWrap){
            boolean skipped;

            @Override
            public long skip(long s) throws IOException {
                if (!this.skipped) {
                    toWrap.skip(5L);
                    this.skipped = true;
                    return 5L;
                }
                return 0L;
            }
        });
    }

    @Test
    public void readFullyOnChannelReadsFully() throws IOException {
        ByteBuffer b = ByteBuffer.allocate(20);
        byte[] source = new byte[20];
        for (int i = 0; i < 20; i = (int)((byte)(i + 1))) {
            source[i] = i;
        }
        IOUtilsTest.readFully(source, b);
        Assert.assertArrayEquals((byte[])source, (byte[])b.array());
    }

    @Test(expected=EOFException.class)
    public void readFullyOnChannelThrowsEof() throws IOException {
        ByteBuffer b = ByteBuffer.allocate(21);
        byte[] source = new byte[20];
        for (int i = 0; i < 20; i = (int)((byte)(i + 1))) {
            source[i] = i;
        }
        IOUtilsTest.readFully(source, b);
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyThrowsOnZeroBufferSize() throws IOException {
        IOUtils.copy((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY), (OutputStream)new ByteArrayOutputStream(), (int)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyRangeThrowsOnZeroBufferSize() throws IOException {
        IOUtils.copyRange((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY), (long)5L, (OutputStream)new ByteArrayOutputStream(), (int)0);
    }

    @Test
    public void copyRangeDoesntCopyMoreThanAskedFor() throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Assert.assertEquals((long)3L, (long)IOUtils.copyRange((InputStream)in, (long)3L, (OutputStream)out));
            out.close();
            Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])out.toByteArray());
        }
    }

    @Test
    public void copyRangeStopsIfThereIsNothingToCopyAnymore() throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Assert.assertEquals((long)5L, (long)IOUtils.copyRange((InputStream)in, (long)10L, (OutputStream)out));
            out.close();
            Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])out.toByteArray());
        }
    }

    @Test
    public void readRangeFromStreamDoesntReadMoreThanAskedFor() throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});){
            byte[] read = IOUtils.readRange((InputStream)in, (int)3);
            Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])read);
            Assert.assertEquals((long)4L, (long)in.read());
        }
    }

    @Test
    public void readRangeFromStreamStopsIfThereIsNothingToReadAnymore() throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});){
            byte[] read = IOUtils.readRange((InputStream)in, (int)10);
            Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])read);
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }

    @Test
    public void readRangeFromChannelDoesntReadMoreThanAskedFor() throws IOException {
        try (SeekableInMemoryByteChannel in = new SeekableInMemoryByteChannel(new byte[]{1, 2, 3, 4, 5});){
            byte[] read = IOUtils.readRange((ReadableByteChannel)in, (int)3);
            Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])read);
            ByteBuffer b = ByteBuffer.allocate(1);
            Assert.assertEquals((long)1L, (long)in.read(b));
            Assert.assertArrayEquals((byte[])new byte[]{4}, (byte[])b.array());
        }
    }

    @Test
    public void readRangeFromChannelStopsIfThereIsNothingToReadAnymore() throws IOException {
        try (SeekableInMemoryByteChannel in = new SeekableInMemoryByteChannel(new byte[]{1, 2, 3, 4, 5});){
            byte[] read = IOUtils.readRange((ReadableByteChannel)in, (int)10);
            Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])read);
            ByteBuffer b = ByteBuffer.allocate(1);
            Assert.assertEquals((long)-1L, (long)in.read(b));
        }
    }

    private static void readFully(byte[] source, ByteBuffer b) throws IOException {
        IOUtils.readFully((ReadableByteChannel)new SeekableInMemoryByteChannel(source), (ByteBuffer)b);
    }

    private void skip(StreamWrapper wrapper) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        InputStream sut = wrapper.wrap(in);
        Assert.assertEquals((long)10L, (long)IOUtils.skip((InputStream)sut, (long)10L));
        Assert.assertEquals((long)11L, (long)sut.read());
    }

    private static interface StreamWrapper {
        public InputStream wrap(InputStream var1);
    }
}

