/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.compress.harmony.unpack200.CpBands;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.compress.harmony.unpack200.SegmentConstantPool;
import org.apache.commons.compress.harmony.unpack200.bytecode.ByteCode;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPFieldRef;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPMethodRef;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPString;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.harmony.unpack200.bytecode.CodeAttribute;
import org.apache.commons.compress.harmony.unpack200.bytecode.LocalVariableTableAttribute;
import org.apache.commons.compress.harmony.unpack200.bytecode.OperandManager;

public class CodeAttributeTest
extends TestCase {
    Segment segment = new MockSegment();
    CpBands cpBands = new MockCpBands(this.segment);
    public byte[] mixedByteArray = new byte[]{-47, -46, 1, -45, -44};
    public byte[] singleByteArray = new byte[]{42, 1, 18, -49};

    public void testLength() {
        MockOperandManager operandManager = new MockOperandManager();
        operandManager.setSegment(this.segment);
        operandManager.setCurrentClass("java/lang/Foo");
        MockCodeAttribute attribute = new MockCodeAttribute(3, 2, this.mixedByteArray, this.segment, operandManager, new ArrayList());
        CodeAttributeTest.assertEquals((int)29, (int)attribute.getLength());
        attribute.attributes.add(new LocalVariableTableAttribute(0, null, null, null, null, null));
        CodeAttributeTest.assertEquals((int)37, (int)attribute.getLength());
    }

    public void testMixedByteCodes() {
        MockOperandManager operandManager = new MockOperandManager();
        operandManager.setSegment(this.segment);
        operandManager.setCurrentClass("java/lang/Foo");
        CodeAttribute attribute = new CodeAttribute(3, 2, this.mixedByteArray, this.segment, (OperandManager)operandManager, new ArrayList());
        CodeAttributeTest.assertEquals((int)2, (int)attribute.maxLocals);
        CodeAttributeTest.assertEquals((int)3, (int)attribute.maxStack);
        CodeAttributeTest.assertEquals((String)"aload_0_putfield_this", (String)((ByteCode)attribute.byteCodes.get(4)).toString());
        int[] expectedLabels = new int[]{0, 1, 4, 5, 8, 9, 10, 13, 14};
        for (int index = 0; index < expectedLabels.length; ++index) {
            CodeAttributeTest.assertEquals((int)expectedLabels[index], (int)((Integer)attribute.byteCodeOffsets.get(index)));
        }
    }

    public void testSingleByteCodes() {
        MockOperandManager operandManager = new MockOperandManager();
        operandManager.setSegment(this.segment);
        operandManager.setCurrentClass("java/lang/Foo");
        CodeAttribute attribute = new CodeAttribute(4, 3, this.singleByteArray, this.segment, (OperandManager)operandManager, new ArrayList());
        CodeAttributeTest.assertEquals((int)3, (int)attribute.maxLocals);
        CodeAttributeTest.assertEquals((int)4, (int)attribute.maxStack);
        CodeAttributeTest.assertEquals((String)"invokespecial_this", (String)((ByteCode)attribute.byteCodes.get(3)).toString());
        int[] expectedLabels = new int[]{0, 1, 2, 4};
        for (int index = 0; index < expectedLabels.length; ++index) {
            CodeAttributeTest.assertEquals((int)expectedLabels[index], (int)((Integer)attribute.byteCodeOffsets.get(index)));
        }
    }

    public class MockSegmentConstantPool
    extends SegmentConstantPool {
        public MockSegmentConstantPool(CpBands bands) {
            super(bands);
        }

        protected int matchSpecificPoolEntryIndex(String[] nameArray, String compareString, int desiredIndex) {
            return 1;
        }
    }

    public class MockSegment
    extends Segment {
        public SegmentConstantPool getConstantPool() {
            return new MockSegmentConstantPool(CodeAttributeTest.this.cpBands);
        }
    }

    public class MockOperandManager
    extends OperandManager {
        public MockOperandManager() {
            super(new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[]{0, 1, 2, 3, 4}, new int[0], new int[0], new int[0], new int[0], new int[]{0, 0, 0, 0, 0, 0}, new int[0], new int[]{0}, new int[0], new int[0], null);
        }
    }

    public class MockCpBands
    extends CpBands {
        public MockCpBands(Segment segment) {
            super(segment);
        }

        public CPFieldRef cpFieldValue(int index) {
            return null;
        }

        public CPString cpStringValue(int index) {
            return new CPString(new CPUTF8("Hello"), -1);
        }

        public CPMethodRef cpMethodValue(int index) {
            return null;
        }
    }

    public class MockCodeAttribute
    extends CodeAttribute {
        public MockCodeAttribute(int maxStack, int maxLocals, byte[] codePacked, Segment segment, OperandManager operandManager, List exceptionTable) {
            super(maxStack, maxLocals, codePacked, segment, operandManager, exceptionTable);
        }

        public int getLength() {
            return super.getLength();
        }
    }
}

