/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class ZTestCase
extends AbstractTestCase {
    @Test
    public void testZUnarchive() throws Exception {
        this.testUnarchive(ZCompressorInputStream::new);
    }

    @Test
    public void testZUnarchiveViaFactory() throws Exception {
        this.testUnarchive(is -> new CompressorStreamFactory().createCompressorInputStream("z", is));
    }

    @Test
    public void testZUnarchiveViaAutoDetection() throws Exception {
        this.testUnarchive(is -> new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(is)));
    }

    @Test
    public void testMatches() throws Exception {
        Assert.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{1, 2, 3, 4}, (int)4));
        Assert.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, 2, 3, 4}, (int)4));
        Assert.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{1, -99, 3, 4}, (int)4));
        Assert.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, -99, 3, 4}, (int)3));
        Assert.assertTrue((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, -99, 3, 4}, (int)4));
    }

    private void testUnarchive(AbstractTestCase.StreamWrapper<CompressorInputStream> wrapper) throws Exception {
        File input = ZTestCase.getFile("bla.tar.Z");
        File output = new File(this.dir, "bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = wrapper.wrap(is);
             OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }
}

