/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.zip.ZipException;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipSplitReadOnlySeekableByteChannel;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ZipArchiveInputStreamTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void winzipBackSlashWorkaround() throws Exception {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream(Files.newInputStream(AbstractTestCase.getFile("test-winzip.zip").toPath(), new OpenOption[0]));){
            ZipArchiveEntry zae = in.getNextZipEntry();
            zae = in.getNextZipEntry();
            zae = in.getNextZipEntry();
            Assert.assertEquals((Object)"\u00e4/", (Object)zae.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void properUseOfInflater() throws Exception {
        ZipFile zf = null;
        ZipArchiveInputStream in = null;
        try {
            ZipArchiveEntry innerEntry;
            zf = new ZipFile(AbstractTestCase.getFile("COMPRESS-189.zip"));
            ZipArchiveEntry zae = zf.getEntry("USD0558682-20080101.ZIP");
            in = new ZipArchiveInputStream((InputStream)new BufferedInputStream(zf.getInputStream(zae)));
            while ((innerEntry = in.getNextZipEntry()) != null) {
                if (!innerEntry.getName().endsWith("XML")) continue;
                Assert.assertTrue((0 < in.read() ? 1 : 0) != 0);
            }
        }
        finally {
            if (zf != null) {
                zf.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    public void shouldConsumeArchiveCompletely() throws Exception {
        InputStream is = ZipArchiveInputStreamTest.class.getResourceAsStream("/archive_with_trailer.zip");
        ZipArchiveInputStream zip = new ZipArchiveInputStream(is);
        while (zip.getNextZipEntry() != null) {
        }
        byte[] expected = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10};
        byte[] actual = new byte[expected.length];
        is.read(actual);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        zip.close();
    }

    @Test
    public void shouldReadNestedZip() throws IOException {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream(Files.newInputStream(AbstractTestCase.getFile("COMPRESS-219.zip").toPath(), new OpenOption[0]));){
            this.extractZipInputStream(in);
        }
    }

    private void extractZipInputStream(ZipArchiveInputStream in) throws IOException {
        ZipArchiveEntry zae = in.getNextZipEntry();
        while (zae != null) {
            if (zae.getName().endsWith(".zip")) {
                this.extractZipInputStream(new ZipArchiveInputStream((InputStream)in));
            }
            zae = in.getNextZipEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnshrinkEntry() throws Exception {
        ZipArchiveInputStream in = new ZipArchiveInputStream(Files.newInputStream(AbstractTestCase.getFile("SHRUNK.ZIP").toPath(), new OpenOption[0]));
        ZipArchiveEntry entry = in.getNextZipEntry();
        Assert.assertEquals((String)"method", (long)ZipMethod.UNSHRINKING.getCode(), (long)entry.getMethod());
        Assert.assertTrue((boolean)in.canReadEntryData((ArchiveEntry)entry));
        try (InputStream original = Files.newInputStream(AbstractTestCase.getFile("test1.xml").toPath(), new OpenOption[0]);){
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)in));
        }
        entry = in.getNextZipEntry();
        Assert.assertEquals((String)"method", (long)ZipMethod.UNSHRINKING.getCode(), (long)entry.getMethod());
        Assert.assertTrue((boolean)in.canReadEntryData((ArchiveEntry)entry));
        original = Files.newInputStream(AbstractTestCase.getFile("test2.xml").toPath(), new OpenOption[0]);
        try {
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)in));
        }
        finally {
            original.close();
        }
    }

    @Test
    public void testReadingOfFirstStoredEntry() throws Exception {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream(Files.newInputStream(AbstractTestCase.getFile("COMPRESS-264.zip").toPath(), new OpenOption[0]));){
            ZipArchiveEntry ze = in.getNextZipEntry();
            Assert.assertEquals((long)5L, (long)ze.getSize());
            Assert.assertArrayEquals((byte[])new byte[]{100, 97, 116, 97, 10}, (byte[])IOUtils.toByteArray((InputStream)in));
        }
    }

    @Test
    public void testMessageWithCorruptFileName() throws Exception {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream(Files.newInputStream(AbstractTestCase.getFile("COMPRESS-351.zip").toPath(), new OpenOption[0]));){
            ZipArchiveEntry ze = in.getNextZipEntry();
            while (ze != null) {
                ze = in.getNextZipEntry();
            }
            Assert.fail((String)"expected EOFException");
        }
        catch (EOFException ex) {
            String m = ex.getMessage();
            Assert.assertTrue((boolean)m.startsWith("Truncated ZIP entry: ?2016"));
        }
    }

    @Test
    public void testUnzipBZip2CompressedEntry() throws Exception {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream(Files.newInputStream(AbstractTestCase.getFile("bzip2-zip.zip").toPath(), new OpenOption[0]));){
            ZipArchiveEntry ze = in.getNextZipEntry();
            Assert.assertEquals((long)42L, (long)ze.getSize());
            byte[] expected = new byte[42];
            Arrays.fill(expected, (byte)97);
            Assert.assertArrayEquals((byte[])expected, (byte[])IOUtils.toByteArray((InputStream)in));
        }
    }

    @Test
    public void readDeflate64CompressedStream() throws Exception {
        File input = AbstractTestCase.getFile("COMPRESS-380/COMPRESS-380-input");
        File archive = AbstractTestCase.getFile("COMPRESS-380/COMPRESS-380.zip");
        try (InputStream in = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZipArchiveInputStream zin = new ZipArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            byte[] orig = IOUtils.toByteArray((InputStream)in);
            ZipArchiveEntry e = zin.getNextZipEntry();
            byte[] fromZip = IOUtils.toByteArray((InputStream)zin);
            Assert.assertArrayEquals((byte[])orig, (byte[])fromZip);
        }
    }

    @Test
    public void readDeflate64CompressedStreamWithDataDescriptor() throws Exception {
        File archive = AbstractTestCase.getFile("COMPRESS-380/COMPRESS-380-dd.zip");
        try (ZipArchiveInputStream zin = new ZipArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            ZipArchiveEntry e = zin.getNextZipEntry();
            Assert.assertEquals((long)-1L, (long)e.getSize());
            Assert.assertEquals((long)ZipMethod.ENHANCED_DEFLATED.getCode(), (long)e.getMethod());
            byte[] fromZip = IOUtils.toByteArray((InputStream)zin);
            byte[] expected = new byte[]{77, 97, 110, 105, 102, 101, 115, 116, 45, 86, 101, 114, 115, 105, 111, 110, 58, 32, 49, 46, 48, 13, 10, 13, 10};
            Assert.assertArrayEquals((byte[])expected, (byte[])fromZip);
            zin.getNextZipEntry();
            Assert.assertEquals((long)25L, (long)e.getSize());
        }
    }

    @Test
    public void testWithBytesAfterData() throws Exception {
        int expectedNumEntries = 2;
        InputStream is = ZipArchiveInputStreamTest.class.getResourceAsStream("/archive_with_bytes_after_data.zip");
        try (ZipArchiveInputStream zip = new ZipArchiveInputStream(is);){
            int actualNumEntries = 0;
            ZipArchiveEntry zae = zip.getNextZipEntry();
            while (zae != null) {
                ++actualNumEntries;
                ZipArchiveInputStreamTest.readEntry(zip, zae);
                zae = zip.getNextZipEntry();
            }
            Assert.assertEquals((long)2L, (long)actualNumEntries);
        }
    }

    @Test
    public void testThrowOnInvalidEntry() throws Exception {
        InputStream is = ZipArchiveInputStreamTest.class.getResourceAsStream("/invalid-zip.zip");
        try (ZipArchiveInputStream zip = new ZipArchiveInputStream(is);){
            zip.getNextZipEntry();
            Assert.fail((String)"IOException expected");
        }
        catch (ZipException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("Unexpected record signature"));
        }
    }

    @Test
    public void testOffsets() throws Exception {
        try (InputStream archiveStream = ZipArchiveInputStream.class.getResourceAsStream("/mixed.zip");
             ZipArchiveInputStream zipStream = new ZipArchiveInputStream(archiveStream);){
            ZipArchiveEntry inflatedEntry = zipStream.getNextZipEntry();
            Assert.assertEquals((Object)"inflated.txt", (Object)inflatedEntry.getName());
            Assert.assertEquals((long)0L, (long)inflatedEntry.getLocalHeaderOffset());
            Assert.assertEquals((long)70L, (long)inflatedEntry.getDataOffset());
            ZipArchiveEntry storedEntry = zipStream.getNextZipEntry();
            Assert.assertEquals((Object)"stored.txt", (Object)storedEntry.getName());
            Assert.assertEquals((long)22674L, (long)storedEntry.getLocalHeaderOffset());
            Assert.assertEquals((long)22742L, (long)storedEntry.getDataOffset());
            Assert.assertNull((Object)zipStream.getNextZipEntry());
        }
    }

    @Test
    public void nameSourceDefaultsToName() throws Exception {
        ZipArchiveInputStreamTest.nameSource("bla.zip", "test1.xml", ZipArchiveEntry.NameSource.NAME);
    }

    @Test
    public void nameSourceIsSetToUnicodeExtraField() throws Exception {
        ZipArchiveInputStreamTest.nameSource("utf8-winzip-test.zip", "\u20ac_for_Dollar.txt", ZipArchiveEntry.NameSource.UNICODE_EXTRA_FIELD);
    }

    @Test
    public void nameSourceIsSetToEFS() throws Exception {
        ZipArchiveInputStreamTest.nameSource("utf8-7zip-test.zip", "\u20ac_for_Dollar.txt", 3, ZipArchiveEntry.NameSource.NAME_WITH_EFS_FLAG);
    }

    @Test
    public void properlyMarksEntriesAsUnreadableIfUncompressedSizeIsUnknown() throws Exception {
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));){
            ZipArchiveEntry e = new ZipArchiveEntry("test");
            e.setMethod(ZipMethod.DEFLATED.getCode());
            Assert.assertTrue((boolean)zis.canReadEntryData((ArchiveEntry)e));
            e.setMethod(ZipMethod.ENHANCED_DEFLATED.getCode());
            Assert.assertTrue((boolean)zis.canReadEntryData((ArchiveEntry)e));
            e.setMethod(ZipMethod.BZIP2.getCode());
            Assert.assertFalse((boolean)zis.canReadEntryData((ArchiveEntry)e));
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("bla.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingStore() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("COMPRESS-264.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingUnshrink() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("SHRUNK.ZIP"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingExplode() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("imploding-8Kdict-3trees.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate64() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("COMPRESS-380/COMPRESS-380.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingBzip2() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("bzip2-zip.zip"));
    }

    private void singleByteReadConsistentlyReturnsMinusOneAtEof(File file) throws Exception {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
             ZipArchiveInputStream archive = new ZipArchiveInputStream(in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read());
            Assert.assertEquals((long)-1L, (long)archive.read());
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("bla.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingStore() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("COMPRESS-264.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingUnshrink() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("SHRUNK.ZIP"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingExplode() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("imploding-8Kdict-3trees.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate64() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("COMPRESS-380/COMPRESS-380.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingBzip2() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("bzip2-zip.zip"));
    }

    private void multiByteReadConsistentlyReturnsMinusOneAtEof(File file) throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = Files.newInputStream(AbstractTestCase.getFile("bla.zip").toPath(), new OpenOption[0]);
             ZipArchiveInputStream archive = new ZipArchiveInputStream(in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
        }
    }

    @Test
    public void singleByteReadThrowsAtEofForCorruptedStoredEntry() throws Exception {
        byte[] content;
        try (InputStream fs = Files.newInputStream(AbstractTestCase.getFile("COMPRESS-264.zip").toPath(), new OpenOption[0]);){
            content = IOUtils.toByteArray((InputStream)fs);
        }
        for (int i = 17; i < 26; ++i) {
            content[i] = -1;
        }
        var3_4 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(content);
             ZipArchiveInputStream archive = new ZipArchiveInputStream((InputStream)in);){
            ArchiveEntry e = archive.getNextEntry();
            try {
                IOUtils.toByteArray((InputStream)archive);
                Assert.fail((String)"expected exception");
            }
            catch (IOException ex) {
                Assert.assertEquals((Object)"Truncated ZIP file", (Object)ex.getMessage());
            }
            try {
                archive.read();
                Assert.fail((String)"expected exception");
            }
            catch (IOException ex) {
                Assert.assertEquals((Object)"Truncated ZIP file", (Object)ex.getMessage());
            }
            try {
                archive.read();
                Assert.fail((String)"expected exception");
            }
            catch (IOException ex) {
                Assert.assertEquals((Object)"Truncated ZIP file", (Object)ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            var3_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void multiByteReadThrowsAtEofForCorruptedStoredEntry() throws Exception {
        byte[] content;
        try (InputStream fs = Files.newInputStream(AbstractTestCase.getFile("COMPRESS-264.zip").toPath(), new OpenOption[0]);){
            content = IOUtils.toByteArray((InputStream)fs);
        }
        for (int i = 17; i < 26; ++i) {
            content[i] = -1;
        }
        byte[] buf = new byte[2];
        try (ByteArrayInputStream in = new ByteArrayInputStream(content);
             ZipArchiveInputStream archive = new ZipArchiveInputStream((InputStream)in);){
            ArchiveEntry e = archive.getNextEntry();
            try {
                IOUtils.toByteArray((InputStream)archive);
                Assert.fail((String)"expected exception");
            }
            catch (IOException ex) {
                Assert.assertEquals((Object)"Truncated ZIP file", (Object)ex.getMessage());
            }
            try {
                archive.read(buf);
                Assert.fail((String)"expected exception");
            }
            catch (IOException ex) {
                Assert.assertEquals((Object)"Truncated ZIP file", (Object)ex.getMessage());
            }
            try {
                archive.read(buf);
                Assert.fail((String)"expected exception");
            }
            catch (IOException ex) {
                Assert.assertEquals((Object)"Truncated ZIP file", (Object)ex.getMessage());
            }
        }
    }

    @Test
    public void properlyReadsStoredEntries() throws IOException {
        try (InputStream fs = Files.newInputStream(AbstractTestCase.getFile("bla-stored.zip").toPath(), new OpenOption[0]);
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assert.assertEquals((long)610L, (long)e.getCompressedSize());
            Assert.assertEquals((long)610L, (long)e.getSize());
            byte[] data = IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)610L, (long)data.length);
            e = archive.getNextZipEntry();
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((Object)"test2.xml", (Object)e.getName());
            Assert.assertEquals((long)82L, (long)e.getCompressedSize());
            Assert.assertEquals((long)82L, (long)e.getSize());
            data = IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)82L, (long)data.length);
            Assert.assertNull((Object)archive.getNextEntry());
        }
    }

    @Test
    public void rejectsStoredEntriesWithDataDescriptorByDefault() throws IOException {
        try (InputStream fs = Files.newInputStream(AbstractTestCase.getFile("bla-stored-dd.zip").toPath(), new OpenOption[0]);
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assert.assertEquals((long)-1L, (long)e.getCompressedSize());
            Assert.assertEquals((long)-1L, (long)e.getSize());
            this.thrown.expect(UnsupportedZipFeatureException.class);
            this.thrown.expectMessage("Unsupported feature data descriptor used in entry test1.xml");
            byte[] byArray = IOUtils.toByteArray((InputStream)archive);
        }
    }

    @Test
    public void properlyReadsStoredEntryWithDataDescriptorWithSignature() throws IOException {
        try (InputStream fs = Files.newInputStream(AbstractTestCase.getFile("bla-stored-dd.zip").toPath(), new OpenOption[0]);
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs, "UTF-8", true, true);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assert.assertEquals((long)-1L, (long)e.getCompressedSize());
            Assert.assertEquals((long)-1L, (long)e.getSize());
            byte[] data = IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)610L, (long)data.length);
            Assert.assertEquals((long)610L, (long)e.getCompressedSize());
            Assert.assertEquals((long)610L, (long)e.getSize());
        }
    }

    @Test
    public void properlyReadsStoredEntryWithDataDescriptorWithoutSignature() throws IOException {
        try (InputStream fs = Files.newInputStream(AbstractTestCase.getFile("bla-stored-dd-nosig.zip").toPath(), new OpenOption[0]);
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs, "UTF-8", true, true);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assert.assertEquals((long)-1L, (long)e.getCompressedSize());
            Assert.assertEquals((long)-1L, (long)e.getSize());
            byte[] data = IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)610L, (long)data.length);
            Assert.assertEquals((long)610L, (long)e.getCompressedSize());
            Assert.assertEquals((long)610L, (long)e.getSize());
        }
    }

    @Test
    public void throwsIfStoredDDIsInconsistent() throws IOException {
        try (InputStream fs = Files.newInputStream(AbstractTestCase.getFile("bla-stored-dd-sizes-differ.zip").toPath(), new OpenOption[0]);
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs, "UTF-8", true, true);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assert.assertEquals((long)-1L, (long)e.getCompressedSize());
            Assert.assertEquals((long)-1L, (long)e.getSize());
            this.thrown.expect(ZipException.class);
            this.thrown.expectMessage("compressed and uncompressed size don't match");
            byte[] byArray = IOUtils.toByteArray((InputStream)archive);
        }
    }

    @Test
    public void throwsIfStoredDDIsDifferentFromLengthRead() throws IOException {
        try (InputStream fs = Files.newInputStream(AbstractTestCase.getFile("bla-stored-dd-contradicts-actualsize.zip").toPath(), new OpenOption[0]);
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs, "UTF-8", true, true);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assert.assertEquals((long)-1L, (long)e.getCompressedSize());
            Assert.assertEquals((long)-1L, (long)e.getSize());
            this.thrown.expect(ZipException.class);
            this.thrown.expectMessage("actual and claimed size don't match");
            byte[] byArray = IOUtils.toByteArray((InputStream)archive);
        }
    }

    @Test
    public void testSplitZipCreatedByZip() throws IOException {
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        try (SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
             InputStream inputStream = Channels.newInputStream(channel);
             ZipArchiveInputStream splitInputStream = new ZipArchiveInputStream(inputStream, "UTF8", true, false, true);){
            File fileToCompare = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/zip_to_compare_created_by_zip.zip");
            try (ZipArchiveInputStream inputStreamToCompare = new ZipArchiveInputStream(Files.newInputStream(fileToCompare.toPath(), new OpenOption[0]), "UTF8", true, false, true);){
                ArchiveEntry entry;
                while ((entry = splitInputStream.getNextEntry()) != null && inputStreamToCompare.getNextEntry() != null) {
                    if (entry.isDirectory()) continue;
                    Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)splitInputStream), (byte[])IOUtils.toByteArray((InputStream)inputStreamToCompare));
                }
            }
        }
    }

    @Test
    public void testSplitZipCreatedByZipOfZip64() throws IOException {
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip_zip64.zip");
        try (SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
             InputStream inputStream = Channels.newInputStream(channel);
             ZipArchiveInputStream splitInputStream = new ZipArchiveInputStream(inputStream, "UTF8", true, false, true);){
            File fileToCompare = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/zip_to_compare_created_by_zip_zip64.zip");
            try (ZipArchiveInputStream inputStreamToCompare = new ZipArchiveInputStream(Files.newInputStream(fileToCompare.toPath(), new OpenOption[0]), "UTF8", true, false, true);){
                ArchiveEntry entry;
                while ((entry = splitInputStream.getNextEntry()) != null && inputStreamToCompare.getNextEntry() != null) {
                    if (entry.isDirectory()) continue;
                    Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)splitInputStream), (byte[])IOUtils.toByteArray((InputStream)inputStreamToCompare));
                }
            }
        }
    }

    @Test
    public void testSplitZipCreatedByWinrar() throws IOException {
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_winrar/split_zip_created_by_winrar.zip");
        try (SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
             InputStream inputStream = Channels.newInputStream(channel);
             ZipArchiveInputStream splitInputStream = new ZipArchiveInputStream(inputStream, "UTF8", true, false, true);){
            File fileToCompare = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_winrar/zip_to_compare_created_by_winrar.zip");
            try (ZipArchiveInputStream inputStreamToCompare = new ZipArchiveInputStream(Files.newInputStream(fileToCompare.toPath(), new OpenOption[0]), "UTF8", true, false, true);){
                ArchiveEntry entry;
                while ((entry = splitInputStream.getNextEntry()) != null && inputStreamToCompare.getNextEntry() != null) {
                    if (entry.isDirectory()) continue;
                    Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)splitInputStream), (byte[])IOUtils.toByteArray((InputStream)inputStreamToCompare));
                }
            }
        }
    }

    @Test
    public void testSplitZipCreatedByZipThrowsException() throws IOException {
        this.thrown.expect(EOFException.class);
        File zipSplitFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        InputStream fileInputStream = Files.newInputStream(zipSplitFile.toPath(), new OpenOption[0]);
        ZipArchiveInputStream inputStream = new ZipArchiveInputStream(fileInputStream, "UTF8", true, false, true);
        ArchiveEntry entry = inputStream.getNextEntry();
        while (entry != null) {
            entry = inputStream.getNextEntry();
        }
    }

    @Test
    public void throwsIfZip64ExtraCouldNotBeUnderstood() throws Exception {
        this.thrown.expect(ZipException.class);
        this.fuzzingTest(new int[]{80, 75, 3, 4, 46, 0, 0, 0, 12, 0, 132, 182, 186, 70, 114, 182, 254, 119, 99, 0, 0, 0, 107, 0, 0, 0, 3, 0, 28, 0, 98, 98, 98, 1, 0, 9, 0, 3, 231, 206, 100, 85, 243, 206, 100, 85, 117, 120, 11, 0, 1, 4, 92, 249, 1, 0, 4, 136, 19, 0, 0});
    }

    @Test
    public void throwsIfThereIsNoEocd() throws Exception {
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("Truncated ZIP file");
        this.fuzzingTest(new int[]{80, 75, 1, 2, 20, 0, 20, 0, 8, 0, 8, 0, 0, 0, 0, 0, 67, 190, 0, 0, 0, 183, 232, 7, 0, 0, 0, 1, 0, 0});
    }

    @Test(expected=IOException.class)
    public void throwsIOExceptionIfThereIsCorruptedZip64Extra() throws IOException {
        try (InputStream fis = Files.newInputStream(AbstractTestCase.getFile("COMPRESS-546.zip").toPath(), new OpenOption[0]);
             ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(fis);){
            while (zipInputStream.getNextZipEntry() != null) {
            }
        }
    }

    @Test
    public void testZipWithBadExtraFields() throws IOException {
        try (InputStream fis = Files.newInputStream(AbstractTestCase.getFile("COMPRESS-548.zip").toPath(), new OpenOption[0]);
             ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(fis);){
            while (zipInputStream.getNextZipEntry() != null) {
            }
        }
    }

    @Test
    public void testZipUsingStoredWithDDAndNoDDSignature() throws IOException {
        try (InputStream inputStream = this.forgeZipInputStream();
             ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(inputStream, "UTF-8", true, true);){
            while (zipInputStream.getNextZipEntry() != null) {
            }
        }
    }

    private static byte[] readEntry(ZipArchiveInputStream zip, ZipArchiveEntry zae) throws IOException {
        int len = (int)zae.getSize();
        byte[] buff = new byte[len];
        zip.read(buff, 0, len);
        return buff;
    }

    private static void nameSource(String archive, String entry, ZipArchiveEntry.NameSource expected) throws Exception {
        ZipArchiveInputStreamTest.nameSource(archive, entry, 1, expected);
    }

    private static void nameSource(String archive, String entry, int entryNo, ZipArchiveEntry.NameSource expected) throws Exception {
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream(Files.newInputStream(AbstractTestCase.getFile(archive).toPath(), new OpenOption[0]));){
            ZipArchiveEntry ze;
            do {
                ze = zis.getNextZipEntry();
            } while (--entryNo > 0);
            Assert.assertEquals((Object)entry, (Object)ze.getName());
            Assert.assertEquals((Object)expected, (Object)ze.getNameSource());
        }
    }

    private void fuzzingTest(int[] bytes) throws Exception {
        int len = bytes.length;
        byte[] input = new byte[len];
        for (int i = 0; i < len; ++i) {
            input[i] = (byte)bytes[i];
        }
        try (ArchiveInputStream ais = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("zip", (InputStream)new ByteArrayInputStream(input));){
            ais.getNextEntry();
            IOUtils.toByteArray((InputStream)ais);
        }
    }

    /*
     * Exception decompiling
     */
    private InputStream forgeZipInputStream() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

