/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.ExtraFieldUtils;
import org.apache.commons.compress.archivers.zip.UnixStat;
import org.apache.commons.compress.archivers.zip.UnparseableExtraFieldData;
import org.apache.commons.compress.archivers.zip.UnrecognizedExtraField;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExtraFieldUtilsTest
implements UnixStat {
    static final ZipShort UNRECOGNIZED_HEADER = new ZipShort(21845);
    static final ZipShort AIOB_HEADER = new ZipShort(4096);
    private AsiExtraField a;
    private UnrecognizedExtraField dummy;
    private byte[] data;
    private byte[] aLocal;

    @Before
    public void setUp() {
        this.a = new AsiExtraField();
        this.a.setMode(493);
        this.a.setDirectory(true);
        this.dummy = new UnrecognizedExtraField();
        this.dummy.setHeaderId(UNRECOGNIZED_HEADER);
        this.dummy.setLocalFileDataData(new byte[]{0});
        this.dummy.setCentralDirectoryData(new byte[]{0});
        this.aLocal = this.a.getLocalFileDataData();
        byte[] dummyLocal = this.dummy.getLocalFileDataData();
        this.data = new byte[4 + this.aLocal.length + 4 + dummyLocal.length];
        System.arraycopy(this.a.getHeaderId().getBytes(), 0, this.data, 0, 2);
        System.arraycopy(this.a.getLocalFileDataLength().getBytes(), 0, this.data, 2, 2);
        System.arraycopy(this.aLocal, 0, this.data, 4, this.aLocal.length);
        System.arraycopy(this.dummy.getHeaderId().getBytes(), 0, this.data, 4 + this.aLocal.length, 2);
        System.arraycopy(this.dummy.getLocalFileDataLength().getBytes(), 0, this.data, 4 + this.aLocal.length + 2, 2);
        System.arraycopy(dummyLocal, 0, this.data, 4 + this.aLocal.length + 4, dummyLocal.length);
    }

    @Test
    public void testParse() throws Exception {
        ZipExtraField[] ze = ExtraFieldUtils.parse((byte[])this.data);
        Assert.assertEquals((String)"number of fields", (long)2L, (long)ze.length);
        Assert.assertTrue((String)"type field 1", (boolean)(ze[0] instanceof AsiExtraField));
        Assert.assertEquals((String)"mode field 1", (long)16877L, (long)((AsiExtraField)ze[0]).getMode());
        Assert.assertTrue((String)"type field 2", (boolean)(ze[1] instanceof UnrecognizedExtraField));
        Assert.assertEquals((String)"data length field 2", (long)1L, (long)ze[1].getLocalFileDataLength().getValue());
        byte[] data2 = new byte[this.data.length - 1];
        System.arraycopy(this.data, 0, data2, 0, data2.length);
        try {
            ExtraFieldUtils.parse((byte[])data2);
            Assert.fail((String)"data should be invalid");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"message", (Object)("Bad extra field starting at " + (4 + this.aLocal.length) + ".  Block length of 1 bytes exceeds remaining data of 0 bytes."), (Object)e.getMessage());
        }
    }

    @Test
    public void parseTurnsArrayIndexOutOfBoundsIntoZipException() throws Exception {
        ExtraFieldUtils.register(AiobThrowingExtraField.class);
        AiobThrowingExtraField f = new AiobThrowingExtraField();
        byte[] d = new byte[8];
        System.arraycopy(f.getHeaderId().getBytes(), 0, d, 0, 2);
        System.arraycopy(f.getLocalFileDataLength().getBytes(), 0, d, 2, 2);
        System.arraycopy(f.getLocalFileDataData(), 0, d, 4, 4);
        try {
            ExtraFieldUtils.parse((byte[])d);
            Assert.fail((String)"data should be invalid");
        }
        catch (ZipException e) {
            Assert.assertEquals((String)"message", (Object)"Failed to parse corrupt ZIP extra field of type 1000", (Object)e.getMessage());
        }
    }

    @Test
    public void testParseCentral() throws Exception {
        ZipExtraField[] ze = ExtraFieldUtils.parse((byte[])this.data, (boolean)false);
        Assert.assertEquals((String)"number of fields", (long)2L, (long)ze.length);
        Assert.assertTrue((String)"type field 1", (boolean)(ze[0] instanceof AsiExtraField));
        Assert.assertEquals((String)"mode field 1", (long)16877L, (long)((AsiExtraField)ze[0]).getMode());
        Assert.assertTrue((String)"type field 2", (boolean)(ze[1] instanceof UnrecognizedExtraField));
        Assert.assertEquals((String)"data length field 2", (long)1L, (long)ze[1].getCentralDirectoryLength().getValue());
    }

    @Test
    public void testParseWithRead() throws Exception {
        ZipExtraField[] ze = ExtraFieldUtils.parse((byte[])this.data, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.READ);
        Assert.assertEquals((String)"number of fields", (long)2L, (long)ze.length);
        Assert.assertTrue((String)"type field 1", (boolean)(ze[0] instanceof AsiExtraField));
        Assert.assertEquals((String)"mode field 1", (long)16877L, (long)((AsiExtraField)ze[0]).getMode());
        Assert.assertTrue((String)"type field 2", (boolean)(ze[1] instanceof UnrecognizedExtraField));
        Assert.assertEquals((String)"data length field 2", (long)1L, (long)ze[1].getLocalFileDataLength().getValue());
        byte[] data2 = new byte[this.data.length - 1];
        System.arraycopy(this.data, 0, data2, 0, data2.length);
        ze = ExtraFieldUtils.parse((byte[])data2, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.READ);
        Assert.assertEquals((String)"number of fields", (long)2L, (long)ze.length);
        Assert.assertTrue((String)"type field 1", (boolean)(ze[0] instanceof AsiExtraField));
        Assert.assertEquals((String)"mode field 1", (long)16877L, (long)((AsiExtraField)ze[0]).getMode());
        Assert.assertTrue((String)"type field 2", (boolean)(ze[1] instanceof UnparseableExtraFieldData));
        Assert.assertEquals((String)"data length field 2", (long)4L, (long)ze[1].getLocalFileDataLength().getValue());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((String)("byte number " + i), (long)data2[this.data.length - 5 + i], (long)ze[1].getLocalFileDataData()[i]);
        }
    }

    @Test
    public void testParseWithSkip() throws Exception {
        ZipExtraField[] ze = ExtraFieldUtils.parse((byte[])this.data, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.SKIP);
        Assert.assertEquals((String)"number of fields", (long)2L, (long)ze.length);
        Assert.assertTrue((String)"type field 1", (boolean)(ze[0] instanceof AsiExtraField));
        Assert.assertEquals((String)"mode field 1", (long)16877L, (long)((AsiExtraField)ze[0]).getMode());
        Assert.assertTrue((String)"type field 2", (boolean)(ze[1] instanceof UnrecognizedExtraField));
        Assert.assertEquals((String)"data length field 2", (long)1L, (long)ze[1].getLocalFileDataLength().getValue());
        byte[] data2 = new byte[this.data.length - 1];
        System.arraycopy(this.data, 0, data2, 0, data2.length);
        ze = ExtraFieldUtils.parse((byte[])data2, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.SKIP);
        Assert.assertEquals((String)"number of fields", (long)1L, (long)ze.length);
        Assert.assertTrue((String)"type field 1", (boolean)(ze[0] instanceof AsiExtraField));
        Assert.assertEquals((String)"mode field 1", (long)16877L, (long)((AsiExtraField)ze[0]).getMode());
    }

    @Test
    public void testMerge() {
        byte[] local = ExtraFieldUtils.mergeLocalFileDataData((ZipExtraField[])new ZipExtraField[]{this.a, this.dummy});
        Assert.assertEquals((String)"local length", (long)this.data.length, (long)local.length);
        for (int i = 0; i < local.length; ++i) {
            Assert.assertEquals((String)("local byte " + i), (long)this.data[i], (long)local[i]);
        }
        byte[] dummyCentral = this.dummy.getCentralDirectoryData();
        byte[] data2 = new byte[4 + this.aLocal.length + 4 + dummyCentral.length];
        System.arraycopy(this.data, 0, data2, 0, 4 + this.aLocal.length + 2);
        System.arraycopy(this.dummy.getCentralDirectoryLength().getBytes(), 0, data2, 4 + this.aLocal.length + 2, 2);
        System.arraycopy(dummyCentral, 0, data2, 4 + this.aLocal.length + 4, dummyCentral.length);
        byte[] central = ExtraFieldUtils.mergeCentralDirectoryData((ZipExtraField[])new ZipExtraField[]{this.a, this.dummy});
        Assert.assertEquals((String)"central length", (long)data2.length, (long)central.length);
        for (int i = 0; i < central.length; ++i) {
            Assert.assertEquals((String)("central byte " + i), (long)data2[i], (long)central[i]);
        }
    }

    @Test
    public void testMergeWithUnparseableData() throws Exception {
        UnparseableExtraFieldData d = new UnparseableExtraFieldData();
        byte[] b = UNRECOGNIZED_HEADER.getBytes();
        d.parseFromLocalFileData(new byte[]{b[0], b[1], 1, 0}, 0, 4);
        byte[] local = ExtraFieldUtils.mergeLocalFileDataData((ZipExtraField[])new ZipExtraField[]{this.a, d});
        Assert.assertEquals((String)"local length", (long)(this.data.length - 1), (long)local.length);
        for (int i = 0; i < local.length; ++i) {
            Assert.assertEquals((String)("local byte " + i), (long)this.data[i], (long)local[i]);
        }
        byte[] dCentral = d.getCentralDirectoryData();
        byte[] data2 = new byte[4 + this.aLocal.length + dCentral.length];
        System.arraycopy(this.data, 0, data2, 0, 4 + this.aLocal.length + 2);
        System.arraycopy(dCentral, 0, data2, 4 + this.aLocal.length, dCentral.length);
        byte[] central = ExtraFieldUtils.mergeCentralDirectoryData((ZipExtraField[])new ZipExtraField[]{this.a, d});
        Assert.assertEquals((String)"central length", (long)data2.length, (long)central.length);
        for (int i = 0; i < central.length; ++i) {
            Assert.assertEquals((String)("central byte " + i), (long)data2[i], (long)central[i]);
        }
    }

    public static class AiobThrowingExtraField
    implements ZipExtraField {
        static final int LENGTH = 4;

        public ZipShort getHeaderId() {
            return AIOB_HEADER;
        }

        public ZipShort getLocalFileDataLength() {
            return new ZipShort(4);
        }

        public ZipShort getCentralDirectoryLength() {
            return this.getLocalFileDataLength();
        }

        public byte[] getLocalFileDataData() {
            return new byte[4];
        }

        public byte[] getCentralDirectoryData() {
            return this.getLocalFileDataData();
        }

        public void parseFromLocalFileData(byte[] buffer, int offset, int length) throws ZipException {
            throw new ArrayIndexOutOfBoundsException();
        }

        public void parseFromCentralDirectoryData(byte[] buffer, int offset, int length) throws ZipException {
            this.parseFromLocalFileData(buffer, offset, length);
        }
    }
}

