/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.sevenz.Coders;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.Assert;
import org.junit.Test;

public class SevenZNativeHeapTest
extends AbstractTestCase {
    @Test
    public void testEndDeflaterOnCloseStream() throws Exception {
        DelegatingDeflater delegatingDeflater;
        Coders.DeflateDecoder deflateDecoder = new Coders.DeflateDecoder();
        try (Coders.DeflateDecoder.DeflateDecoderOutputStream outputStream = (Coders.DeflateDecoder.DeflateDecoderOutputStream)deflateDecoder.encode((OutputStream)new ByteArrayOutputStream(), (Object)9);){
            delegatingDeflater = new DelegatingDeflater(outputStream.deflater);
            outputStream.deflater = delegatingDeflater;
        }
        Assert.assertTrue((boolean)delegatingDeflater.isEnded.get());
    }

    @Test
    public void testEndInflaterOnCloseStream() throws Exception {
        DelegatingInflater delegatingInflater;
        Coders.DeflateDecoder deflateDecoder = new Coders.DeflateDecoder();
        try (Coders.DeflateDecoder.DeflateDecoderInputStream inputStream = (Coders.DeflateDecoder.DeflateDecoderInputStream)deflateDecoder.decode("dummy", (InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY), 0L, null, null, Integer.MAX_VALUE);){
            delegatingInflater = new DelegatingInflater(inputStream.inflater);
            inputStream.inflater = delegatingInflater;
        }
        Assert.assertTrue((boolean)delegatingInflater.isEnded.get());
    }

    private class DelegatingDeflater
    extends Deflater {
        private final Deflater deflater;
        final AtomicBoolean isEnded = new AtomicBoolean();

        public DelegatingDeflater(Deflater deflater) {
            this.deflater = deflater;
        }

        @Override
        public void end() {
            this.isEnded.set(true);
            this.deflater.end();
        }

        @Override
        public void setInput(byte[] b, int off, int len) {
            this.deflater.setInput(b, off, len);
        }

        @Override
        public void setInput(byte[] b) {
            this.deflater.setInput(b);
        }

        @Override
        public void setDictionary(byte[] b, int off, int len) {
            this.deflater.setDictionary(b, off, len);
        }

        @Override
        public void setDictionary(byte[] b) {
            this.deflater.setDictionary(b);
        }

        @Override
        public void setStrategy(int strategy) {
            this.deflater.setStrategy(strategy);
        }

        @Override
        public void setLevel(int level) {
            this.deflater.setLevel(level);
        }

        @Override
        public boolean needsInput() {
            return this.deflater.needsInput();
        }

        @Override
        public void finish() {
            this.deflater.finish();
        }

        @Override
        public boolean finished() {
            return this.deflater.finished();
        }

        @Override
        public int deflate(byte[] b, int off, int len) {
            return this.deflater.deflate(b, off, len);
        }

        @Override
        public int deflate(byte[] b) {
            return this.deflater.deflate(b);
        }

        @Override
        public int deflate(byte[] b, int off, int len, int flush) {
            return this.deflater.deflate(b, off, len, flush);
        }

        @Override
        public int getAdler() {
            return this.deflater.getAdler();
        }

        @Override
        public int getTotalIn() {
            return this.deflater.getTotalIn();
        }

        @Override
        public long getBytesRead() {
            return this.deflater.getBytesRead();
        }

        @Override
        public int getTotalOut() {
            return this.deflater.getTotalOut();
        }

        @Override
        public long getBytesWritten() {
            return this.deflater.getBytesWritten();
        }

        @Override
        public void reset() {
            this.deflater.reset();
        }
    }

    private class DelegatingInflater
    extends Inflater {
        private final Inflater inflater;
        final AtomicBoolean isEnded = new AtomicBoolean();

        public DelegatingInflater(Inflater inflater) {
            this.inflater = inflater;
        }

        @Override
        public void end() {
            this.isEnded.set(true);
            this.inflater.end();
        }

        @Override
        public void setInput(byte[] b, int off, int len) {
            this.inflater.setInput(b, off, len);
        }

        @Override
        public void setInput(byte[] b) {
            this.inflater.setInput(b);
        }

        @Override
        public void setDictionary(byte[] b, int off, int len) {
            this.inflater.setDictionary(b, off, len);
        }

        @Override
        public void setDictionary(byte[] b) {
            this.inflater.setDictionary(b);
        }

        @Override
        public int getRemaining() {
            return this.inflater.getRemaining();
        }

        @Override
        public boolean needsInput() {
            return this.inflater.needsInput();
        }

        @Override
        public boolean needsDictionary() {
            return this.inflater.needsDictionary();
        }

        @Override
        public boolean finished() {
            return this.inflater.finished();
        }

        @Override
        public int inflate(byte[] b, int off, int len) throws DataFormatException {
            return this.inflater.inflate(b, off, len);
        }

        @Override
        public int inflate(byte[] b) throws DataFormatException {
            return this.inflater.inflate(b);
        }

        @Override
        public int getAdler() {
            return this.inflater.getAdler();
        }

        @Override
        public int getTotalIn() {
            return this.inflater.getTotalIn();
        }

        @Override
        public long getBytesRead() {
            return this.inflater.getBytesRead();
        }

        @Override
        public int getTotalOut() {
            return this.inflater.getTotalOut();
        }

        @Override
        public long getBytesWritten() {
            return this.inflater.getBytesWritten();
        }

        @Override
        public void reset() {
            this.inflater.reset();
        }
    }
}

