/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Calc;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.hive.druid.org.apache.calcite.rel.rules.CalcRelSplitter;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexDynamicParam;
import org.apache.hive.druid.org.apache.calcite.rex.RexFieldAccess;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexLocalRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexOver;
import org.apache.hive.druid.org.apache.calcite.rex.RexProgram;
import org.apache.hive.druid.org.apache.calcite.rex.RexVisitorImpl;
import org.apache.hive.druid.org.apache.calcite.rex.RexWindow;
import org.apache.hive.druid.org.apache.calcite.runtime.PredicateImpl;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableIntList;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.hive.druid.org.apache.calcite.util.graph.DefaultEdge;
import org.apache.hive.druid.org.apache.calcite.util.graph.DirectedGraph;
import org.apache.hive.druid.org.apache.calcite.util.graph.TopologicalOrderIterator;

public abstract class ProjectToWindowRule
extends RelOptRule {
    private static final Predicate<Calc> PREDICATE = new PredicateImpl<Calc>(){

        @Override
        public boolean test(Calc calc) {
            return RexOver.containsOver(calc.getProgram());
        }
    };
    private static final Predicate<Project> PREDICATE2 = new PredicateImpl<Project>(){

        @Override
        public boolean test(Project project) {
            return RexOver.containsOver(project.getProjects(), null);
        }
    };
    public static final ProjectToWindowRule INSTANCE = new CalcToWindowRule(RelFactories.LOGICAL_BUILDER);
    public static final ProjectToWindowRule PROJECT = new ProjectToLogicalProjectAndWindowRule(RelFactories.LOGICAL_BUILDER);

    public ProjectToWindowRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    static class WindowedAggRelSplitter
    extends CalcRelSplitter {
        private static final CalcRelSplitter.RelType[] REL_TYPES = new CalcRelSplitter.RelType[]{new CalcRelSplitter.RelType("CalcRelType"){

            @Override
            protected boolean canImplement(RexFieldAccess field) {
                return true;
            }

            @Override
            protected boolean canImplement(RexDynamicParam param) {
                return true;
            }

            @Override
            protected boolean canImplement(RexLiteral literal) {
                return true;
            }

            @Override
            protected boolean canImplement(RexCall call) {
                return !(call instanceof RexOver);
            }

            @Override
            protected RelNode makeRel(RelOptCluster cluster, RelTraitSet traitSet, RelBuilder relBuilder, RelNode input, RexProgram program) {
                assert (!program.containsAggs());
                program = program.normalize(cluster.getRexBuilder(), null);
                return super.makeRel(cluster, traitSet, relBuilder, input, program);
            }
        }, new CalcRelSplitter.RelType("WinAggRelType"){

            @Override
            protected boolean canImplement(RexFieldAccess field) {
                return false;
            }

            @Override
            protected boolean canImplement(RexDynamicParam param) {
                return false;
            }

            @Override
            protected boolean canImplement(RexLiteral literal) {
                return false;
            }

            @Override
            protected boolean canImplement(RexCall call) {
                return call instanceof RexOver;
            }

            @Override
            protected boolean supportsCondition() {
                return false;
            }

            @Override
            protected RelNode makeRel(RelOptCluster cluster, RelTraitSet traitSet, RelBuilder relBuilder, RelNode input, RexProgram program) {
                Preconditions.checkArgument(program.getCondition() == null, "WindowedAggregateRel cannot accept a condition");
                return LogicalWindow.create(cluster, traitSet, relBuilder, input, program);
            }
        }};

        WindowedAggRelSplitter(Calc calc, RelBuilder relBuilder) {
            super(calc, relBuilder, REL_TYPES);
        }

        @Override
        protected List<Set<Integer>> getCohorts() {
            List<RexNode> exprs = this.program.getExprList();
            DirectedGraph<Integer, DefaultEdge> graph = this.createGraphFromExpression(exprs);
            List<Integer> rank = this.getRank(graph);
            ArrayList<Pair<RexWindow, HashSet<Integer>>> windowToIndices = new ArrayList<Pair<RexWindow, HashSet<Integer>>>();
            for (int i = 0; i < exprs.size(); ++i) {
                RexNode expr = exprs.get(i);
                if (!(expr instanceof RexOver)) continue;
                RexOver rexOver = (RexOver)expr;
                boolean isFound = false;
                for (Pair pair : windowToIndices) {
                    if (!((RexWindow)pair.left).equals(rexOver.getWindow())) continue;
                    boolean hasDependency = false;
                    Iterator iterator = ((Set)pair.right).iterator();
                    while (iterator.hasNext()) {
                        int ordinal = (Integer)iterator.next();
                        if (!this.isDependent(graph, rank, ordinal, i)) continue;
                        hasDependency = true;
                        break;
                    }
                    if (hasDependency) continue;
                    ((Set)pair.right).add(i);
                    isFound = true;
                    break;
                }
                if (isFound) continue;
                HashSet<Integer> newSet = Sets.newHashSet(i);
                windowToIndices.add(Pair.of(rexOver.getWindow(), newSet));
            }
            ArrayList<Set<Integer>> cohorts = new ArrayList<Set<Integer>>();
            for (Pair pair : windowToIndices) {
                cohorts.add((Set<Integer>)pair.right);
            }
            return cohorts;
        }

        private boolean isDependent(DirectedGraph<Integer, DefaultEdge> graph, List<Integer> rank, int ordinal1, int ordinal2) {
            if (rank.get(ordinal2) > rank.get(ordinal1)) {
                return this.isDependent(graph, rank, ordinal2, ordinal1);
            }
            ArrayDeque<Integer> dfs = new ArrayDeque<Integer>();
            HashSet<Integer> visited = new HashSet<Integer>();
            dfs.push(ordinal2);
            while (!dfs.isEmpty()) {
                int source = (Integer)dfs.pop();
                if (visited.contains(source)) continue;
                if (source == ordinal1) {
                    return true;
                }
                visited.add(source);
                for (DefaultEdge e : graph.getOutwardEdges(source)) {
                    int target = (Integer)e.target;
                    if (rank.get(target) >= rank.get(ordinal1)) continue;
                    dfs.push(target);
                }
            }
            return false;
        }

        private List<Integer> getRank(DirectedGraph<Integer, DefaultEdge> graph) {
            int[] rankArr = new int[graph.vertexSet().size()];
            int rank = 0;
            for (int i : TopologicalOrderIterator.of(graph)) {
                rankArr[i] = rank++;
            }
            return ImmutableIntList.of(rankArr);
        }

        private DirectedGraph<Integer, DefaultEdge> createGraphFromExpression(List<RexNode> exprs) {
            final DefaultDirectedGraph<Integer, DefaultEdge> graph = DefaultDirectedGraph.create();
            for (int i = 0; i < exprs.size(); ++i) {
                graph.addVertex(i);
            }
            for (final Ord<RexNode> expr : Ord.zip(exprs)) {
                ((RexNode)expr.e).accept(new RexVisitorImpl<Void>(true){

                    @Override
                    public Void visitLocalRef(RexLocalRef localRef) {
                        graph.addEdge(localRef.getIndex(), expr.i);
                        return null;
                    }
                });
            }
            assert (graph.vertexSet().size() == exprs.size());
            return graph;
        }
    }

    public static class ProjectToLogicalProjectAndWindowRule
    extends ProjectToWindowRule {
        public ProjectToLogicalProjectAndWindowRule(RelBuilderFactory relBuilderFactory) {
            super(ProjectToLogicalProjectAndWindowRule.operand(Project.class, null, PREDICATE2, ProjectToLogicalProjectAndWindowRule.any()), relBuilderFactory, "ProjectToWindowRule:project");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            assert (RexOver.containsOver(project.getProjects(), null));
            RelNode input = project.getInput();
            RexProgram program = RexProgram.create(input.getRowType(), project.getProjects(), null, project.getRowType(), project.getCluster().getRexBuilder());
            LogicalCalc calc = LogicalCalc.create(input, program);
            WindowedAggRelSplitter transform = new WindowedAggRelSplitter(calc, call.builder()){

                @Override
                protected RelNode handle(RelNode rel) {
                    if (!(rel instanceof LogicalCalc)) {
                        return rel;
                    }
                    LogicalCalc calc = (LogicalCalc)rel;
                    final RexProgram program = calc.getProgram();
                    this.relBuilder.push(calc.getInput());
                    if (program.getCondition() != null) {
                        this.relBuilder.filter(program.expandLocalRef(program.getCondition()));
                    }
                    if (!program.projectsOnlyIdentity()) {
                        this.relBuilder.project(Lists.transform(program.getProjectList(), new Function<RexLocalRef, RexNode>(){

                            @Override
                            public RexNode apply(RexLocalRef a0) {
                                return program.expandLocalRef(a0);
                            }
                        }), calc.getRowType().getFieldNames());
                    }
                    return this.relBuilder.build();
                }
            };
            RelNode newRel = transform.execute();
            call.transformTo(newRel);
        }
    }

    public static class CalcToWindowRule
    extends ProjectToWindowRule {
        public CalcToWindowRule(RelBuilderFactory relBuilderFactory) {
            super(CalcToWindowRule.operand(Calc.class, null, PREDICATE, CalcToWindowRule.any()), relBuilderFactory, "ProjectToWindowRule");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Calc calc = (Calc)call.rel(0);
            assert (RexOver.containsOver(calc.getProgram()));
            WindowedAggRelSplitter transform = new WindowedAggRelSplitter(calc, call.builder());
            RelNode newRel = transform.execute();
            call.transformTo(newRel);
        }
    }
}

