/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.common.utils.VMUtils;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.SequenceWrapper;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryToolChest;

public class CPUTimeMetricQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> delegate;
    private final QueryToolChest<T, ? extends Query<T>> queryToolChest;
    private final ServiceEmitter emitter;
    private final AtomicLong cpuTimeAccumulator;
    private final boolean report;

    private CPUTimeMetricQueryRunner(QueryRunner<T> delegate, QueryToolChest<T, ? extends Query<T>> queryToolChest, ServiceEmitter emitter, AtomicLong cpuTimeAccumulator, boolean report) {
        if (!VMUtils.isThreadCpuTimeEnabled()) {
            throw new ISE("Cpu time must enabled", new Object[0]);
        }
        this.delegate = delegate;
        this.queryToolChest = queryToolChest;
        this.emitter = emitter;
        this.cpuTimeAccumulator = cpuTimeAccumulator == null ? new AtomicLong(0L) : cpuTimeAccumulator;
        this.report = report;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
        final QueryPlus<T> queryWithMetrics = queryPlus.withQueryMetrics(this.queryToolChest);
        Sequence<T> baseSequence = this.delegate.run(queryWithMetrics, responseContext);
        return Sequences.wrap(baseSequence, new SequenceWrapper(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <RetType> RetType wrap(Supplier<RetType> sequenceProcessing) {
                long start = VMUtils.getCurrentThreadCpuTime();
                try {
                    RetType RetType = sequenceProcessing.get();
                    return RetType;
                }
                finally {
                    CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.addAndGet(VMUtils.getCurrentThreadCpuTime() - start);
                }
            }

            @Override
            public void after(boolean isDone, Throwable thrown) throws Exception {
                long cpuTimeNs;
                if (CPUTimeMetricQueryRunner.this.report && (cpuTimeNs = CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.get()) > 0L) {
                    queryWithMetrics.getQueryMetrics().reportCpuTime(cpuTimeNs).emit(CPUTimeMetricQueryRunner.this.emitter);
                }
            }
        });
    }

    public static <T> QueryRunner<T> safeBuild(QueryRunner<T> delegate, QueryToolChest<T, ? extends Query<T>> queryToolChest, ServiceEmitter emitter, AtomicLong accumulator, boolean report) {
        if (!VMUtils.isThreadCpuTimeEnabled()) {
            return delegate;
        }
        return new CPUTimeMetricQueryRunner<T>(delegate, queryToolChest, emitter, accumulator, report);
    }
}

