/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections.bitmap;

import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.extendedset.intset.ConciseSet;
import org.apache.hive.druid.io.druid.extendedset.intset.ImmutableConciseSet;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;

public class WrappedConciseBitmap
implements MutableBitmap {
    private ConciseSet bitmap;

    public WrappedConciseBitmap() {
        this.bitmap = new ConciseSet();
    }

    public WrappedConciseBitmap(ConciseSet conciseSet) {
        this.bitmap = conciseSet;
    }

    ConciseSet getBitmap() {
        return this.bitmap;
    }

    @Override
    public byte[] toBytes() {
        return ImmutableConciseSet.newImmutableFromMutable(this.bitmap).toBytes();
    }

    @Override
    public void clear() {
        this.bitmap.clear();
    }

    @Override
    public void or(MutableBitmap mutableBitmap) {
        WrappedConciseBitmap other = (WrappedConciseBitmap)mutableBitmap;
        ConciseSet unwrappedOtherBitmap = other.bitmap;
        this.bitmap.addAll(unwrappedOtherBitmap);
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.getWords().length * 4;
    }

    @Override
    public void add(int entry) {
        this.bitmap.add(entry);
    }

    @Override
    public int size() {
        return this.bitmap.size();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.bitmap.toString();
    }

    @Override
    public void remove(int entry) {
        this.bitmap.remove(entry);
    }

    @Override
    public IntIterator iterator() {
        return this.bitmap.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.size() == 0;
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedConciseBitmap other = (WrappedConciseBitmap)otherBitmap;
        ConciseSet unwrappedOtherBitmap = other.bitmap;
        return new WrappedConciseBitmap(this.bitmap.clone().intersection(unwrappedOtherBitmap));
    }

    @Override
    public boolean get(int value) {
        return this.bitmap.contains(value);
    }
}

