/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.unstable.grammar;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.junit.Test;
import org.skife.jdbi.rewriter.colon.ColonStatementLexer;
import org.skife.jdbi.v2.unstable.grammar.GrammarTestCase;

public class TestColonGrammar
extends GrammarTestCase {
    @Test
    public void testNamedOnly() throws Exception {
        this.expect("select id from something where name like ':foo' and id = :id and name like :name", 8, 11, 8, 9, 8, 9, -1);
    }

    @Test
    public void testEmptyQuote() throws Exception {
        this.expect("select ''", 8, 11, -1);
    }

    @Test
    public void testEscapedEmptyQuote() throws Exception {
        this.expect("select '\\''", 8, 11, -1);
    }

    @Test
    public void testEscapedColon() throws Exception {
        this.expect("insert into foo (val) VALUE (:bar\\:\\:type)", 8, 9, 6, 6, 8, -1);
    }

    @Test
    public void testMixed() throws Exception {
        this.expect("select id from something where name like ':foo' and id = ? and name like :name", 8, 11, 8, 10, 8, 9, -1);
    }

    @Test
    public void testThisBrokeATest() throws Exception {
        this.expect("insert into something (id, name) values (:id, :name)", 8, 9, 8, 9, 8, -1);
    }

    @Test
    public void testExclamationWorks() throws Exception {
        this.expect("select1 != 2 from dual", 8, -1);
    }

    @Test
    public void testHashInColumnNameWorks() throws Exception {
        this.expect("select col# from something where id = :id", 8, 9, -1);
    }

    @Override
    protected String nameOf(int type) {
        switch (type) {
            case 8: {
                return "LITERAL";
            }
            case 11: {
                return "QUOTED_TEXT";
            }
            case 9: {
                return "NAMED_PARAM";
            }
            case -1: {
                return "EOF";
            }
        }
        return String.valueOf(type);
    }

    @Override
    protected Lexer createLexer(String s) {
        return new ColonStatementLexer((CharStream)new ANTLRStringStream(s));
    }
}

