/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.MapWith;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapperFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestRegisterMapperFactory {
    private Handle handle;
    private DBI dbi;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testSimple() throws Exception {
        FooDao fooDao = (FooDao)this.dbi.onDemand(FooDao.class);
        List<Foo> foos = fooDao.select();
        Assert.assertNotNull(foos);
        Assert.assertEquals((long)0L, (long)foos.size());
        fooDao.insert(1, "John Doe");
        fooDao.insert(2, "Jane Doe");
        List<Foo> foos2 = fooDao.select();
        Assert.assertNotNull(foos2);
        Assert.assertEquals((long)2L, (long)foos2.size());
    }

    @MapWith(value=FooMapper.class)
    public static class Foo {
        private final int id;
        private final String name;

        Foo(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static class FooMapper
        implements ResultSetMapper<Foo> {
            public Foo map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                return new Foo(r.getInt("id"), r.getString("name"));
            }
        }
    }

    public static class MyFactory
    implements ResultSetMapperFactory {
        public boolean accepts(Class type, StatementContext ctx) {
            return type.isAnnotationPresent(MapWith.class);
        }

        public ResultSetMapper mapperFor(Class type, StatementContext ctx) {
            MapWith rm = type.getAnnotation(MapWith.class);
            try {
                return rm.value().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @RegisterMapperFactory(value={MyFactory.class})
    public static interface FooDao {
        @SqlQuery(value="select * from something")
        public List<Foo> select();

        @SqlUpdate(value="insert into something (id, name) VALUES (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);
    }
}

