/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.postgresql.Driver;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.Transaction;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.mixins.Transactional;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.IntegerMapper;

public class TestPostgresBugs {
    private static DBI createDbi() {
        String user = System.getenv("POSTGRES_USER");
        String pass = System.getenv("POSTGRES_PASS");
        String url = System.getenv("POSTGRES_URL");
        Assume.assumeThat((Object)user, (Matcher)CoreMatchers.notNullValue());
        Assume.assumeThat((Object)url, (Matcher)CoreMatchers.notNullValue());
        Driver.getVersion();
        return new DBI(url, user, pass);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TestPostgresBugs.createDbi().withHandle((HandleCallback)new HandleCallback<Object>(){

            public Object withHandle(Handle handle) throws Exception {
                handle.execute("create table if not exists something (id int primary key, name varchar(100))", new Object[0]);
                handle.execute("delete from something", new Object[0]);
                return null;
            }
        });
    }

    @Test
    public void testConnected() throws Exception {
        DBI dbi = TestPostgresBugs.createDbi();
        int four = (Integer)dbi.withHandle((HandleCallback)new HandleCallback<Integer>(){

            public Integer withHandle(Handle handle) throws Exception {
                return (Integer)handle.createQuery("select 2 + 2").map((ResultSetMapper)IntegerMapper.FIRST).first();
            }
        });
        Assert.assertThat((Object)four, (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void testTransactions() throws Exception {
        DBI dbi = TestPostgresBugs.createDbi();
        Dao dao = (Dao)dbi.onDemand(Dao.class);
        dao.begin();
        Something s = dao.insertAndFetch(1, "Brian");
        dao.commit();
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.equalTo((Object)new Something(1, "Brian")));
    }

    @Test
    public void testExplicitBeginAndInTransaction() throws Exception {
        DBI dbi = TestPostgresBugs.createDbi();
        Dao dao = (Dao)dbi.onDemand(Dao.class);
        dao.begin();
        Something s = (Something)dao.inTransaction((org.skife.jdbi.v2.Transaction)new org.skife.jdbi.v2.Transaction<Something, Dao>(){

            public Something inTransaction(Dao transactional, TransactionStatus status) throws Exception {
                return transactional.insertAndFetch(1, "Brian");
            }
        });
        dao.commit();
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.equalTo((Object)new Something(1, "Brian")));
    }

    @RegisterMapper(value={SomethingMapper.class})
    public static abstract class Dao
    implements Transactional<Dao> {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public abstract void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public abstract Something findById(@Bind(value="id") int var1);

        @Transaction(value=TransactionIsolationLevel.READ_COMMITTED)
        public Something insertAndFetch(int id, String name) {
            this.insert(id, name);
            return this.findById(id);
        }

        @Transaction
        public Something insertAndFetchWithNestedTransaction(int id, String name) {
            return this.insertAndFetch(id, name);
        }

        @Transaction
        public Something failed(int id, String name) throws IOException {
            this.insert(id, name);
            throw new IOException("woof");
        }
    }
}

