/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.logging.PrintStreamLog;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.tweak.SQLLog;

public class TestPositionalBinder {
    private Handle handle;
    private SomethingDao somethingDao;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        DBI dbi = new DBI((DataSource)ds);
        dbi.setSQLLog((SQLLog)new PrintStreamLog());
        this.handle = dbi.open();
        this.somethingDao = (SomethingDao)this.handle.attach(SomethingDao.class);
        this.handle.execute("create table something (something_id int primary key, name varchar(100), code int)", new Object[0]);
        this.handle.execute("insert into something(something_id, name, code) values (1, 'Brian', 12)", new Object[0]);
        this.handle.execute("insert into something(something_id, name, code) values (2, 'Keith', 27)", new Object[0]);
        this.handle.execute("insert into something(something_id, name, code) values (3, 'Coda', 14)", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.close();
    }

    @Test
    public void testOnePositionalParameter() {
        String name = this.somethingDao.findNameById(2);
        Assert.assertEquals((Object)"Keith", (Object)name);
    }

    @Test
    public void testManyPositionalParameters() {
        Integer id = this.somethingDao.getIdByNameAndCode("Coda", 14);
        Assert.assertEquals((long)3L, (long)id.intValue());
    }

    @Test
    public void testInsertWithPositionalParameters() {
        this.somethingDao.insertSomething(4, "Dave", 90);
        List rows = this.handle.select("select * from something where something_id=?", new Object[]{4});
        Assert.assertEquals((long)rows.size(), (long)1L);
        Map row = (Map)rows.get(0);
        Assert.assertEquals(row.get("something_id"), (Object)4);
        Assert.assertEquals(row.get("name"), (Object)"Dave");
        Assert.assertEquals(row.get("code"), (Object)90);
    }

    @Test
    public void testInsertWithDefaultParams() {
        this.somethingDao.insertWithDefaultParams("Greg", 21);
        List rows = this.handle.select("select * from something where something_id=?", new Object[]{19});
        Assert.assertEquals((long)rows.size(), (long)1L);
        Map row = (Map)rows.get(0);
        Assert.assertEquals(row.get("something_id"), (Object)19);
        Assert.assertEquals(row.get("name"), (Object)"Greg");
        Assert.assertEquals(row.get("code"), (Object)21);
    }

    static interface SomethingDao {
        @SqlQuery(value="select name from something where something_id=:0")
        public String findNameById(int var1);

        @SqlQuery(value="select something_id from something where name=:0 and code=:1")
        public Integer getIdByNameAndCode(String var1, int var2);

        @SqlUpdate(value="insert into something(something_id, name, code) values (:0, :1, :2)")
        public void insertSomething(int var1, String var2, int var3);

        @SqlUpdate(value="insert into something(something_id,name, code) values (19, :0, :code)")
        public void insertWithDefaultParams(String var1, @Bind(value="code") int var2);
    }
}

