/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.FetchSize;
import org.skife.jdbi.v2.sqlobject.customizers.MaxRows;
import org.skife.jdbi.v2.sqlobject.customizers.QueryTimeOut;
import org.skife.jdbi.v2.sqlobject.customizers.TransactionIsolation;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;
import org.skife.jdbi.v2.sqlobject.mixins.Transactional;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestModifiers {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.dbi.registerMapper((ResultSetMapper)new SomethingMapper());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testFetchSizeAsArgOnlyUsefulWhenSteppingThroughDebuggerSadly() throws Exception {
        Spiffy s = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAll(1);
        Assert.assertEquals((long)3L, (long)things.size());
    }

    @Test
    public void testFetchSizeOnMethodOnlyUsefulWhenSteppingThroughDebuggerSadly() throws Exception {
        Spiffy s = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAll();
        Assert.assertEquals((long)3L, (long)things.size());
    }

    @Test
    public void testMaxSizeOnMethod() throws Exception {
        Spiffy s = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAllWithMaxRows();
        Assert.assertEquals((long)1L, (long)things.size());
    }

    @Test
    public void testMaxSizeOnParam() throws Exception {
        Spiffy s = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAllWithMaxRows(2);
        Assert.assertEquals((long)2L, (long)things.size());
    }

    @Test
    public void testQueryTimeOutOnMethodOnlyUsefulWhenSteppingThroughDebuggerSadly() throws Exception {
        Spiffy s = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAllWithQueryTimeOut();
        Assert.assertEquals((long)3L, (long)things.size());
    }

    @Test
    public void testQueryTimeOutOnParamOnlyUsefulWhenSteppingThroughDebuggerSadly() throws Exception {
        Spiffy s = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAllWithQueryTimeOut(2);
        Assert.assertEquals((long)3L, (long)things.size());
    }

    @Test
    public void testIsolationLevelOnMethod() throws Exception {
        Spiffy spiffy = (Spiffy)this.dbi.open(Spiffy.class);
        IsoLevels iso = (IsoLevels)this.dbi.open(IsoLevels.class);
        spiffy.begin();
        spiffy.insert(1L, "Tom");
        Something tom = iso.findById(1);
        Assert.assertThat((Object)tom, (Matcher)CoreMatchers.notNullValue());
        spiffy.rollback();
        Something not_tom = iso.findById(1);
        Assert.assertThat((Object)not_tom, (Matcher)CoreMatchers.nullValue());
        spiffy.close();
        iso.close();
    }

    @Test
    public void testIsolationLevelOnParam() throws Exception {
        Spiffy spiffy = (Spiffy)this.dbi.open(Spiffy.class);
        IsoLevels iso = (IsoLevels)this.dbi.open(IsoLevels.class);
        spiffy.begin();
        spiffy.insert(1L, "Tom");
        Something tom = iso.findById(1, TransactionIsolationLevel.READ_UNCOMMITTED);
        Assert.assertThat((Object)tom, (Matcher)CoreMatchers.notNullValue());
        spiffy.rollback();
        Something not_tom = iso.findById(1);
        Assert.assertThat((Object)not_tom, (Matcher)CoreMatchers.nullValue());
        spiffy.close();
        iso.close();
    }

    public static interface IsoLevels
    extends CloseMe {
        @TransactionIsolation(value=TransactionIsolationLevel.READ_UNCOMMITTED)
        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1, @TransactionIsolation TransactionIsolationLevel var2);
    }

    public static interface Spiffy
    extends CloseMe,
    Transactional<Spiffy> {
        @SqlQuery(value="select id, name from something where id = :id")
        public Something byId(@Bind(value="id") long var1);

        @SqlQuery(value="select id, name from something")
        public List<Something> findAll(@FetchSize(value=1) int var1);

        @SqlQuery(value="select id, name from something")
        @FetchSize(value=2)
        public List<Something> findAll();

        @SqlQuery(value="select id, name from something")
        public List<Something> findAllWithMaxRows(@MaxRows(value=1) int var1);

        @SqlQuery(value="select id, name from something")
        @MaxRows(value=1)
        public List<Something> findAllWithMaxRows();

        @SqlQuery(value="select id, name from something")
        public List<Something> findAllWithQueryTimeOut(@QueryTimeOut(value=1) int var1);

        @SqlQuery(value="select id, name from something")
        @QueryTimeOut(value=1)
        public List<Something> findAllWithQueryTimeOut();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }
}

