/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.LongMapper;

public class TestUpdateGeneratedKeys
extends DBITestCase {
    @Override
    protected void doSetUp() throws Exception {
        Connection conn = DERBY_HELPER.getConnection();
        Statement create = conn.createStatement();
        try {
            create.execute("create table something_else ( id integer not null generated always as identity, name varchar(50) )");
        }
        catch (Exception e) {
            create.execute("delete from something_else");
        }
        create.close();
        conn.close();
    }

    @Test
    public void testInsert() throws Exception {
        BasicHandle h = this.openHandle();
        Update insert1 = h.createStatement("insert into something_else (name) values (:name)");
        insert1.bind("name", "Brian");
        Long id1 = (Long)insert1.executeAndReturnGeneratedKeys((ResultSetMapper)LongMapper.FIRST).first();
        Assert.assertNotNull((Object)id1);
        Update insert2 = h.createStatement("insert into something_else (name) values (:name)");
        insert2.bind("name", "Tom");
        Long id2 = (Long)insert2.executeAndReturnGeneratedKeys((ResultSetMapper)LongMapper.FIRST).first();
        Assert.assertNotNull((Object)id2);
        Assert.assertTrue((id2 > id1 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdate() throws Exception {
        BasicHandle h = this.openHandle();
        Update insert = h.createStatement("insert into something_else (name) values (:name)");
        insert.bind("name", "Brian");
        Long id1 = (Long)insert.executeAndReturnGeneratedKeys((ResultSetMapper)LongMapper.FIRST).first();
        Assert.assertNotNull((Object)id1);
        Update update = h.createStatement("update something_else set name = :name where id = :id");
        update.bind("id", id1);
        update.bind("name", "Tom");
        Long id2 = (Long)update.executeAndReturnGeneratedKeys((ResultSetMapper)LongMapper.FIRST).first();
        Assert.assertNull((Object)id2);
    }

    @Test
    public void testDelete() throws Exception {
        BasicHandle h = this.openHandle();
        Update insert = h.createStatement("insert into something_else (name) values (:name)");
        insert.bind("name", "Brian");
        Long id1 = (Long)insert.executeAndReturnGeneratedKeys((ResultSetMapper)LongMapper.FIRST).first();
        Assert.assertNotNull((Object)id1);
        Update delete = h.createStatement("delete from something_else where id = :id");
        delete.bind("id", id1);
        Long id2 = (Long)delete.executeAndReturnGeneratedKeys((ResultSetMapper)LongMapper.FIRST).first();
        Assert.assertNull((Object)id2);
    }
}

