/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.ColonPrefixNamedParamStatementRewriter;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.tweak.RewrittenStatement;

public class TestColonStatementRewriter {
    private ColonPrefixNamedParamStatementRewriter rw;

    @Before
    public void setUp() throws Exception {
        this.rw = new ColonPrefixNamedParamStatementRewriter();
    }

    @Test
    public void testNewlinesOkay() throws Exception {
        RewrittenStatement rws = this.rw.rewrite("select * from something\n where id = :id", new Binding(), (StatementContext)new ConcreteStatementContext(new HashMap()));
        Assert.assertEquals((Object)"select * from something\n where id = ?", (Object)rws.getSql());
    }

    @Test
    public void testOddCharacters() throws Exception {
        RewrittenStatement rws = this.rw.rewrite("~* :boo ':nope' _%&^& *@ :id", new Binding(), (StatementContext)new ConcreteStatementContext(new HashMap()));
        Assert.assertEquals((Object)"~* ? ':nope' _%&^& *@ ?", (Object)rws.getSql());
    }

    @Test
    public void testNumbers() throws Exception {
        RewrittenStatement rws = this.rw.rewrite(":bo0 ':nope' _%&^& *@ :id", new Binding(), (StatementContext)new ConcreteStatementContext(new HashMap()));
        Assert.assertEquals((Object)"? ':nope' _%&^& *@ ?", (Object)rws.getSql());
    }

    @Test
    public void testDollarSignOkay() throws Exception {
        RewrittenStatement rws = this.rw.rewrite("select * from v$session", new Binding(), (StatementContext)new ConcreteStatementContext(new HashMap()));
        Assert.assertEquals((Object)"select * from v$session", (Object)rws.getSql());
    }

    @Test
    public void testHashInColumnNameOkay() throws Exception {
        RewrittenStatement rws = this.rw.rewrite("select column# from thetable where id = :id", new Binding(), (StatementContext)new ConcreteStatementContext(new HashMap()));
        Assert.assertEquals((Object)"select column# from thetable where id = ?", (Object)rws.getSql());
    }

    @Test
    public void testBacktickOkay() throws Exception {
        RewrittenStatement rws = this.rw.rewrite("select * from `v$session", new Binding(), (StatementContext)new ConcreteStatementContext(new HashMap()));
        Assert.assertEquals((Object)"select * from `v$session", (Object)rws.getSql());
    }

    @Test
    public void testBailsOutOnInvalidInput() throws Exception {
        try {
            this.rw.rewrite("select * from something\n where id = :\u0087\u008e\u0092\u0097\u009c", new Binding(), (StatementContext)new ConcreteStatementContext(new HashMap()));
            Assert.fail((String)"Expected 'UnableToCreateStatementException' but got none");
        }
        catch (UnableToCreateStatementException unableToCreateStatementException) {
            // empty catch block
        }
    }
}

