/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.AbstractBasicTest;
import org.asynchttpclient.ws.EchoSocket;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketCloseCodeReasonListener;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketTextListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CloseCodeReasonMessageTest
extends AbstractBasicTest {
    @Override
    public WebSocketHandler getWebSocketHandler() {
        return new WebSocketHandler(){

            public void configure(WebSocketServletFactory factory) {
                factory.register(EchoSocket.class);
            }
        };
    }

    @Test(groups={"standalone"}, timeOut=60000L)
    public void onCloseWithCode() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new Listener(latch, text)).build()).get();
            websocket.close();
            latch.await();
            Assert.assertTrue((boolean)text.get().startsWith("1000"), (String)("Expected a 1000 code but got " + text.get()));
        }
    }

    @Test(groups={"standalone"}, timeOut=60000L)
    public void onCloseWithCodeServerClose() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<String> text = new AtomicReference<String>("");
            c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new Listener(latch, text)).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"1001-Idle Timeout");
        }
    }

    @Test(groups={"online"}, timeOut=60000L, expectedExceptions={ExecutionException.class})
    public void getWebSocketThrowsException() throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            client.prepareGet("http://apache.org").execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                }

                public void onError(Throwable t) {
                    latch.countDown();
                }
            }).build()).get();
        }
        latch.await();
    }

    @Test(groups={"online"}, timeOut=60000L, expectedExceptions={IllegalArgumentException.class})
    public void wrongStatusCode() throws Throwable {
        AsyncHttpClient client = Dsl.asyncHttpClient();
        Throwable throwable = null;
        try {
            try {
                final CountDownLatch latch = new CountDownLatch(1);
                final AtomicReference throwable2 = new AtomicReference();
                client.prepareGet("http://apache.org").execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                    public void onMessage(String message) {
                    }

                    public void onOpen(WebSocket websocket) {
                    }

                    public void onClose(WebSocket websocket) {
                    }

                    public void onError(Throwable t) {
                        throwable2.set(t);
                        latch.countDown();
                    }
                }).build());
                latch.await();
                Assert.assertNotNull(throwable2.get());
                throw (Throwable)throwable2.get();
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            if (client != null) {
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    client.close();
                }
            }
            throw throwable4;
        }
    }

    @Test(groups={"online"}, timeOut=60000L, expectedExceptions={IllegalStateException.class})
    public void wrongProtocolCode() throws Throwable {
        AsyncHttpClient c = Dsl.asyncHttpClient();
        Throwable throwable = null;
        try {
            try {
                final CountDownLatch latch = new CountDownLatch(1);
                final AtomicReference throwable2 = new AtomicReference();
                c.prepareGet("ws://www.google.com").execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                    public void onMessage(String message) {
                    }

                    public void onOpen(WebSocket websocket) {
                    }

                    public void onClose(WebSocket websocket) {
                    }

                    public void onError(Throwable t) {
                        throwable2.set(t);
                        latch.countDown();
                    }
                }).build());
                latch.await();
                Assert.assertNotNull(throwable2.get());
                throw (Throwable)throwable2.get();
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            if (c != null) {
                if (throwable != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    c.close();
                }
            }
            throw throwable4;
        }
    }

    public static final class Listener
    implements WebSocketListener,
    WebSocketCloseCodeReasonListener {
        final CountDownLatch latch;
        final AtomicReference<String> text;

        public Listener(CountDownLatch latch, AtomicReference<String> text) {
            this.latch = latch;
            this.text = text;
        }

        public void onOpen(WebSocket websocket) {
        }

        public void onClose(WebSocket websocket) {
            this.latch.countDown();
        }

        public void onClose(WebSocket websocket, int code, String reason) {
            this.text.set(code + "-" + reason);
            this.latch.countDown();
        }

        public void onError(Throwable t) {
            t.printStackTrace();
            this.latch.countDown();
        }
    }
}

