/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.StringPart;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MultipartUploadTest
extends AbstractBasicTest {
    public static byte[] GZIPTEXT = new byte[]{31, -117, 8, 8, 11, 43, 79, 75, 0, 3, 104, 101, 108, 108, 111, 46, 116, 120, 116, 0, -53, 72, -51, -55, -55, -25, 2, 0, 32, 48, 58, 54, 6, 0, 0, 0};

    @BeforeClass
    public void setUp() throws Exception {
        this.server = new Server();
        ServerConnector connector = TestUtils.addHttpConnector(this.server);
        ServletContextHandler context = new ServletContextHandler(1);
        context.addServlet(new ServletHolder((Servlet)new MockMultipartUploadServlet()), "/upload/*");
        this.server.setHandler((Handler)context);
        this.server.start();
        this.port1 = connector.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone"})
    public void testSendingSmallFilesAndByteArray() throws IOException {
        Throwable throwable;
        String expectedContents = "filecontent: hello";
        String expectedContents2 = "gzipcontent: hello";
        String expectedContents3 = "filecontent: hello2";
        String testResource1 = "textfile.txt";
        String testResource2 = "gzip.txt.gz";
        String testResource3 = "textfile2.txt";
        File testResource1File = null;
        try {
            testResource1File = TestUtils.getClasspathFile(testResource1);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("unable to find " + testResource1));
        }
        File testResource2File = null;
        try {
            testResource2File = TestUtils.getClasspathFile(testResource2);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("unable to find " + testResource2));
        }
        File testResource3File = null;
        try {
            testResource3File = TestUtils.getClasspathFile(testResource3);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("unable to find " + testResource3));
        }
        ArrayList<File> testFiles = new ArrayList<File>();
        testFiles.add(testResource1File);
        testFiles.add(testResource2File);
        testFiles.add(testResource3File);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(expectedContents);
        expected.add(expectedContents2);
        expected.add(expectedContents3);
        ArrayList<Boolean> gzipped = new ArrayList<Boolean>();
        gzipped.add(false);
        gzipped.add(true);
        gzipped.add(false);
        boolean tmpFileCreated = false;
        File tmpFile = File.createTempFile("textbytearray", ".txt");
        try {
            throwable = null;
            try (FileOutputStream os = new FileOutputStream(tmpFile);){
                IOUtils.write((byte[])expectedContents.getBytes(StandardCharsets.UTF_8), (OutputStream)os);
                tmpFileCreated = true;
                testFiles.add(tmpFile);
                expected.add(expectedContents);
                gzipped.add(false);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (!tmpFileCreated) {
            Assert.fail((String)"Unable to test ByteArrayMultiPart, as unable to write to filesystem the tmp test content");
        }
        try {
            throwable = null;
            try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true));){
                RequestBuilder builder = Dsl.post((String)("http://localhost:" + this.port1 + "/upload/bob"));
                builder.addBodyPart((Part)new FilePart("file1", testResource1File, "text/plain", StandardCharsets.UTF_8));
                builder.addBodyPart((Part)new FilePart("file2", testResource2File, "application/x-gzip", null));
                builder.addBodyPart((Part)new StringPart("Name", "Dominic"));
                builder.addBodyPart((Part)new FilePart("file3", testResource3File, "text/plain", StandardCharsets.UTF_8));
                builder.addBodyPart((Part)new StringPart("Age", "3"));
                builder.addBodyPart((Part)new StringPart("Height", "shrimplike"));
                builder.addBodyPart((Part)new StringPart("Hair", "ridiculous"));
                builder.addBodyPart((Part)new ByteArrayPart("file4", expectedContents.getBytes(StandardCharsets.UTF_8), "text/plain", StandardCharsets.UTF_8, "bytearray.txt"));
                Request r = builder.build();
                Response res = (Response)c.executeRequest(r).get();
                Assert.assertEquals((int)res.getStatusCode(), (int)200);
                this.testSentFile(expected, testFiles, res, gzipped);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Download Exception");
        }
        finally {
            FileUtils.deleteQuietly((File)tmpFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSentFile(List<String> expectedContents, List<File> sourceFiles, Response r, List<Boolean> deflate) {
        String content = r.getResponseBody();
        Assert.assertNotNull((Object)("===>" + content));
        this.logger.debug(content);
        String[] contentArray = content.split("\\|\\|");
        Assert.assertEquals((int)contentArray.length, (int)2);
        String tmpFiles = contentArray[1];
        Assert.assertNotNull((Object)tmpFiles);
        Assert.assertTrue((tmpFiles.trim().length() > 2 ? 1 : 0) != 0);
        tmpFiles = tmpFiles.substring(1, tmpFiles.length() - 1);
        Object[] responseFiles = tmpFiles.split(",");
        Assert.assertNotNull((Object)responseFiles);
        Assert.assertEquals((int)responseFiles.length, (int)sourceFiles.size());
        this.logger.debug(Arrays.toString(responseFiles));
        int i = 0;
        for (File sourceFile : sourceFiles) {
            block55: {
                File tmp = null;
                try {
                    byte[] bytes;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] sourceBytes = null;
                    try (FileInputStream instream = new FileInputStream(sourceFile);){
                        byte[] buf = new byte[8092];
                        int len = 0;
                        while ((len = instream.read(buf)) > 0) {
                            baos.write(buf, 0, len);
                        }
                        this.logger.debug("================");
                        this.logger.debug("Length of file: " + baos.toByteArray().length);
                        this.logger.debug("Contents: " + Arrays.toString(baos.toByteArray()));
                        this.logger.debug("================");
                        System.out.flush();
                        sourceBytes = baos.toByteArray();
                    }
                    tmp = new File(((String)responseFiles[i]).trim());
                    this.logger.debug("==============================");
                    this.logger.debug(tmp.getAbsolutePath());
                    this.logger.debug("==============================");
                    System.out.flush();
                    Assert.assertTrue((boolean)tmp.exists());
                    try (FileInputStream instream = new FileInputStream(tmp);){
                        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                        byte[] buf = new byte[8092];
                        int len = 0;
                        while ((len = instream.read(buf)) > 0) {
                            baos2.write(buf, 0, len);
                        }
                        bytes = baos2.toByteArray();
                        Assert.assertEquals((Object)bytes, (Object)sourceBytes);
                    }
                    if (!deflate.get(i).booleanValue()) {
                        String helloString = new String(bytes);
                        Assert.assertEquals((String)helloString, (String)expectedContents.get(i));
                    } else {
                        instream = new FileInputStream(tmp);
                        var17_18 = null;
                        try {
                            ByteArrayOutputStream baos3 = new ByteArrayOutputStream();
                            try (GZIPInputStream deflater = new GZIPInputStream(instream);){
                                byte[] buf3 = new byte[8092];
                                int len3 = 0;
                                while ((len3 = deflater.read(buf3)) > 0) {
                                    baos3.write(buf3, 0, len3);
                                }
                            }
                            String helloString = new String(baos3.toByteArray());
                            Assert.assertEquals((String)expectedContents.get(i), (String)helloString);
                        }
                        catch (Throwable throwable) {
                            var17_18 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (instream != null) {
                                if (var17_18 != null) {
                                    try {
                                        instream.close();
                                    }
                                    catch (Throwable throwable) {
                                        var17_18.addSuppressed(throwable);
                                    }
                                } else {
                                    instream.close();
                                }
                            }
                        }
                    }
                    if (tmp == null) break block55;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)"Download Exception");
                    continue;
                }
                finally {
                    if (tmp != null) {
                        FileUtils.deleteQuietly(tmp);
                    }
                    ++i;
                    continue;
                }
                FileUtils.deleteQuietly((File)tmp);
            }
            ++i;
        }
    }

    public static class MockMultipartUploadServlet
    extends HttpServlet {
        private static final Logger LOGGER = LoggerFactory.getLogger(MockMultipartUploadServlet.class);
        private static final long serialVersionUID = 1L;
        private int filesProcessed = 0;
        private int stringsProcessed = 0;

        public synchronized void resetFilesProcessed() {
            this.filesProcessed = 0;
        }

        private synchronized int incrementFilesProcessed() {
            return ++this.filesProcessed;
        }

        public int getFilesProcessed() {
            return this.filesProcessed;
        }

        public synchronized void resetStringsProcessed() {
            this.stringsProcessed = 0;
        }

        private synchronized int incrementStringsProcessed() {
            return ++this.stringsProcessed;
        }

        public int getStringsProcessed() {
            return this.stringsProcessed;
        }

        public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (isMultipart) {
                ArrayList<String> files = new ArrayList<String>();
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iter = null;
                try {
                    iter = upload.getItemIterator(request);
                    while (iter.hasNext()) {
                        FileItemStream item = iter.next();
                        String name = item.getFieldName();
                        InputStream stream = item.openStream();
                        Throwable throwable = null;
                        try {
                            if (item.isFormField()) {
                                LOGGER.debug("Form field " + name + " with value " + Streams.asString((InputStream)stream) + " detected.");
                                this.incrementStringsProcessed();
                                continue;
                            }
                            LOGGER.debug("File field " + name + " with file name " + item.getName() + " detected.");
                            File tmpFile = File.createTempFile(UUID.randomUUID().toString() + "_MockUploadServlet", ".tmp");
                            tmpFile.deleteOnExit();
                            FileOutputStream os = new FileOutputStream(tmpFile);
                            Throwable throwable2 = null;
                            try {
                                int bytesRead;
                                byte[] buffer = new byte[4096];
                                while ((bytesRead = stream.read(buffer)) != -1) {
                                    ((OutputStream)os).write(buffer, 0, bytesRead);
                                }
                                this.incrementFilesProcessed();
                                files.add(tmpFile.getAbsolutePath());
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (os == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((OutputStream)os).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                ((OutputStream)os).close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                }
                catch (FileUploadException item) {
                    // empty catch block
                }
                try (PrintWriter w = response.getWriter();){
                    ((Writer)w).write(Integer.toString(this.getFilesProcessed()));
                    this.resetFilesProcessed();
                    this.resetStringsProcessed();
                    ((Writer)w).write("||");
                    ((Writer)w).write(((Object)files).toString());
                }
            }
            try (PrintWriter w = response.getWriter();){
                ((Writer)w).write(Integer.toString(this.getFilesProcessed()));
                this.resetFilesProcessed();
                this.resetStringsProcessed();
                ((Writer)w).write("||");
            }
        }
    }
}

