/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PutFileTest
extends AbstractBasicTest {
    private void put(int fileSize) throws Exception {
        File file = TestUtils.createTempFile(fileSize);
        int timeout = (int)file.length() / 1000;
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(timeout));){
            Response response = (Response)((BoundRequestBuilder)client.preparePut(this.getTargetUrl()).setBody(file)).execute().get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone"})
    public void testPutLargeFile() throws Exception {
        this.put(0x100000);
    }

    @Test(groups={"standalone"})
    public void testPutSmallFile() throws Exception {
        this.put(1024);
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                ServletInputStream is = baseRequest.getInputStream();
                int read = 0;
                while ((read = is.read()) >= 0) {
                }
                response.setStatus(200);
                response.getOutputStream().flush();
                response.getOutputStream().close();
                baseRequest.setHandled(true);
            }
        };
    }
}

