/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import org.asynchttpclient.request.body.generator.UnboundedQueueFeedableBodyGenerator;
import org.asynchttpclient.test.TestUtils;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.Test;

public class ChunkingTest
extends AbstractBasicTest {
    @Test(groups={"standalone"})
    public void testBufferLargerThanFileWithStreamBodyGenerator() throws Throwable {
        this.doTestWithInputStreamBodyGenerator(new BufferedInputStream(new FileInputStream(TestUtils.LARGE_IMAGE_FILE), 400000));
    }

    @Test(groups={"standalone"})
    public void testBufferSmallThanFileWithStreamBodyGenerator() throws Throwable {
        this.doTestWithInputStreamBodyGenerator(new BufferedInputStream(new FileInputStream(TestUtils.LARGE_IMAGE_FILE)));
    }

    @Test(groups={"standalone"})
    public void testDirectFileWithStreamBodyGenerator() throws Throwable {
        this.doTestWithInputStreamBodyGenerator(new FileInputStream(TestUtils.LARGE_IMAGE_FILE));
    }

    @Test(groups={"standalone"})
    public void testDirectFileWithFeedableBodyGenerator() throws Throwable {
        this.doTestWithFeedableBodyGenerator(new FileInputStream(TestUtils.LARGE_IMAGE_FILE));
    }

    public void doTestWithInputStreamBodyGenerator(InputStream is) throws Throwable {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)this.httpClientBuilder());){
            RequestBuilder builder = (RequestBuilder)Dsl.post((String)this.getTargetUrl()).setBody((BodyGenerator)new InputStreamBodyGenerator(is));
            Request r = builder.build();
            ListenableFuture responseFuture = c.executeRequest(r);
            this.waitForAndAssertResponse((ListenableFuture<Response>)responseFuture);
        }
    }

    public void doTestWithFeedableBodyGenerator(InputStream is) throws Throwable {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)this.httpClientBuilder());){
            UnboundedQueueFeedableBodyGenerator feedableBodyGenerator = new UnboundedQueueFeedableBodyGenerator();
            Request r = ((RequestBuilder)Dsl.post((String)this.getTargetUrl()).setBody((BodyGenerator)feedableBodyGenerator)).build();
            ListenableFuture responseFuture = c.executeRequest(r);
            this.feed((FeedableBodyGenerator)feedableBodyGenerator, is);
            this.waitForAndAssertResponse((ListenableFuture<Response>)responseFuture);
        }
    }

    private void feed(FeedableBodyGenerator feedableBodyGenerator, InputStream is) throws Exception {
        try (InputStream inputStream = is;){
            byte[] buffer = new byte[512];
            int i = 0;
            while ((i = inputStream.read(buffer)) > -1) {
                byte[] chunk = new byte[i];
                System.arraycopy(buffer, 0, chunk, 0, i);
                feedableBodyGenerator.feed(ByteBuffer.wrap(chunk), false);
            }
        }
        feedableBodyGenerator.feed(ByteBuffer.allocate(0), true);
    }

    private DefaultAsyncHttpClientConfig.Builder httpClientBuilder() {
        return Dsl.config().setKeepAlive(true).setMaxConnectionsPerHost(1).setMaxConnections(1).setConnectTimeout(1000).setRequestTimeout(1000).setFollowRedirect(true);
    }

    private void waitForAndAssertResponse(ListenableFuture<Response> responseFuture) throws InterruptedException, ExecutionException, IOException {
        Response response = (Response)responseFuture.get();
        if (500 == response.getStatusCode()) {
            StringBuilder sb = new StringBuilder();
            sb.append("==============\n");
            sb.append("500 response from call\n");
            sb.append("Headers:" + response.getHeaders() + "\n");
            sb.append("==============\n");
            this.logger.debug(sb.toString());
            Assert.assertEquals((int)response.getStatusCode(), (int)500, (String)"Should have 500 status code");
            Assert.assertTrue((boolean)response.getHeader("X-Exception").contains("invalid.chunk.length"), (String)"Should have failed due to chunking");
            FileAssert.fail((String)("HARD Failing the test due to provided InputStreamBodyGenerator, chunking incorrectly:" + response.getHeader("X-Exception")));
        } else {
            Assert.assertEquals((Object)response.getResponseBodyAsBytes(), (Object)TestUtils.LARGE_IMAGE_BYTES);
        }
    }
}

