/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpMessage;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EventPipelineTest
extends AbstractBasicTest {
    @Test(groups={"standalone"})
    public void asyncPipelineTest() throws Exception {
        AsyncHttpClientConfig.AdditionalChannelInitializer httpAdditionalPipelineInitializer = new AsyncHttpClientConfig.AdditionalChannelInitializer(){

            public void initChannel(Channel channel) throws Exception {
                channel.pipeline().addBefore("inflater", "copyEncodingHeader", (ChannelHandler)new CopyEncodingHandler());
            }
        };
        try (AsyncHttpClient p = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setHttpAdditionalChannelInitializer(httpAdditionalPipelineInitializer));){
            final CountDownLatch l = new CountDownLatch(1);
            p.executeRequest(Dsl.get((String)this.getTargetUrl()), (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)200);
                        Assert.assertEquals((String)response.getHeader("X-Original-Content-Encoding"), (String)"<original encoding>");
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    private static class CopyEncodingHandler
    extends ChannelInboundHandlerAdapter {
        private CopyEncodingHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object e) {
            if (e instanceof HttpMessage) {
                HttpMessage m = (HttpMessage)e;
                m.headers().set("X-Original-Content-Encoding", (Object)"<original encoding>");
            }
            ctx.fireChannelRead(e);
        }
    }
}

