/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.cookie;

import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.cookie.CookieDecoder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CookieDecoderTest {
    @Test(groups={"standalone"})
    public void testDecodeUnquoted() {
        Cookie cookie = CookieDecoder.decode((String)"foo=value; domain=/; path=/");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((String)cookie.getValue(), (String)"value");
        Assert.assertEquals((boolean)cookie.isWrap(), (boolean)false);
        Assert.assertEquals((String)cookie.getDomain(), (String)"/");
        Assert.assertEquals((String)cookie.getPath(), (String)"/");
    }

    @Test(groups={"standalone"})
    public void testDecodeQuoted() {
        Cookie cookie = CookieDecoder.decode((String)"ALPHA=\"VALUE1\"; Domain=docs.foo.com; Path=/accounts; Expires=Wed, 05 Feb 2014 07:37:38 GMT; Secure; HttpOnly");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((String)cookie.getValue(), (String)"VALUE1");
        Assert.assertEquals((boolean)cookie.isWrap(), (boolean)true);
    }

    @Test(groups={"standalone"})
    public void testDecodeQuotedContainingEscapedQuote() {
        Cookie cookie = CookieDecoder.decode((String)"ALPHA=\"VALUE1\\\"\"; Domain=docs.foo.com; Path=/accounts; Expires=Wed, 05 Feb 2014 07:37:38 GMT; Secure; HttpOnly");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((String)cookie.getValue(), (String)"VALUE1\\\"");
        Assert.assertEquals((boolean)cookie.isWrap(), (boolean)true);
    }

    @Test(groups={"standalone"})
    public void testIgnoreEmptyDomain() {
        Cookie cookie = CookieDecoder.decode((String)"sessionid=OTY4ZDllNTgtYjU3OC00MWRjLTkzMWMtNGUwNzk4MTY0MTUw;Domain=;Path=/");
        Assert.assertNull((Object)cookie.getDomain());
    }
}

