/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class Expect100ContinueTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ZeroCopyHandler();
    }

    @Test(groups={"standalone"})
    public void Expect100Continue() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePut("http://localhost:" + this.port1 + "/").setHeader((CharSequence)"Expect", "100-continue")).setBody(TestUtils.SIMPLE_TEXT_FILE)).execute();
            Response resp = (Response)f.get();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)TestUtils.SIMPLE_TEXT_FILE_STRING);
        }
    }

    private static class ZeroCopyHandler
    extends AbstractHandler {
        private ZeroCopyHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            byte[] bytes;
            int size = 10240;
            if (httpRequest.getContentLength() > 0) {
                size = httpRequest.getContentLength();
            }
            if ((bytes = new byte[size]).length > 0) {
                int read = httpRequest.getInputStream().read(bytes);
                httpResponse.getOutputStream().write(bytes, 0, read);
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
        }
    }
}

