/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.util;

import java.math.BigDecimal;
import org.apache.hive.druid.org.apache.calcite.util.ReflectUtil;
import org.apache.hive.druid.org.apache.calcite.util.ReflectiveVisitDispatcher;
import org.apache.hive.druid.org.apache.calcite.util.ReflectiveVisitor;
import org.junit.Assert;
import org.junit.Test;

public class ReflectVisitorTest {
    @Test
    public void testCarelessNegater() {
        CarelessNumberNegater negater = new CarelessNumberNegater();
        Number result = negater.negate(5);
        Assert.assertEquals((long)-5L, (long)result.intValue());
    }

    @Test
    public void testCarefulNegater() {
        CarefulNumberNegater negater = new CarefulNumberNegater();
        Number result = negater.negate(5);
        Assert.assertEquals((long)-5L, (long)result.intValue());
        Assert.assertTrue((boolean)(result instanceof Integer));
        result = negater.negate(5L);
        Assert.assertEquals((long)-5L, (long)result.longValue());
    }

    @Test
    public void testCluelessNegater() {
        CluelessNumberNegater negater = new CluelessNumberNegater();
        Number result = negater.negate((short)5);
        Assert.assertEquals((long)-5L, (long)result.shortValue());
        Assert.assertTrue((boolean)(result instanceof Short));
        result = negater.negate(5);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testAmbiguity() {
        IndecisiveNumberNegater negater = new IndecisiveNumberNegater();
        try {
            Number result = negater.negate(new AmbiguousNumber());
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("ambiguity"));
            return;
        }
        Assert.fail((String)"Expected failure due to ambiguity");
    }

    @Test
    public void testNonAmbiguity() {
        SomewhatIndecisiveNumberNegater negater = new SomewhatIndecisiveNumberNegater();
        Number result = negater.negate(new SomewhatAmbiguousNumber());
        Assert.assertEquals((double)0.0, (double)result.doubleValue(), (double)0.001);
    }

    public class SomewhatAmbiguousNumber
    extends AmbiguousNumber
    implements DiceyNumber {
    }

    public class AmbiguousNumber
    extends BigDecimal
    implements CrunchableNumber,
    FudgeableNumber {
        AmbiguousNumber() {
            super("0");
        }
    }

    public class SomewhatIndecisiveNumberNegater
    extends NumberNegater {
        public void visit(FudgeableNumber n) {
        }

        public void visit(AmbiguousNumber n) {
            this.result = -n.doubleValue();
            assert (this.result instanceof Double);
        }
    }

    public class IndecisiveNumberNegater
    extends NumberNegater {
        public void visit(CrunchableNumber n) {
        }

        public void visit(FudgeableNumber n) {
        }
    }

    public class CluelessNumberNegater
    extends NumberNegater {
        public void visit(Object obj) {
            this.result = 42;
        }

        public void visit(Short s) {
            this.result = -s.shortValue();
            assert (this.result instanceof Short);
        }
    }

    public class CarefulNumberNegater
    extends CarelessNumberNegater {
        public void visit(Integer i) {
            this.result = -i.intValue();
            assert (this.result instanceof Integer);
        }

        public void visit(Short s) {
            this.result = (int)(-s.shortValue());
            assert (this.result instanceof Short);
        }
    }

    public class CarelessNumberNegater
    extends NumberNegater {
        public void visit(Number n) {
            this.result = -n.doubleValue();
        }
    }

    public abstract class NumberNegater
    implements ReflectiveVisitor {
        protected Number result;
        private final ReflectiveVisitDispatcher<NumberNegater, Number> dispatcher = ReflectUtil.createDispatcher(NumberNegater.class, Number.class);

        public Number negate(Number n) {
            this.result = null;
            this.dispatcher.invokeVisitor((ReflectiveVisitor)this, (Object)n, "visit");
            return this.result;
        }

        public Number negateWithoutDispatcher(Number n) {
            this.result = null;
            ReflectUtil.invokeVisitor((ReflectiveVisitor)this, (Object)n, Number.class, (String)"visit");
            return this.result;
        }
    }

    public static interface DiceyNumber
    extends FudgeableNumber {
    }

    public static interface FudgeableNumber {
    }

    public static interface CrunchableNumber {
    }
}

